/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Locale;
import org.apache.coyote.ActionCode;
import org.apache.coyote.CloseNowException;
import org.apache.coyote.Constants;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.http2.AbstractStream;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.HpackDecoder;
import org.apache.coyote.http2.HpackException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.Http2UpgradeHandler;
import org.apache.coyote.http2.StreamException;
import org.apache.coyote.http2.StreamStateMachine;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.res.StringManager;

class Stream
extends AbstractStream
implements HpackDecoder.HeaderEmitter {
    private static final Log log = LogFactory.getLog(Stream.class);
    private static final StringManager sm = StringManager.getManager(Stream.class);
    private static final int HEADER_STATE_START = 0;
    private static final int HEADER_STATE_PSEUDO = 1;
    private static final int HEADER_STATE_REGULAR = 2;
    private static final int HEADER_STATE_TRAILER = 3;
    private static final Response ACK_RESPONSE = new Response();
    private volatile int weight = 16;
    private volatile long contentLengthReceived = 0L;
    private final Http2UpgradeHandler handler;
    private final StreamStateMachine state;
    private int headerState = 0;
    private String headerStateErrorMsg = null;
    private final Request coyoteRequest;
    private StringBuilder cookieHeader = null;
    private final Response coyoteResponse = new Response();
    private final StreamInputBuffer inputBuffer;
    private final StreamOutputBuffer outputBuffer = new StreamOutputBuffer();

    Stream(Integer identifier, Http2UpgradeHandler handler) {
        this(identifier, handler, null);
    }

    Stream(Integer identifier, Http2UpgradeHandler handler, Request coyoteRequest) {
        super(identifier);
        this.handler = handler;
        this.setParentStream(handler);
        this.setWindowSize(handler.getRemoteSettings().getInitialWindowSize());
        this.state = new StreamStateMachine(this);
        if (coyoteRequest == null) {
            this.coyoteRequest = new Request();
            this.inputBuffer = new StreamInputBuffer();
            this.coyoteRequest.setInputBuffer(this.inputBuffer);
        } else {
            this.coyoteRequest = coyoteRequest;
            this.inputBuffer = null;
            this.state.receivedStartOfHeaders();
            this.state.receivedEndOfStream();
        }
        this.coyoteRequest.setSendfile(false);
        this.coyoteResponse.setOutputBuffer(this.outputBuffer);
        this.coyoteRequest.setResponse(this.coyoteResponse);
        this.coyoteRequest.protocol().setString("HTTP/2.0");
        if (this.coyoteRequest.getStartTime() < 0L) {
            this.coyoteRequest.setStartTime(System.currentTimeMillis());
        }
    }

    final void rePrioritise(AbstractStream parent, boolean exclusive, int weight) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.reprioritisation.debug", new Object[]{this.getConnectionId(), this.getIdentifier(), Boolean.toString(exclusive), parent.getIdentifier(), Integer.toString(weight)}));
        }
        if (this.isDescendant(parent)) {
            parent.detachFromParent();
            this.getParentStream().addChild((Stream)parent);
        }
        if (exclusive) {
            Iterator<Stream> parentsChildren = parent.getChildStreams().iterator();
            while (parentsChildren.hasNext()) {
                Stream parentsChild = parentsChildren.next();
                parentsChildren.remove();
                this.addChild(parentsChild);
            }
        }
        parent.addChild(this);
        this.weight = weight;
    }

    final void rePrioritise(AbstractStream parent, int weight) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.reprioritisation.debug", new Object[]{this.getConnectionId(), this.getIdentifier(), Boolean.FALSE, parent.getIdentifier(), Integer.toString(weight)}));
        }
        parent.addChild(this);
        this.weight = weight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void receiveReset(long errorCode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.reset.receive", new Object[]{this.getConnectionId(), this.getIdentifier(), Long.toString(errorCode)}));
        }
        this.state.receivedReset();
        if (this.inputBuffer != null) {
            this.inputBuffer.receiveReset();
        }
        Stream stream = this;
        synchronized (stream) {
            this.notifyAll();
        }
    }

    final void checkState(FrameType frameType) throws Http2Exception {
        this.state.checkFrameType(frameType);
    }

    @Override
    final synchronized void incrementWindowSize(int windowSizeIncrement) throws Http2Exception {
        boolean notify = this.getWindowSize() < 1L;
        super.incrementWindowSize(windowSizeIncrement);
        if (notify && this.getWindowSize() > 0L) {
            this.notifyAll();
        }
    }

    private final synchronized int reserveWindowSize(int reservation, boolean block) throws IOException {
        long windowSize = this.getWindowSize();
        while (windowSize < 1L) {
            if (!this.canWrite()) {
                throw new CloseNowException(sm.getString("stream.notWritable", new Object[]{this.getConnectionId(), this.getIdentifier()}));
            }
            try {
                if (!block) {
                    return 0;
                }
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            windowSize = this.getWindowSize();
        }
        int allocation = windowSize < (long)reservation ? (int)windowSize : reservation;
        this.decrementWindowSize(allocation);
        return allocation;
    }

    @Override
    public final void emitHeader(String name, String value) throws HpackException {
        boolean pseudoHeader;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.header.debug", new Object[]{this.getConnectionId(), this.getIdentifier(), name, value}));
        }
        if (!name.toLowerCase(Locale.US).equals(name)) {
            throw new HpackException(sm.getString("stream.header.case", new Object[]{this.getConnectionId(), this.getIdentifier(), name}));
        }
        if ("connection".equals(name)) {
            throw new HpackException(sm.getString("stream.header.connection", new Object[]{this.getConnectionId(), this.getIdentifier()}));
        }
        if ("te".equals(name) && !"trailers".equals(value)) {
            throw new HpackException(sm.getString("stream.header.te", new Object[]{this.getConnectionId(), this.getIdentifier(), value}));
        }
        if (this.headerStateErrorMsg != null) {
            return;
        }
        boolean bl = pseudoHeader = name.charAt(0) == ':';
        if (pseudoHeader && this.headerState != 1) {
            this.headerStateErrorMsg = sm.getString("stream.header.unexpectedPseudoHeader", new Object[]{this.getConnectionId(), this.getIdentifier(), name});
            return;
        }
        if (this.headerState == 1 && !pseudoHeader) {
            this.headerState = 2;
        }
        switch (name) {
            case ":method": {
                if (this.coyoteRequest.method().isNull()) {
                    this.coyoteRequest.method().setString(value);
                    break;
                }
                throw new HpackException(sm.getString("stream.header.duplicate", new Object[]{this.getConnectionId(), this.getIdentifier(), ":method"}));
            }
            case ":scheme": {
                if (this.coyoteRequest.scheme().isNull()) {
                    this.coyoteRequest.scheme().setString(value);
                    break;
                }
                throw new HpackException(sm.getString("stream.header.duplicate", new Object[]{this.getConnectionId(), this.getIdentifier(), ":scheme"}));
            }
            case ":path": {
                if (!this.coyoteRequest.requestURI().isNull()) {
                    throw new HpackException(sm.getString("stream.header.duplicate", new Object[]{this.getConnectionId(), this.getIdentifier(), ":path"}));
                }
                if (value.length() == 0) {
                    throw new HpackException(sm.getString("stream.header.noPath", new Object[]{this.getConnectionId(), this.getIdentifier()}));
                }
                int queryStart = value.indexOf(63);
                if (queryStart == -1) {
                    this.coyoteRequest.requestURI().setString(value);
                    this.coyoteRequest.decodedURI().setString(this.coyoteRequest.getURLDecoder().convert(value, false));
                    break;
                }
                String uri = value.substring(0, queryStart);
                String query = value.substring(queryStart + 1);
                this.coyoteRequest.requestURI().setString(uri);
                this.coyoteRequest.decodedURI().setString(this.coyoteRequest.getURLDecoder().convert(uri, false));
                this.coyoteRequest.queryString().setString(query);
                break;
            }
            case ":authority": {
                if (this.coyoteRequest.serverName().isNull()) {
                    int i = value.lastIndexOf(58);
                    if (i > -1) {
                        this.coyoteRequest.serverName().setString(value.substring(0, i));
                        this.coyoteRequest.setServerPort(Integer.parseInt(value.substring(i + 1)));
                        break;
                    }
                    this.coyoteRequest.serverName().setString(value);
                    break;
                }
                throw new HpackException(sm.getString("stream.header.duplicate", new Object[]{this.getConnectionId(), this.getIdentifier(), ":authority"}));
            }
            case "cookie": {
                if (this.cookieHeader == null) {
                    this.cookieHeader = new StringBuilder();
                } else {
                    this.cookieHeader.append("; ");
                }
                this.cookieHeader.append(value);
                break;
            }
            default: {
                if (this.headerState == 3 && !this.handler.isTrailerHeaderAllowed(name)) break;
                if ("expect".equals(name) && "100-continue".equals(value)) {
                    this.coyoteRequest.setExpectation(true);
                }
                if (pseudoHeader) {
                    this.headerStateErrorMsg = sm.getString("stream.header.unknownPseudoHeader", new Object[]{this.getConnectionId(), this.getIdentifier(), name});
                }
                this.coyoteRequest.getMimeHeaders().addValue(name).setString(value);
            }
        }
    }

    @Override
    public void validateHeaders() throws StreamException {
        if (this.headerStateErrorMsg == null) {
            return;
        }
        throw new StreamException(this.headerStateErrorMsg, Http2Error.PROTOCOL_ERROR, this.getIdentifier());
    }

    final boolean receivedEndOfHeaders() throws ConnectionException {
        if (this.coyoteRequest.method().isNull() || this.coyoteRequest.scheme().isNull() || this.coyoteRequest.requestURI().isNull()) {
            throw new ConnectionException(sm.getString("stream.header.required", new Object[]{this.getConnectionId(), this.getIdentifier()}), Http2Error.PROTOCOL_ERROR);
        }
        if (this.cookieHeader != null) {
            this.coyoteRequest.getMimeHeaders().addValue("cookie").setString(this.cookieHeader.toString());
        }
        return this.headerState == 2 || this.headerState == 1;
    }

    final void writeHeaders() throws IOException {
        this.handler.writeHeaders(this, this.coyoteResponse, 1024);
    }

    final void writeAck() throws IOException {
        this.handler.writeHeaders(this, ACK_RESPONSE, 64);
    }

    final void flushData() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("stream.write", new Object[]{this.getConnectionId(), this.getIdentifier()}));
        }
        this.outputBuffer.flush(true);
    }

    @Override
    final String getConnectionId() {
        return this.handler.getConnectionId();
    }

    @Override
    final int getWeight() {
        return this.weight;
    }

    final Request getCoyoteRequest() {
        return this.coyoteRequest;
    }

    final Response getCoyoteResponse() {
        return this.coyoteResponse;
    }

    final ByteBuffer getInputByteBuffer() {
        return this.inputBuffer.getInBuffer();
    }

    final void receivedStartOfHeaders(boolean headersEndStream) throws Http2Exception {
        if (this.headerState == 0) {
            this.headerState = 1;
            this.handler.getHpackDecoder().setMaxHeaderCount(this.handler.getMaxHeaderCount());
            this.handler.getHpackDecoder().setMaxHeaderSize(this.handler.getMaxHeaderSize());
        } else if (this.headerState == 1 || this.headerState == 2) {
            if (headersEndStream) {
                this.headerState = 3;
                this.handler.getHpackDecoder().setMaxHeaderCount(this.handler.getMaxTrailerCount());
                this.handler.getHpackDecoder().setMaxHeaderSize(this.handler.getMaxTrailerSize());
            } else {
                throw new ConnectionException(sm.getString("stream.trailerHeader.noEndOfStream", new Object[]{this.getConnectionId(), this.getIdentifier()}), Http2Error.PROTOCOL_ERROR);
            }
        }
        this.state.receivedStartOfHeaders();
    }

    final void receivedData(int payloadSize) throws ConnectionException {
        this.contentLengthReceived += (long)payloadSize;
        long contentLengthHeader = this.coyoteRequest.getContentLengthLong();
        if (contentLengthHeader > -1L && this.contentLengthReceived > contentLengthHeader) {
            throw new ConnectionException(sm.getString("stream.header.contentLength", new Object[]{this.getConnectionId(), this.getIdentifier(), contentLengthHeader, this.contentLengthReceived}), Http2Error.PROTOCOL_ERROR);
        }
    }

    final void receivedEndOfStream() throws ConnectionException {
        long contentLengthHeader = this.coyoteRequest.getContentLengthLong();
        if (contentLengthHeader > -1L && this.contentLengthReceived != contentLengthHeader) {
            throw new ConnectionException(sm.getString("stream.header.contentLength", new Object[]{this.getConnectionId(), this.getIdentifier(), contentLengthHeader, this.contentLengthReceived}), Http2Error.PROTOCOL_ERROR);
        }
        this.state.receivedEndOfStream();
        if (this.inputBuffer != null) {
            this.inputBuffer.notifyEof();
        }
    }

    final void sentEndOfStream() {
        this.outputBuffer.endOfStreamSent = true;
        this.state.sentEndOfStream();
    }

    final StreamInputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    final StreamOutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    final void sentPushPromise() {
        this.state.sentPushPromise();
    }

    final boolean isActive() {
        return this.state.isActive();
    }

    final boolean canWrite() {
        return this.state.canWrite();
    }

    final boolean isClosedFinal() {
        return this.state.isClosedFinal();
    }

    final void closeIfIdle() {
        this.state.closeIfIdle();
    }

    private final boolean isInputFinished() {
        return !this.state.isFrameTypePermitted(FrameType.DATA);
    }

    final void close(Http2Exception http2Exception) {
        if (http2Exception instanceof StreamException) {
            try {
                StreamException se = (StreamException)http2Exception;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("stream.reset.send", new Object[]{this.getConnectionId(), this.getIdentifier(), se.getError()}));
                }
                this.state.sendReset();
                this.handler.sendStreamReset(se);
            }
            catch (IOException ioe) {
                ConnectionException ce = new ConnectionException(sm.getString("stream.reset.fail"), Http2Error.PROTOCOL_ERROR);
                ce.initCause(ioe);
                this.handler.closeConnection(ce);
            }
        } else {
            this.handler.closeConnection(http2Exception);
        }
    }

    final boolean isPushSupported() {
        return this.handler.getRemoteSettings().getEnablePush();
    }

    final void push(Request request) throws IOException {
        if (!this.isPushSupported()) {
            return;
        }
        request.getMimeHeaders().addValue(":method").duplicate(request.method());
        request.getMimeHeaders().addValue(":scheme").duplicate(request.scheme());
        StringBuilder path = new StringBuilder(request.requestURI().toString());
        if (!request.queryString().isNull()) {
            path.append('?');
            path.append(request.queryString().toString());
        }
        request.getMimeHeaders().addValue(":path").setString(path.toString());
        if (!(request.scheme().equals("http") && request.getServerPort() == 80 || request.scheme().equals("https") && request.getServerPort() == 443)) {
            request.getMimeHeaders().addValue(":authority").setString(request.serverName().getString() + ":" + request.getServerPort());
        } else {
            request.getMimeHeaders().addValue(":authority").duplicate(request.serverName());
        }
        Stream.push(this.handler, request, this);
    }

    private static void push(final Http2UpgradeHandler handler, final Request request, final Stream stream) throws IOException {
        if (Constants.IS_SECURITY_ENABLED) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        handler.push(request, stream);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                Exception e = ex.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(ex);
            }
        } else {
            handler.push(request, stream);
        }
    }

    static {
        ACK_RESPONSE.setStatus(100);
    }

    class StreamInputBuffer
    implements InputBuffer {
        private byte[] outBuffer;
        private volatile ByteBuffer inBuffer;
        private volatile boolean readInterest;
        private boolean reset = false;

        StreamInputBuffer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final int doRead(ApplicationBufferHandler applicationBufferHandler) throws IOException {
            this.ensureBuffersExist();
            int written = -1;
            ByteBuffer byteBuffer = this.inBuffer;
            synchronized (byteBuffer) {
                boolean canRead = false;
                while (this.inBuffer.position() == 0 && (canRead = Stream.this.isActive() && !Stream.this.isInputFinished())) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("stream.inputBuffer.empty"));
                        }
                        this.inBuffer.wait();
                        if (!this.reset) continue;
                        throw new IOException(sm.getString("stream.inputBuffer.reset"));
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                if (this.inBuffer.position() > 0) {
                    this.inBuffer.flip();
                    written = this.inBuffer.remaining();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("stream.inputBuffer.copy", new Object[]{Integer.toString(written)}));
                    }
                } else {
                    if (!canRead) {
                        return -1;
                    }
                    throw new IllegalStateException();
                }
                this.inBuffer.get(this.outBuffer, 0, written);
                this.inBuffer.clear();
            }
            applicationBufferHandler.setByteBuffer(ByteBuffer.wrap(this.outBuffer, 0, written));
            Stream.this.handler.writeWindowUpdate(Stream.this, written, true);
            return written;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void registerReadInterest() {
            ByteBuffer byteBuffer = this.inBuffer;
            synchronized (byteBuffer) {
                this.readInterest = true;
            }
        }

        final synchronized boolean isRequestBodyFullyRead() {
            return (this.inBuffer == null || this.inBuffer.position() == 0) && Stream.this.isInputFinished();
        }

        final synchronized int available() {
            if (this.inBuffer == null) {
                return 0;
            }
            return this.inBuffer.position();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final synchronized boolean onDataAvailable() {
            if (this.readInterest) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("stream.inputBuffer.dispatch"));
                }
                this.readInterest = false;
                Stream.this.coyoteRequest.action(ActionCode.DISPATCH_READ, null);
                Stream.this.coyoteRequest.action(ActionCode.DISPATCH_EXECUTE, null);
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("stream.inputBuffer.signal"));
            }
            ByteBuffer byteBuffer = this.inBuffer;
            synchronized (byteBuffer) {
                this.inBuffer.notifyAll();
            }
            return false;
        }

        private final ByteBuffer getInBuffer() {
            this.ensureBuffersExist();
            return this.inBuffer;
        }

        final synchronized void insertReplayedBody(ByteChunk body) {
            this.inBuffer = ByteBuffer.wrap(body.getBytes(), body.getOffset(), body.getLength());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void ensureBuffersExist() {
            if (this.inBuffer == null) {
                int size = Stream.this.handler.getLocalSettings().getInitialWindowSize();
                StreamInputBuffer streamInputBuffer = this;
                synchronized (streamInputBuffer) {
                    if (this.inBuffer == null) {
                        this.inBuffer = ByteBuffer.allocate(size);
                        this.outBuffer = new byte[size];
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void receiveReset() {
            if (this.inBuffer != null) {
                ByteBuffer byteBuffer = this.inBuffer;
                synchronized (byteBuffer) {
                    this.reset = true;
                    this.inBuffer.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void notifyEof() {
            if (this.inBuffer != null) {
                ByteBuffer byteBuffer = this.inBuffer;
                synchronized (byteBuffer) {
                    this.inBuffer.notifyAll();
                }
            }
        }
    }

    class StreamOutputBuffer
    implements OutputBuffer {
        private final ByteBuffer buffer = ByteBuffer.allocate(8192);
        private volatile long written = 0L;
        private volatile boolean closed = false;
        private volatile boolean endOfStreamSent = false;

        StreamOutputBuffer() {
        }

        @Override
        public final synchronized int doWrite(ByteBuffer chunk) throws IOException {
            if (this.closed) {
                throw new IllegalStateException(sm.getString("stream.closed", new Object[]{Stream.this.getConnectionId(), Stream.this.getIdentifier()}));
            }
            if (!Stream.this.coyoteResponse.isCommitted()) {
                Stream.this.coyoteResponse.sendHeaders();
            }
            int chunkLimit = chunk.limit();
            int offset = 0;
            while (chunk.remaining() > 0) {
                int thisTime = Math.min(this.buffer.remaining(), chunk.remaining());
                chunk.limit(chunk.position() + thisTime);
                this.buffer.put(chunk);
                chunk.limit(chunkLimit);
                offset += thisTime;
                if (chunk.remaining() <= 0 || this.buffer.hasRemaining() || !this.flush(true, Stream.this.coyoteResponse.getWriteListener() == null)) continue;
                break;
            }
            this.written += (long)offset;
            return offset;
        }

        final synchronized boolean flush(boolean block) throws IOException {
            return this.flush(false, block);
        }

        private final synchronized boolean flush(boolean writeInProgress, boolean block) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("stream.outputBuffer.flush.debug", new Object[]{Stream.this.getConnectionId(), Stream.this.getIdentifier(), Integer.toString(this.buffer.position()), Boolean.toString(writeInProgress), Boolean.toString(this.closed)}));
            }
            if (this.buffer.position() == 0) {
                if (this.closed && !this.endOfStreamSent) {
                    Stream.this.handler.writeBody(Stream.this, this.buffer, 0, true);
                }
                return false;
            }
            this.buffer.flip();
            int left = this.buffer.remaining();
            while (left > 0) {
                int streamReservation = Stream.this.reserveWindowSize(left, block);
                if (streamReservation == 0) {
                    this.buffer.compact();
                    return true;
                }
                while (streamReservation > 0) {
                    int connectionReservation = Stream.this.handler.reserveWindowSize(Stream.this, streamReservation);
                    Stream.this.handler.writeBody(Stream.this, this.buffer, connectionReservation, !writeInProgress && this.closed && left == connectionReservation);
                    streamReservation -= connectionReservation;
                    left -= connectionReservation;
                }
            }
            this.buffer.clear();
            return false;
        }

        final synchronized boolean isReady() {
            return Stream.this.getWindowSize() > 0L && Stream.this.handler.getWindowSize() > 0L;
        }

        @Override
        public final long getBytesWritten() {
            return this.written;
        }

        final void close() throws IOException {
            this.closed = true;
            Stream.this.flushData();
        }

        final boolean hasNoBody() {
            return this.written == 0L && this.closed;
        }
    }
}

