/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.tomcat.dbcp.dbcp2.AbandonedTrace;
import org.apache.tomcat.dbcp.dbcp2.DelegatingCallableStatement;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.PStmtKey;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;

public class PoolableCallableStatement
extends DelegatingCallableStatement {
    private final KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> _pool;
    private final PStmtKey _key;

    public PoolableCallableStatement(CallableStatement stmt, PStmtKey key, KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pool, DelegatingConnection<Connection> conn) {
        super(conn, stmt);
        this._pool = pool;
        this._key = key;
        if (this._conn != null) {
            this._conn.removeTrace(this);
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            try {
                this._pool.returnObject(this._key, this);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Cannot close CallableStatement (return to pool failed)", e);
            }
        }
    }

    @Override
    protected void activate() throws SQLException {
        this._closed = false;
        if (this._conn != null) {
            this._conn.addTrace(this);
        }
        super.activate();
    }

    @Override
    protected void passivate() throws SQLException {
        List<AbandonedTrace> resultSets;
        this._closed = true;
        if (this._conn != null) {
            this._conn.removeTrace(this);
        }
        if ((resultSets = this.getTrace()) != null) {
            ResultSet[] set = resultSets.toArray(new ResultSet[resultSets.size()]);
            for (int i = 0; i < set.length; ++i) {
                set[i].close();
            }
            this.clearTrace();
        }
        super.passivate();
    }
}

