/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.PStmtKey;
import org.apache.tomcat.dbcp.dbcp2.PoolableCallableStatement;
import org.apache.tomcat.dbcp.dbcp2.PoolablePreparedStatement;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.KeyedPooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;

public class PoolingConnection
extends DelegatingConnection<Connection>
implements KeyedPooledObjectFactory<PStmtKey, DelegatingPreparedStatement> {
    protected KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> _pstmtPool = null;
    protected static final byte STATEMENT_PREPAREDSTMT = 0;
    private static final byte STATEMENT_CALLABLESTMT = 1;

    public PoolingConnection(Connection c) {
        super(c);
    }

    public void setStatementPool(KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pool) {
        this._pstmtPool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        block11: {
            try {
                if (null == this._pstmtPool) break block11;
                KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> oldpool = this._pstmtPool;
                this._pstmtPool = null;
                try {
                    oldpool.close();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw (SQLException)new SQLException("Cannot close connection").initCause(e);
                }
            }
            finally {
                try {
                    this.getDelegateInternal().close();
                }
                finally {
                    this._closed = true;
                }
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(sql));
        }
        catch (NoSuchElementException e) {
            throw (SQLException)new SQLException("MaxOpenPreparedStatements limit reached").initCause(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency));
        }
        catch (NoSuchElementException e) {
            throw (SQLException)new SQLException("MaxOpenPreparedStatements limit reached").initCause(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw (SQLException)new SQLException("Borrow prepareStatement from pool failed").initCause(e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return (CallableStatement)((Object)this._pstmtPool.borrowObject(this.createKey(sql, (byte)1)));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenCallableStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow callableStatement from pool failed", e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return (CallableStatement)((Object)this._pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency, (byte)1)));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenCallableStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow callableStatement from pool failed", e);
        }
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, resultSetType, resultSetConcurrency);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, byte stmtType) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, resultSetType, resultSetConcurrency, stmtType);
    }

    protected PStmtKey createKey(String sql) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog);
    }

    protected PStmtKey createKey(String sql, byte stmtType) {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(sql), catalog, stmtType);
    }

    protected String normalizeSQL(String sql) {
        return sql.trim();
    }

    @Override
    public PooledObject<DelegatingPreparedStatement> makeObject(PStmtKey key) throws Exception {
        if (null == key) {
            throw new IllegalArgumentException("Prepared statement key is null or invalid.");
        }
        if (null == key.getResultSetType() && null == key.getResultSetConcurrency()) {
            if (key.getStmtType() == 0) {
                return new DefaultPooledObject<DelegatingPreparedStatement>(new PoolablePreparedStatement(this.getDelegate().prepareStatement(key.getSql()), key, this._pstmtPool, this));
            }
            return new DefaultPooledObject<DelegatingPreparedStatement>(new PoolableCallableStatement(this.getDelegate().prepareCall(key.getSql()), key, this._pstmtPool, this));
        }
        if (key.getStmtType() == 0) {
            return new DefaultPooledObject<DelegatingPreparedStatement>(new PoolablePreparedStatement(this.getDelegate().prepareStatement(key.getSql(), key.getResultSetType(), key.getResultSetConcurrency()), key, this._pstmtPool, this));
        }
        return new DefaultPooledObject<DelegatingPreparedStatement>(new PoolableCallableStatement(this.getDelegate().prepareCall(key.getSql(), key.getResultSetType(), key.getResultSetConcurrency()), key, this._pstmtPool, this));
    }

    @Override
    public void destroyObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> p) throws Exception {
        p.getObject().getInnermostDelegate().close();
    }

    @Override
    public boolean validateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> p) {
        return true;
    }

    @Override
    public void activateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> p) throws Exception {
        p.getObject().activate();
    }

    @Override
    public void passivateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> p) throws Exception {
        DelegatingPreparedStatement dps = p.getObject();
        dps.clearParameters();
        dps.passivate();
    }

    @Override
    public String toString() {
        if (this._pstmtPool != null) {
            return "PoolingConnection: " + this._pstmtPool.toString();
        }
        return "PoolingConnection: null";
    }
}

