/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.LifetimeExceededException;
import org.apache.tomcat.dbcp.dbcp2.PStmtKey;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolingConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPoolConfig;

public class PoolableConnectionFactory
implements PooledObjectFactory<PoolableConnection> {
    private static final Log log = LogFactory.getLog(PoolableConnectionFactory.class);
    private final ConnectionFactory _connFactory;
    private final ObjectName dataSourceJmxName;
    private volatile String _validationQuery = null;
    private volatile int _validationQueryTimeout = -1;
    private Collection<String> _connectionInitSqls = null;
    private Collection<String> _disconnectionSqlCodes = null;
    private boolean _fastFailValidation = false;
    private volatile ObjectPool<PoolableConnection> _pool = null;
    private Boolean _defaultReadOnly = null;
    private Boolean _defaultAutoCommit = null;
    private boolean enableAutoCommitOnReturn = true;
    private boolean rollbackOnReturn = true;
    private int _defaultTransactionIsolation = -1;
    private String _defaultCatalog;
    private boolean _cacheState;
    private boolean poolStatements = false;
    private int maxOpenPreparedStatements = 8;
    private long maxConnLifetimeMillis = -1L;
    private final AtomicLong connectionIndex = new AtomicLong(0L);
    private Integer defaultQueryTimeout = null;
    static final int UNKNOWN_TRANSACTIONISOLATION = -1;

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectName dataSourceJmxName) {
        this._connFactory = connFactory;
        this.dataSourceJmxName = dataSourceJmxName;
    }

    public void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public void setValidationQueryTimeout(int timeout) {
        this._validationQueryTimeout = timeout;
    }

    public void setConnectionInitSql(Collection<String> connectionInitSqls) {
        this._connectionInitSqls = connectionInitSqls;
    }

    public synchronized void setPool(ObjectPool<PoolableConnection> pool) {
        if (null != this._pool && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._pool = pool;
    }

    public synchronized ObjectPool<PoolableConnection> getPool() {
        return this._pool;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this._defaultReadOnly = defaultReadOnly;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this._defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this._defaultCatalog = defaultCatalog;
    }

    public void setCacheState(boolean cacheState) {
        this._cacheState = cacheState;
    }

    public void setPoolStatements(boolean poolStatements) {
        this.poolStatements = poolStatements;
    }

    @Deprecated
    public void setMaxOpenPrepatedStatements(int maxOpenPreparedStatements) {
        this.setMaxOpenPreparedStatements(maxOpenPreparedStatements);
    }

    public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
        this.maxOpenPreparedStatements = maxOpenPreparedStatements;
    }

    public void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.maxConnLifetimeMillis = maxConnLifetimeMillis;
    }

    public boolean isEnableAutoCommitOnReturn() {
        return this.enableAutoCommitOnReturn;
    }

    public void setEnableAutoCommitOnReturn(boolean enableAutoCommitOnReturn) {
        this.enableAutoCommitOnReturn = enableAutoCommitOnReturn;
    }

    public boolean isRollbackOnReturn() {
        return this.rollbackOnReturn;
    }

    public void setRollbackOnReturn(boolean rollbackOnReturn) {
        this.rollbackOnReturn = rollbackOnReturn;
    }

    public Integer getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    public void setDefaultQueryTimeout(Integer defaultQueryTimeout) {
        this.defaultQueryTimeout = defaultQueryTimeout;
    }

    public Collection<String> getDisconnectionSqlCodes() {
        return this._disconnectionSqlCodes;
    }

    public void setDisconnectionSqlCodes(Collection<String> disconnectionSqlCodes) {
        this._disconnectionSqlCodes = disconnectionSqlCodes;
    }

    public boolean isFastFailValidation() {
        return this._fastFailValidation;
    }

    public void setFastFailValidation(boolean fastFailValidation) {
        this._fastFailValidation = fastFailValidation;
    }

    @Override
    public PooledObject<PoolableConnection> makeObject() throws Exception {
        Connection conn = this._connFactory.createConnection();
        if (conn == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        try {
            this.initializeConnection(conn);
        }
        catch (SQLException sqle) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw sqle;
        }
        long connIndex = this.connectionIndex.getAndIncrement();
        if (this.poolStatements) {
            conn = new PoolingConnection(conn);
            GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
            config.setMaxTotalPerKey(-1);
            config.setBlockWhenExhausted(false);
            config.setMaxWaitMillis(0L);
            config.setMaxIdlePerKey(1);
            config.setMaxTotal(this.maxOpenPreparedStatements);
            if (this.dataSourceJmxName != null) {
                StringBuilder base = new StringBuilder(this.dataSourceJmxName.toString());
                base.append(",connectionpool=connections,connection=");
                base.append(Long.toString(connIndex));
                config.setJmxNameBase(base.toString());
                config.setJmxNamePrefix(",statementpool=statements");
            } else {
                config.setJmxEnabled(false);
            }
            GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement> stmtPool = new GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement>((PoolingConnection)conn, config);
            ((PoolingConnection)conn).setStatementPool(stmtPool);
            ((PoolingConnection)conn).setCacheState(this._cacheState);
        }
        ObjectName connJmxName = this.dataSourceJmxName == null ? null : new ObjectName(this.dataSourceJmxName.toString() + ",connectionpool=connections,connection=" + connIndex);
        PoolableConnection pc = new PoolableConnection(conn, this._pool, connJmxName, this._disconnectionSqlCodes, this._fastFailValidation);
        pc.setCacheState(this._cacheState);
        return new DefaultPooledObject<PoolableConnection>(pc);
    }

    protected void initializeConnection(Connection conn) throws SQLException {
        Collection<String> sqls = this._connectionInitSqls;
        if (conn.isClosed()) {
            throw new SQLException("initializeConnection: connection closed");
        }
        if (null != sqls) {
            try (Statement stmt = conn.createStatement();){
                for (String sql : sqls) {
                    if (sql == null) {
                        throw new NullPointerException("null connectionInitSqls element");
                    }
                    stmt.execute(sql);
                }
            }
        }
    }

    @Override
    public void destroyObject(PooledObject<PoolableConnection> p) throws Exception {
        p.getObject().reallyClose();
    }

    @Override
    public boolean validateObject(PooledObject<PoolableConnection> p) {
        try {
            this.validateLifetime(p);
            this.validateConnection(p.getObject());
            return true;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)Utils.getMessage("poolableConnectionFactory.validateObject.fail"), (Throwable)e);
            }
            return false;
        }
    }

    public void validateConnection(PoolableConnection conn) throws SQLException {
        if (conn.isClosed()) {
            throw new SQLException("validateConnection: connection closed");
        }
        conn.validate(this._validationQuery, this._validationQueryTimeout);
    }

    @Override
    public void passivateObject(PooledObject<PoolableConnection> p) throws Exception {
        this.validateLifetime(p);
        PoolableConnection conn = p.getObject();
        Boolean connAutoCommit = null;
        if (this.rollbackOnReturn && !(connAutoCommit = Boolean.valueOf(conn.getAutoCommit())).booleanValue() && !conn.isReadOnly()) {
            conn.rollback();
        }
        conn.clearWarnings();
        if (this.enableAutoCommitOnReturn) {
            if (connAutoCommit == null) {
                connAutoCommit = conn.getAutoCommit();
            }
            if (!connAutoCommit.booleanValue()) {
                conn.setAutoCommit(true);
            }
        }
        conn.passivate();
    }

    @Override
    public void activateObject(PooledObject<PoolableConnection> p) throws Exception {
        this.validateLifetime(p);
        PoolableConnection conn = p.getObject();
        conn.activate();
        if (this._defaultAutoCommit != null && conn.getAutoCommit() != this._defaultAutoCommit.booleanValue()) {
            conn.setAutoCommit(this._defaultAutoCommit);
        }
        if (this._defaultTransactionIsolation != -1 && conn.getTransactionIsolation() != this._defaultTransactionIsolation) {
            conn.setTransactionIsolation(this._defaultTransactionIsolation);
        }
        if (this._defaultReadOnly != null && conn.isReadOnly() != this._defaultReadOnly.booleanValue()) {
            conn.setReadOnly(this._defaultReadOnly);
        }
        if (this._defaultCatalog != null && !this._defaultCatalog.equals(conn.getCatalog())) {
            conn.setCatalog(this._defaultCatalog);
        }
        conn.setDefaultQueryTimeout(this.defaultQueryTimeout);
    }

    private void validateLifetime(PooledObject<PoolableConnection> p) throws Exception {
        long lifetime;
        if (this.maxConnLifetimeMillis > 0L && (lifetime = System.currentTimeMillis() - p.getCreateTime()) > this.maxConnLifetimeMillis) {
            throw new LifetimeExceededException(Utils.getMessage("connectionFactory.lifetimeExceeded", lifetime, this.maxConnLifetimeMillis));
        }
    }

    protected ConnectionFactory getConnectionFactory() {
        return this._connFactory;
    }

    protected boolean getPoolStatements() {
        return this.poolStatements;
    }

    protected int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    protected boolean getCacheState() {
        return this._cacheState;
    }

    protected ObjectName getDataSourceJmxName() {
        return this.dataSourceJmxName;
    }

    protected AtomicLong getConnectionIndex() {
        return this.connectionIndex;
    }
}

