/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.compiler.JarResource;
import org.apache.jasper.compiler.JarURLResource;

public class TldLocation {
    private final String entryName;
    private final JarResource jar;

    public TldLocation(String entryName) {
        this(entryName, (JarResource)null);
    }

    public TldLocation(String entryName, String resourceUrl) {
        this(entryName, TldLocation.getJarResource(resourceUrl));
    }

    public TldLocation(String entryName, JarResource jarResource) {
        if (entryName == null) {
            throw new IllegalArgumentException("Tld name is required");
        }
        this.entryName = entryName;
        this.jar = jarResource;
    }

    private static JarResource getJarResource(String resourceUrl) {
        return resourceUrl != null ? new JarURLResource(resourceUrl) : null;
    }

    public String getName() {
        return this.entryName;
    }

    public JarResource getJarResource() {
        return this.jar;
    }
}

