/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.auth.message.config;

import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.RegistrationListener;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Map;
import org.apache.catalina.authenticator.jaspic.AuthConfigFactoryImpl;

public abstract class AuthConfigFactory {
    public static final String DEFAULT_FACTORY_SECURITY_PROPERTY = "authconfigprovider.factory";
    public static final String GET_FACTORY_PERMISSION_NAME = "getProperty.authconfigprovider.factory";
    public static final String SET_FACTORY_PERMISSION_NAME = "setProperty.authconfigprovider.factory";
    public static final String PROVIDER_REGISTRATION_PERMISSION_NAME = "setProperty.authconfigfactory.provider";
    @Deprecated(forRemoval=true)
    public static final SecurityPermission getFactorySecurityPermission = new SecurityPermission("getProperty.authconfigprovider.factory");
    @Deprecated(forRemoval=true)
    public static final SecurityPermission setFactorySecurityPermission = new SecurityPermission("setProperty.authconfigprovider.factory");
    @Deprecated(forRemoval=true)
    public static final SecurityPermission providerRegistrationSecurityPermission = new SecurityPermission("setProperty.authconfigfactory.provider");
    private static final String DEFAULT_JASPI_AUTHCONFIGFACTORYIMPL = "org.apache.catalina.authenticator.jaspic.AuthConfigFactoryImpl";
    private static volatile AuthConfigFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthConfigFactory getFactory() {
        if (factory != null) {
            return factory;
        }
        Class<AuthConfigFactory> clazz = AuthConfigFactory.class;
        synchronized (AuthConfigFactory.class) {
            if (factory == null) {
                String className = AuthConfigFactory.getFactoryClassName();
                try {
                    if (className.equals(DEFAULT_JASPI_AUTHCONFIGFACTORYIMPL)) {
                        factory = new AuthConfigFactoryImpl();
                    } else {
                        Class<?> clazz2 = Class.forName(className);
                        factory = (AuthConfigFactory)clazz2.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("AuthConfigFactory error:" + e.getCause().getMessage(), e.getCause());
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return factory;
        }
    }

    public static synchronized void setFactory(AuthConfigFactory factory) {
        AuthConfigFactory.factory = factory;
    }

    public abstract AuthConfigProvider getConfigProvider(String var1, String var2, RegistrationListener var3);

    public abstract String registerConfigProvider(String var1, Map<String, String> var2, String var3, String var4, String var5);

    public abstract String registerConfigProvider(AuthConfigProvider var1, String var2, String var3, String var4);

    public abstract boolean removeRegistration(String var1);

    public abstract String[] detachListener(RegistrationListener var1, String var2, String var3);

    public abstract String[] getRegistrationIDs(AuthConfigProvider var1);

    public abstract RegistrationContext getRegistrationContext(String var1);

    public abstract void refresh();

    public abstract String registerServerAuthModule(ServerAuthModule var1, Object var2);

    public abstract void removeServerAuthModule(Object var1);

    private static String getFactoryClassName() {
        String className = Security.getProperty(DEFAULT_FACTORY_SECURITY_PROPERTY);
        if (className != null) {
            return className;
        }
        return DEFAULT_JASPI_AUTHCONFIGFACTORYIMPL;
    }

    public static interface RegistrationContext {
        public String getMessageLayer();

        public String getAppContext();

        public String getDescription();

        public boolean isPersistent();
    }
}

