/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging;

import org.apache.juli.logging.Log;

public class UserDataHelper {
    private final Log log;
    private Config config;
    private long suppressionTime;
    private volatile long lastInfoTime = 0L;

    public UserDataHelper(Log log) {
        this.log = log;
        String configString = System.getProperty("org.apache.juli.logging.UserDataHelper.CONFIG");
        if (configString == null) {
            this.config = Config.INFO_THEN_DEBUG;
        } else {
            try {
                this.config = Config.valueOf(configString);
            }
            catch (IllegalArgumentException iae) {
                this.config = Config.INFO_THEN_DEBUG;
            }
        }
        this.suppressionTime = (long)Integer.getInteger("org.apache.juli.logging.UserDataHelper.SUPPRESSION_TIME", 86400).intValue() * 1000L;
        if (this.suppressionTime == 0L) {
            this.config = Config.INFO_ALL;
        }
    }

    public Mode getNextMode() {
        if (Config.NONE == this.config) {
            return null;
        }
        if (Config.DEBUG_ALL == this.config) {
            return this.log.isDebugEnabled() ? Mode.DEBUG : null;
        }
        if (Config.INFO_THEN_DEBUG == this.config) {
            if (this.logAtInfo()) {
                return this.log.isInfoEnabled() ? Mode.INFO_THEN_DEBUG : null;
            }
            return this.log.isDebugEnabled() ? Mode.DEBUG : null;
        }
        if (Config.INFO_ALL == this.config) {
            return this.log.isInfoEnabled() ? Mode.INFO : null;
        }
        return null;
    }

    public void log(Mode mode, String message) {
        if (mode != null) {
            switch (mode) {
                case INFO: 
                case INFO_THEN_DEBUG: {
                    this.log.info(message);
                    break;
                }
                case DEBUG: {
                    this.log.debug(message);
                }
            }
        }
    }

    public void log(Mode mode, String message, Throwable t) {
        if (mode != null) {
            switch (mode) {
                case INFO: 
                case INFO_THEN_DEBUG: {
                    this.log.info(message, t);
                    break;
                }
                case DEBUG: {
                    this.log.debug(message, t);
                }
            }
        }
    }

    private boolean logAtInfo() {
        if (this.suppressionTime < 0L && this.lastInfoTime > 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.lastInfoTime + this.suppressionTime > now) {
            return false;
        }
        this.lastInfoTime = now;
        return true;
    }

    public static enum Mode {
        DEBUG(false),
        INFO_THEN_DEBUG(true),
        INFO(false);

        private final boolean fallToDebug;

        private Mode(boolean fallToDebug) {
            this.fallToDebug = fallToDebug;
        }

        public boolean fallToDebug() {
            return this.fallToDebug;
        }
    }

    private static enum Config {
        NONE,
        DEBUG_ALL,
        INFO_THEN_DEBUG,
        INFO_ALL;

    }
}

