/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.catalina.tribes.ByteMessage;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.ChannelReceiver;
import org.apache.catalina.tribes.ChannelSender;
import org.apache.catalina.tribes.ErrorHandler;
import org.apache.catalina.tribes.Heartbeat;
import org.apache.catalina.tribes.ManagedChannel;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.ChannelCoordinator;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.catalina.tribes.group.RpcMessage;
import org.apache.catalina.tribes.group.interceptors.MessageDispatch15Interceptor;
import org.apache.catalina.tribes.io.BufferPool;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.catalina.tribes.util.Logs;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class GroupChannel
extends ChannelInterceptorBase
implements ManagedChannel {
    private static final Log log = LogFactory.getLog(GroupChannel.class);
    protected boolean heartbeat = true;
    protected long heartbeatSleeptime = 5000L;
    protected HeartbeatThread hbthread = null;
    protected final ChannelCoordinator coordinator = new ChannelCoordinator();
    protected ChannelInterceptor interceptors = null;
    protected final List<Object> membershipListeners = new CopyOnWriteArrayList<Object>();
    protected final List<Object> channelListeners = new CopyOnWriteArrayList<Object>();
    protected boolean optionCheck = false;

    public GroupChannel() {
        this.addInterceptor(this);
    }

    @Override
    public void addInterceptor(ChannelInterceptor interceptor) {
        if (this.interceptors == null) {
            this.interceptors = interceptor;
            this.interceptors.setNext(this.coordinator);
            this.interceptors.setPrevious(null);
            this.coordinator.setPrevious(this.interceptors);
        } else {
            ChannelInterceptor last = this.interceptors;
            while (last.getNext() != this.coordinator) {
                last = last.getNext();
            }
            last.setNext(interceptor);
            interceptor.setNext(this.coordinator);
            interceptor.setPrevious(last);
            this.coordinator.setPrevious(interceptor);
        }
    }

    @Override
    public void heartbeat() {
        super.heartbeat();
        for (Object o : this.membershipListeners) {
            if (!(o instanceof Heartbeat)) continue;
            ((Heartbeat)o).heartbeat();
        }
        for (Object o : this.channelListeners) {
            if (!(o instanceof Heartbeat)) continue;
            ((Heartbeat)o).heartbeat();
        }
    }

    @Override
    public UniqueId send(Member[] destination, Serializable msg, int options) throws ChannelException {
        return this.send(destination, msg, options, null);
    }

    @Override
    public UniqueId send(Member[] destination, Serializable msg, int options, ErrorHandler handler) throws ChannelException {
        if (msg == null) {
            throw new ChannelException("Cant send a NULL message");
        }
        XByteBuffer buffer = null;
        try {
            if (destination == null || destination.length == 0) {
                throw new ChannelException("No destination given");
            }
            ChannelData data = new ChannelData(true);
            data.setAddress(this.getLocalMember(false));
            data.setTimestamp(System.currentTimeMillis());
            byte[] b = null;
            if (msg instanceof ByteMessage) {
                b = ((ByteMessage)msg).getMessage();
                options |= 1;
            } else {
                b = XByteBuffer.serialize(msg);
                options &= 0xFFFFFFFE;
            }
            data.setOptions(options);
            buffer = BufferPool.getBufferPool().getBuffer(b.length + 128, false);
            buffer.append(b, 0, b.length);
            data.setMessage(buffer);
            InterceptorPayload payload = null;
            if (handler != null) {
                payload = new InterceptorPayload();
                payload.setErrorHandler(handler);
            }
            this.getFirstInterceptor().sendMessage(destination, data, payload);
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel - Sent msg:" + new UniqueId(data.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis()) + " to " + Arrays.toNameString(destination)));
                Logs.MESSAGES.trace((Object)("GroupChannel - Send Message:" + new UniqueId(data.getUniqueId()) + " is " + msg));
            }
            UniqueId uniqueId = new UniqueId(data.getUniqueId());
            if (buffer != null) {
                BufferPool.getBufferPool().returnBuffer(buffer);
            }
            return uniqueId;
        }
        catch (Exception x) {
            try {
                if (x instanceof ChannelException) {
                    throw (ChannelException)x;
                }
                throw new ChannelException(x);
            }
            catch (Throwable throwable) {
                if (buffer != null) {
                    BufferPool.getBufferPool().returnBuffer(buffer);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void messageReceived(ChannelMessage msg) {
        if (msg == null) {
            return;
        }
        try {
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel - Received msg:" + new UniqueId(msg.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis()) + " from " + msg.getAddress().getName()));
            }
            Serializable fwd = null;
            if ((msg.getOptions() & 1) == 1) {
                fwd = new ByteMessage(msg.getMessage().getBytes());
            } else {
                try {
                    fwd = XByteBuffer.deserialize(msg.getMessage().getBytesDirect(), 0, msg.getMessage().getLength());
                }
                catch (Exception sx) {
                    log.error((Object)("Unable to deserialize message:" + msg), (Throwable)sx);
                    return;
                }
            }
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel - Receive Message:" + new UniqueId(msg.getUniqueId()) + " is " + fwd));
            }
            Member source = msg.getAddress();
            boolean rx = false;
            boolean delivered = false;
            for (int i = 0; i < this.channelListeners.size(); ++i) {
                ChannelListener channelListener = (ChannelListener)this.channelListeners.get(i);
                if (channelListener == null || !channelListener.accept(fwd, source)) continue;
                channelListener.messageReceived(fwd, source);
                delivered = true;
                if (!(channelListener instanceof RpcChannel)) continue;
                rx = true;
            }
            if (!rx && fwd instanceof RpcMessage) {
                this.sendNoRpcChannelReply((RpcMessage)fwd, source);
            }
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel delivered[" + delivered + "] id:" + new UniqueId(msg.getUniqueId())));
            }
        }
        catch (Exception x) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Error receiving message:", (Throwable)x);
            }
            throw new RemoteProcessException("Exception:" + x.getMessage(), x);
        }
    }

    protected void sendNoRpcChannelReply(RpcMessage msg, Member destination) {
        try {
            if (msg instanceof RpcMessage.NoRpcChannelReply) {
                return;
            }
            RpcMessage.NoRpcChannelReply reply = new RpcMessage.NoRpcChannelReply(msg.rpcId, msg.uuid);
            this.send(new Member[]{destination}, reply, 8);
        }
        catch (Exception x) {
            log.error((Object)"Unable to find rpc channel, failed to send NoRpcChannelReply.", (Throwable)x);
        }
    }

    @Override
    public void memberAdded(Member member) {
        for (int i = 0; i < this.membershipListeners.size(); ++i) {
            MembershipListener membershipListener = (MembershipListener)this.membershipListeners.get(i);
            if (membershipListener == null) continue;
            membershipListener.memberAdded(member);
        }
    }

    @Override
    public void memberDisappeared(Member member) {
        for (int i = 0; i < this.membershipListeners.size(); ++i) {
            MembershipListener membershipListener = (MembershipListener)this.membershipListeners.get(i);
            if (membershipListener == null) continue;
            membershipListener.memberDisappeared(member);
        }
    }

    protected synchronized void setupDefaultStack() throws ChannelException {
        if (this.getFirstInterceptor() != null && this.getFirstInterceptor().getNext() instanceof ChannelCoordinator) {
            this.addInterceptor(new MessageDispatch15Interceptor());
        }
    }

    protected void checkOptionFlags() throws ChannelException {
        StringBuilder conflicts = new StringBuilder();
        for (ChannelInterceptor first = this.interceptors; first != null; first = first.getNext()) {
            int flag = first.getOptionFlag();
            if (flag == 0) continue;
            for (ChannelInterceptor next = first.getNext(); next != null; next = next.getNext()) {
                int nflag = next.getOptionFlag();
                if (nflag == 0 || (flag & nflag) != flag && (flag & nflag) != nflag) continue;
                conflicts.append("[");
                conflicts.append(first.getClass().getName());
                conflicts.append(":");
                conflicts.append(flag);
                conflicts.append(" == ");
                conflicts.append(next.getClass().getName());
                conflicts.append(":");
                conflicts.append(nflag);
                conflicts.append("] ");
            }
        }
        if (conflicts.length() > 0) {
            throw new ChannelException("Interceptor option flag conflict: " + conflicts.toString());
        }
    }

    @Override
    public synchronized void start(int svc) throws ChannelException {
        this.setupDefaultStack();
        if (this.optionCheck) {
            this.checkOptionFlags();
        }
        super.start(svc);
        if (this.hbthread == null && this.heartbeat) {
            this.hbthread = new HeartbeatThread(this, this.heartbeatSleeptime);
            this.hbthread.start();
        }
    }

    @Override
    public synchronized void stop(int svc) throws ChannelException {
        if (this.hbthread != null) {
            this.hbthread.stopHeartbeat();
            this.hbthread = null;
        }
        super.stop(svc);
    }

    public ChannelInterceptor getFirstInterceptor() {
        if (this.interceptors != null) {
            return this.interceptors;
        }
        return this.coordinator;
    }

    @Override
    public ChannelReceiver getChannelReceiver() {
        return this.coordinator.getClusterReceiver();
    }

    @Override
    public ChannelSender getChannelSender() {
        return this.coordinator.getClusterSender();
    }

    @Override
    public MembershipService getMembershipService() {
        return this.coordinator.getMembershipService();
    }

    @Override
    public void setChannelReceiver(ChannelReceiver clusterReceiver) {
        this.coordinator.setClusterReceiver(clusterReceiver);
    }

    @Override
    public void setChannelSender(ChannelSender clusterSender) {
        this.coordinator.setClusterSender(clusterSender);
    }

    @Override
    public void setMembershipService(MembershipService membershipService) {
        this.coordinator.setMembershipService(membershipService);
    }

    @Override
    public void addMembershipListener(MembershipListener membershipListener) {
        if (!this.membershipListeners.contains(membershipListener)) {
            this.membershipListeners.add(membershipListener);
        }
    }

    @Override
    public void removeMembershipListener(MembershipListener membershipListener) {
        this.membershipListeners.remove(membershipListener);
    }

    @Override
    public void addChannelListener(ChannelListener channelListener) {
        if (this.channelListeners.contains(channelListener)) {
            throw new IllegalArgumentException("Listener already exists:" + channelListener + "[" + channelListener.getClass().getName() + "]");
        }
        this.channelListeners.add(channelListener);
    }

    @Override
    public void removeChannelListener(ChannelListener channelListener) {
        this.channelListeners.remove(channelListener);
    }

    @Override
    public Iterator<ChannelInterceptor> getInterceptors() {
        return new InterceptorIterator(this.getNext(), this.coordinator);
    }

    public void setOptionCheck(boolean optionCheck) {
        this.optionCheck = optionCheck;
    }

    public void setHeartbeatSleeptime(long heartbeatSleeptime) {
        this.heartbeatSleeptime = heartbeatSleeptime;
    }

    @Override
    public void setHeartbeat(boolean heartbeat) {
        this.heartbeat = heartbeat;
    }

    public boolean getOptionCheck() {
        return this.optionCheck;
    }

    public boolean getHeartbeat() {
        return this.heartbeat;
    }

    public long getHeartbeatSleeptime() {
        return this.heartbeatSleeptime;
    }

    public static class HeartbeatThread
    extends Thread {
        private static final Log log = LogFactory.getLog(HeartbeatThread.class);
        protected static int counter = 1;
        protected volatile boolean doRun = true;
        protected final GroupChannel channel;
        protected final long sleepTime;

        protected static synchronized int inc() {
            return counter++;
        }

        public HeartbeatThread(GroupChannel channel, long sleepTime) {
            this.setPriority(1);
            this.setName("GroupChannel-Heartbeat-" + HeartbeatThread.inc());
            this.setDaemon(true);
            this.channel = channel;
            this.sleepTime = sleepTime;
        }

        public void stopHeartbeat() {
            this.doRun = false;
            this.interrupt();
        }

        @Override
        public void run() {
            while (this.doRun) {
                try {
                    Thread.sleep(this.sleepTime);
                    this.channel.heartbeat();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception x) {
                    log.error((Object)"Unable to send heartbeat through Tribes interceptor stack. Will try to sleep again.", (Throwable)x);
                }
            }
        }
    }

    public static class InterceptorIterator
    implements Iterator<ChannelInterceptor> {
        private final ChannelInterceptor end;
        private ChannelInterceptor start;

        public InterceptorIterator(ChannelInterceptor start, ChannelInterceptor end) {
            this.end = end;
            this.start = start;
        }

        @Override
        public boolean hasNext() {
            return this.start != null && this.start != this.end;
        }

        @Override
        public ChannelInterceptor next() {
            ChannelInterceptor result = null;
            if (this.hasNext()) {
                result = this.start;
                this.start = this.start.getNext();
            }
            return result;
        }

        @Override
        public void remove() {
        }
    }
}

