/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.bio.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.transport.bio.util.LinkObject;
import org.apache.catalina.tribes.transport.bio.util.SingleRemoveSynchronizedAddLock;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class FastQueue {
    private static final Log log = LogFactory.getLog(FastQueue.class);
    private final SingleRemoveSynchronizedAddLock lock;
    private LinkObject first = null;
    private LinkObject last = null;
    private AtomicInteger size = new AtomicInteger(0);
    private int maxQueueLength = 0;
    private long addWaitTimeout = 10000L;
    private long removeWaitTimeout = 30000L;
    private volatile boolean enabled = true;
    private int maxSize = 0;

    public FastQueue() {
        this.lock = new SingleRemoveSynchronizedAddLock();
        this.lock.setAddWaitTimeout(this.addWaitTimeout);
        this.lock.setRemoveWaitTimeout(this.removeWaitTimeout);
    }

    public long getAddWaitTimeout() {
        this.addWaitTimeout = this.lock.getAddWaitTimeout();
        return this.addWaitTimeout;
    }

    public void setAddWaitTimeout(long timeout) {
        this.addWaitTimeout = timeout;
        this.lock.setAddWaitTimeout(this.addWaitTimeout);
    }

    public long getRemoveWaitTimeout() {
        this.removeWaitTimeout = this.lock.getRemoveWaitTimeout();
        return this.removeWaitTimeout;
    }

    public void setRemoveWaitTimeout(long timeout) {
        this.removeWaitTimeout = timeout;
        this.lock.setRemoveWaitTimeout(this.removeWaitTimeout);
    }

    public int getMaxQueueLength() {
        return this.maxQueueLength;
    }

    public void setMaxQueueLength(int length) {
        this.maxQueueLength = length;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        if (!enable) {
            this.lock.abortRemove();
            this.first = null;
            this.last = null;
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public void start() {
        this.setEnabled(true);
    }

    public void stop() {
        this.setEnabled(false);
    }

    public int getSize() {
        return this.size.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ChannelMessage msg, Member[] destination, InterceptorPayload payload) {
        boolean ok = true;
        if (!this.enabled) {
            if (log.isInfoEnabled()) {
                log.info((Object)"FastQueue.add: queue disabled, add aborted");
            }
            return false;
        }
        this.lock.lockAdd();
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.add: starting with size " + this.size.get()));
            }
            if (this.maxQueueLength > 0 && this.size.get() >= this.maxQueueLength) {
                ok = false;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("FastQueue.add: Could not add, since queue is full (" + this.size.get() + ">=" + this.maxQueueLength + ")"));
                }
            } else {
                LinkObject element = new LinkObject(msg, destination, payload);
                if (this.size.get() == 0) {
                    this.first = this.last = element;
                    this.size.set(1);
                } else if (this.last == null) {
                    ok = false;
                    log.error((Object)("FastQueue.add: Could not add, since last is null although size is " + this.size.get() + " (>0)"));
                } else {
                    this.last.append(element);
                    this.last = element;
                    this.size.incrementAndGet();
                }
            }
            if (this.first == null) {
                log.error((Object)("FastQueue.add: first is null, size is " + this.size.get() + " at end of add"));
            }
            if (this.last == null) {
                log.error((Object)("FastQueue.add: last is null, size is " + this.size.get() + " at end of add"));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.add: add ending with size " + this.size.get()));
            }
        }
        finally {
            this.lock.unlockAdd(true);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkObject remove() {
        LinkObject element;
        if (!this.enabled) {
            if (log.isInfoEnabled()) {
                log.info((Object)"FastQueue.remove: queue disabled, remove aborted");
            }
            return null;
        }
        boolean gotLock = this.lock.lockRemove();
        try {
            if (!gotLock) {
                if (this.enabled) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"FastQueue.remove: Remove aborted although queue enabled");
                    }
                } else if (log.isInfoEnabled()) {
                    log.info((Object)"FastQueue.remove: queue disabled, remove aborted");
                }
                LinkObject linkObject = null;
                return linkObject;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.remove: remove starting with size " + this.size.get()));
            }
            element = this.first;
            this.last = null;
            this.first = null;
            this.size.set(0);
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.remove: remove ending with size " + this.size.get()));
            }
        }
        finally {
            this.lock.unlockRemove();
        }
        return element;
    }
}

