/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.group.interceptors.EncryptInterceptorMBean;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class EncryptInterceptor
extends ChannelInterceptorBase
implements EncryptInterceptorMBean {
    private static final Log log = LogFactory.getLog(EncryptInterceptor.class);
    protected static final StringManager sm = StringManager.getManager(EncryptInterceptor.class);
    private static final String DEFAULT_ENCRYPTION_ALGORITHM = "AES/CBC/PKCS5Padding";
    private String providerName;
    private String encryptionAlgorithm = "AES/CBC/PKCS5Padding";
    private byte[] encryptionKeyBytes;
    private Cipher encryptionCipher;
    private Cipher decryptionCipher;
    private static final int[] DEC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    @Override
    public void start(int svc) throws ChannelException {
        if (2 == (svc & 2)) {
            try {
                this.initCiphers();
            }
            catch (GeneralSecurityException gse) {
                log.fatal((Object)sm.getString("encryptInterceptor.init.failed"));
                throw new ChannelException(sm.getString("encryptInterceptor.init.failed"), gse);
            }
        }
        super.start(svc);
    }

    @Override
    public void sendMessage(Member[] destination, ChannelMessage msg, InterceptorPayload payload) throws ChannelException {
        try {
            byte[] data = msg.getMessage().getBytes();
            byte[][] bytes = this.encrypt(data);
            XByteBuffer xbb = msg.getMessage();
            xbb.setLength(0);
            xbb.append(bytes[0], 0, bytes[0].length);
            xbb.append(bytes[1], 0, bytes[1].length);
            super.sendMessage(destination, msg, payload);
        }
        catch (IllegalBlockSizeException ibse) {
            log.error((Object)sm.getString("encryptInterceptor.encrypt.failed"));
            throw new ChannelException(ibse);
        }
        catch (BadPaddingException bpe) {
            log.error((Object)sm.getString("encryptInterceptor.encrypt.failed"));
            throw new ChannelException(bpe);
        }
    }

    @Override
    public void messageReceived(ChannelMessage msg) {
        try {
            byte[] data = msg.getMessage().getBytes();
            data = this.decrypt(data);
            int blockSize = this.getDecryptionCipher().getBlockSize();
            int trimmedSize = data.length - blockSize;
            if (trimmedSize < 0) {
                log.error((Object)sm.getString("encryptInterceptor.decrypt.error.short-message"));
                throw new IllegalStateException(sm.getString("encryptInterceptor.decrypt.error.short-message"));
            }
            XByteBuffer xbb = msg.getMessage();
            xbb.setLength(0);
            xbb.append(data, blockSize, data.length - blockSize);
            super.messageReceived(msg);
        }
        catch (IllegalBlockSizeException ibse) {
            log.error((Object)sm.getString("encryptInterceptor.decrypt.failed"), (Throwable)ibse);
        }
        catch (BadPaddingException bpe) {
            log.error((Object)sm.getString("encryptInterceptor.decrypt.failed"), (Throwable)bpe);
        }
    }

    @Override
    public void setEncryptionAlgorithm(String algorithm) {
        if (null == this.getEncryptionAlgorithm()) {
            throw new IllegalStateException(sm.getString("encryptInterceptor.algorithm.required"));
        }
        int pos = algorithm.indexOf(47);
        if (pos < 0) {
            throw new IllegalArgumentException(sm.getString("encryptInterceptor.algorithm.required"));
        }
        if ((pos = algorithm.indexOf(47, pos + 1)) < 0) {
            throw new IllegalArgumentException(sm.getString("encryptInterceptor.algorithm.required"));
        }
        this.encryptionAlgorithm = algorithm;
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    public void setEncryptionKey(byte[] key) {
        this.encryptionKeyBytes = (byte[])(null == key ? null : (byte[])key.clone());
    }

    public void setEncryptionKey(String keyBytes) {
        if (null == keyBytes) {
            this.setEncryptionKey((byte[])null);
        } else {
            this.setEncryptionKey(EncryptInterceptor.fromHexString(keyBytes.trim()));
        }
    }

    @Override
    public byte[] getEncryptionKey() {
        byte[] key = this.getEncryptionKeyInternal();
        if (null != key) {
            key = (byte[])key.clone();
        }
        return key;
    }

    private byte[] getEncryptionKeyInternal() {
        return this.encryptionKeyBytes;
    }

    @Override
    public void setProviderName(String provider) {
        this.providerName = provider;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    private void initCiphers() throws GeneralSecurityException {
        if (null == this.getEncryptionKey()) {
            throw new IllegalStateException(sm.getString("encryptInterceptor.key.required"));
        }
        String algorithm = this.getEncryptionAlgorithm();
        String mode = EncryptInterceptor.getAlgorithmMode(algorithm);
        if (!"CBC".equalsIgnoreCase(mode)) {
            throw new IllegalArgumentException(sm.getString("encryptInterceptor.algorithm.requires-cbc-mode", mode));
        }
        String providerName = this.getProviderName();
        Cipher cipher = null == providerName ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, this.getProviderName());
        byte[] iv = new byte[cipher.getBlockSize()];
        new SecureRandom().nextBytes(iv);
        IvParameterSpec IV = new IvParameterSpec(iv);
        int pos = algorithm.indexOf(47);
        String bareAlgorithm = pos >= 0 ? algorithm.substring(0, pos) : algorithm;
        SecretKeySpec encryptionKey = new SecretKeySpec(this.getEncryptionKey(), bareAlgorithm);
        cipher.init(1, (Key)encryptionKey, IV);
        this.encryptionCipher = cipher;
        cipher = null == providerName ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, this.getProviderName());
        cipher.init(2, (Key)encryptionKey, new IvParameterSpec(iv));
        this.decryptionCipher = cipher;
    }

    private Cipher getEncryptionCipher() {
        return this.encryptionCipher;
    }

    private Cipher getDecryptionCipher() {
        return this.decryptionCipher;
    }

    private static String getAlgorithmMode(String algorithm) {
        int start = algorithm.indexOf(47);
        if (start < 0) {
            throw new IllegalArgumentException(sm.getString("encryptInterceptor.algorithm.required"));
        }
        int end = algorithm.indexOf(47, start + 1);
        if (start < 0) {
            throw new IllegalArgumentException(sm.getString("encryptInterceptor.algorithm.required"));
        }
        return algorithm.substring(start + 1, end);
    }

    private byte[][] encrypt(byte[] bytes) throws IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = this.getEncryptionCipher();
        byte[] iv = cipher.getIV();
        byte[][] data = new byte[][]{cipher.update(iv, 0, iv.length), cipher.doFinal(bytes)};
        return data;
    }

    private byte[] decrypt(byte[] bytes) throws IllegalBlockSizeException, BadPaddingException {
        return this.getDecryptionCipher().doFinal(bytes);
    }

    private static int getDec(int index) {
        try {
            return DEC[index - 48];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return -1;
        }
    }

    private static byte[] fromHexString(String input) {
        if (input == null) {
            return null;
        }
        if ((input.length() & 1) == 1) {
            throw new IllegalArgumentException(sm.getString("hexUtils.fromHex.oddDigits"));
        }
        char[] inputChars = input.toCharArray();
        byte[] result = new byte[input.length() >> 1];
        for (int i = 0; i < result.length; ++i) {
            int upperNibble = EncryptInterceptor.getDec(inputChars[2 * i]);
            int lowerNibble = EncryptInterceptor.getDec(inputChars[2 * i + 1]);
            if (upperNibble < 0 || lowerNibble < 0) {
                throw new IllegalArgumentException(sm.getString("hexUtils.fromHex.nonHex"));
            }
            result[i] = (byte)((upperNibble << 4) + lowerNibble);
        }
        return result;
    }
}

