/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.tomcat.util.descriptor.Constants;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class LocalResolver
implements EntityResolver2 {
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private final Map<String, String> publicIds;
    private final Map<String, String> systemIds;
    private final boolean blockExternal;

    public LocalResolver(Map<String, String> publicIds, Map<String, String> systemIds, boolean blockExternal) {
        this.publicIds = publicIds;
        this.systemIds = systemIds;
        this.blockExternal = blockExternal;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String base, String systemId) throws SAXException, IOException {
        URI systemUri;
        String resolved = this.publicIds.get(publicId);
        if (resolved != null) {
            InputSource is = new InputSource(resolved);
            is.setPublicId(publicId);
            return is;
        }
        if (systemId == null) {
            throw new FileNotFoundException(sm.getString("localResolver.unresolvedEntity", new Object[]{name, publicId, systemId, base}));
        }
        resolved = this.systemIds.get(systemId);
        if (resolved != null) {
            InputSource is = new InputSource(resolved);
            is.setPublicId(publicId);
            return is;
        }
        try {
            if (base == null) {
                systemUri = new URI(systemId);
            } else {
                URI baseUri = new URI(base);
                systemUri = new URL(baseUri.toURL(), systemId).toURI();
            }
            systemUri = systemUri.normalize();
        }
        catch (URISyntaxException e) {
            if (this.blockExternal) {
                throw new MalformedURLException(e.getMessage());
            }
            return new InputSource(systemId);
        }
        if (systemUri.isAbsolute()) {
            InputSource is;
            resolved = this.systemIds.get(systemUri.toString());
            if (resolved != null) {
                is = new InputSource(resolved);
                is.setPublicId(publicId);
                return is;
            }
            if (!this.blockExternal) {
                is = new InputSource(systemUri.toString());
                is.setPublicId(publicId);
                return is;
            }
        }
        throw new FileNotFoundException(sm.getString("localResolver.unresolvedEntity", new Object[]{name, publicId, systemId, base}));
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }
}

