/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.util.file.Matcher;

public class StandardJarScanFilter
implements JarScanFilter {
    private final ReadWriteLock configurationLock = new ReentrantReadWriteLock();
    private String defaultSkip;
    private String defaultScan;
    private Set<String[]> defaultSkipSet = new HashSet<String[]>();
    private Set<String[]> defaultScanSet = new HashSet<String[]>();
    private String tldSkip;
    private String tldScan;
    private Set<String[]> tldSkipSet = new HashSet<String[]>();
    private Set<String[]> tldScanSet = new HashSet<String[]>();
    private boolean defaultTldScan = true;
    private String pluggabilitySkip;
    private String pluggabilityScan;
    private Set<String[]> pluggabilitySkipSet = new HashSet<String[]>();
    private Set<String[]> pluggabilityScanSet = new HashSet<String[]>();
    private boolean defaultPluggabilityScan = true;

    public StandardJarScanFilter() {
        this.defaultSkip = System.getProperty("tomcat.util.scan.StandardJarScanFilter.jarsToSkip");
        this.populateSetFromAttribute(this.defaultSkip, this.defaultSkipSet);
        this.defaultScan = System.getProperty("tomcat.util.scan.StandardJarScanFilter.jarsToScan");
        this.populateSetFromAttribute(this.defaultScan, this.defaultScanSet);
        this.tldSkip = System.getProperty("tomcat.util.scan.StandardJarScanFilter.jarsToSkip");
        this.populateSetFromAttribute(this.tldSkip, this.tldSkipSet);
        this.tldScan = System.getProperty("tomcat.util.scan.StandardJarScanFilter.jarsToScan");
        this.populateSetFromAttribute(this.tldScan, this.tldScanSet);
        this.pluggabilitySkip = System.getProperty("tomcat.util.scan.StandardJarScanFilter.jarsToSkip");
        this.populateSetFromAttribute(this.pluggabilitySkip, this.pluggabilitySkipSet);
        this.pluggabilityScan = System.getProperty("tomcat.util.scan.StandardJarScanFilter.jarsToScan");
        this.populateSetFromAttribute(this.pluggabilityScan, this.pluggabilityScanSet);
    }

    public String getTldSkip() {
        return this.tldSkip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTldSkip(String tldSkip) {
        this.tldSkip = tldSkip;
        Lock writeLock = this.configurationLock.writeLock();
        try {
            writeLock.lock();
            this.populateSetFromAttribute(tldSkip, this.tldSkipSet);
        }
        finally {
            writeLock.unlock();
        }
    }

    public String getTldScan() {
        return this.tldScan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTldScan(String tldScan) {
        this.tldScan = tldScan;
        Lock writeLock = this.configurationLock.writeLock();
        try {
            writeLock.lock();
            this.populateSetFromAttribute(tldScan, this.tldScanSet);
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean isDefaultTldScan() {
        return this.defaultTldScan;
    }

    public void setDefaultTldScan(boolean defaultTldScan) {
        this.defaultTldScan = defaultTldScan;
    }

    public String getPluggabilitySkip() {
        return this.pluggabilitySkip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPluggabilitySkip(String pluggabilitySkip) {
        this.pluggabilitySkip = pluggabilitySkip;
        Lock writeLock = this.configurationLock.writeLock();
        try {
            writeLock.lock();
            this.populateSetFromAttribute(pluggabilitySkip, this.pluggabilitySkipSet);
        }
        finally {
            writeLock.unlock();
        }
    }

    public String getPluggabilityScan() {
        return this.pluggabilityScan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPluggabilityScan(String pluggabilityScan) {
        this.pluggabilityScan = pluggabilityScan;
        Lock writeLock = this.configurationLock.writeLock();
        try {
            writeLock.lock();
            this.populateSetFromAttribute(pluggabilityScan, this.pluggabilityScanSet);
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean isDefaultPluggabilityScan() {
        return this.defaultPluggabilityScan;
    }

    public void setDefaultPluggabilityScan(boolean defaultPluggabilityScan) {
        this.defaultPluggabilityScan = defaultPluggabilityScan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean check(JarScanType jarScanType, String jarName) {
        toSkip = new HashSet<String[]>();
        toScan = new HashSet<String[]>();
        readLock = this.configurationLock.readLock();
        try {
            readLock.lock();
            switch (1.$SwitchMap$org$apache$tomcat$JarScanType[jarScanType.ordinal()]) {
                case 1: {
                    defaultScan = this.defaultTldScan;
                    toSkip.addAll(this.tldSkipSet);
                    toScan.addAll(this.tldScanSet);
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                case 2: {
                    defaultScan = this.defaultPluggabilityScan;
                    toSkip.addAll(this.pluggabilitySkipSet);
                    toScan.addAll(this.pluggabilityScanSet);
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                default: {
                    defaultScan = true;
                    toSkip.addAll(this.defaultSkipSet);
                    toScan.addAll(this.defaultScanSet);
                    break;
                }
            }
        }
        finally {
            readLock.unlock();
        }
        if (defaultScan) {
            if (Matcher.matchPath(toSkip, jarName)) {
                return Matcher.matchPath(toScan, jarName) != false;
            }
            return true;
        }
        if (Matcher.matchPath(toScan, jarName)) {
            return Matcher.matchPath(toSkip, jarName) == false;
        }
        return false;
    }

    private void populateSetFromAttribute(String attribute, Set<String[]> set) {
        set.clear();
        if (attribute != null) {
            StringTokenizer tokenizer = new StringTokenizer(attribute, ",");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken().trim();
                set.add(Matcher.tokenizePathAsArray(token));
            }
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$tomcat$JarScanType;

        static {
            $SwitchMap$org$apache$tomcat$JarScanType = new int[JarScanType.values().length];
            try {
                1.$SwitchMap$org$apache$tomcat$JarScanType[JarScanType.TLD.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$tomcat$JarScanType[JarScanType.PLUGGABILITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$tomcat$JarScanType[JarScanType.OTHER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

