/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import org.apache.tomcat.util.compat.Jre22Compat;

public class JreCompat {
    private static final JreCompat instance;
    private static final boolean graalAvailable;
    private static final boolean jre22Available;

    public static JreCompat getInstance() {
        return instance;
    }

    public static boolean isGraalAvailable() {
        return graalAvailable;
    }

    public static boolean isJre22Available() {
        return jre22Available;
    }

    static {
        boolean result = false;
        try {
            Class<?> nativeImageClazz = Class.forName("org.graalvm.nativeimage.ImageInfo");
            result = Boolean.TRUE.equals(nativeImageClazz.getMethod("inImageCode", new Class[0]).invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            // empty catch block
        }
        boolean bl = graalAvailable = result || System.getProperty("org.graalvm.nativeimage.imagecode") != null;
        if (Jre22Compat.isSupported()) {
            instance = new Jre22Compat();
            jre22Available = true;
        } else {
            instance = new JreCompat();
            jre22Available = false;
        }
    }
}

