/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

public class JreCompat {
    private static final JreCompat instance;
    private static final boolean graalAvailable;

    public static JreCompat getInstance() {
        return instance;
    }

    public static boolean isGraalAvailable() {
        return graalAvailable;
    }

    static {
        boolean result = false;
        try {
            Class<?> nativeImageClazz = Class.forName("org.graalvm.nativeimage.ImageInfo");
            result = Boolean.TRUE.equals(nativeImageClazz.getMethod("inImageCode", new Class[0]).invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            // empty catch block
        }
        graalAvailable = result || System.getProperty("org.graalvm.nativeimage.imagecode") != null;
        instance = new JreCompat();
    }
}

