/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.NonClosingJarInputStream;

public class UrlJar
implements Jar {
    private NonClosingJarInputStream jarInputStream = null;
    private URL url = null;
    private JarEntry entry = null;
    private Map<String, String> mrMap = null;

    public UrlJar(URL url) throws IOException {
        String mrValue;
        Manifest manifest;
        this.url = url;
        this.jarInputStream = this.createJarInputStream();
        boolean multiRelease = false;
        if (JreCompat.isJre9Available() && (manifest = this.jarInputStream.getManifest()) != null && (mrValue = manifest.getMainAttributes().getValue("Multi-Release")) != null) {
            multiRelease = Boolean.valueOf(mrValue);
        }
        if (multiRelease) {
            this.populateMrMap();
        }
    }

    @Override
    @Deprecated
    public boolean entryExists(String name) throws IOException {
        return false;
    }

    @Override
    public InputStream getInputStream(String name) throws IOException {
        JarEntry entry = this.jarInputStream.getNextJarEntry();
        while (entry != null && !name.equals(entry.getName())) {
            entry = this.jarInputStream.getNextJarEntry();
        }
        if (entry == null) {
            return null;
        }
        return this.jarInputStream;
    }

    @Override
    public void close() {
        if (this.jarInputStream != null) {
            try {
                this.jarInputStream.reallyClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private NonClosingJarInputStream createJarInputStream() throws IOException {
        JarURLConnection jarConn = (JarURLConnection)this.url.openConnection();
        URL resourceURL = jarConn.getJarFileURL();
        URLConnection resourceConn = resourceURL.openConnection();
        resourceConn.setUseCaches(false);
        return new NonClosingJarInputStream(resourceConn.getInputStream());
    }

    @Override
    public void nextEntry() {
        try {
            this.entry = this.jarInputStream.getNextJarEntry();
            if (this.mrMap != null) {
                while (this.entry != null && (this.mrMap.keySet().contains(this.entry.getName()) || this.entry.getName().startsWith("META-INF/versions/") && !this.mrMap.values().contains(this.entry.getName()))) {
                    this.entry = this.jarInputStream.getNextJarEntry();
                }
            } else {
                while (this.entry != null && this.entry.getName().startsWith("META-INF/versions/")) {
                    this.entry = this.jarInputStream.getNextJarEntry();
                }
            }
        }
        catch (IOException ioe) {
            this.entry = null;
        }
    }

    @Override
    public String getEntryName() {
        if (this.entry == null) {
            return null;
        }
        return this.entry.getName();
    }

    @Override
    public InputStream getEntryInputStream() throws IOException {
        return this.jarInputStream;
    }

    @Override
    public void reset() throws IOException {
        this.close();
        this.entry = null;
        this.jarInputStream = this.createJarInputStream();
    }

    private void populateMrMap() throws IOException {
        int targetVersion = JreCompat.getInstance().jarFileRuntimeMajorVersion();
        HashMap<String, Integer> mrVersions = new HashMap<String, Integer>();
        JarEntry jarEntry = this.jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            int i;
            String name = jarEntry.getName();
            if (name.startsWith("META-INF/versions/") && name.endsWith(".class") && (i = name.indexOf(47, 18)) > 0) {
                String baseName = name.substring(i + 1);
                int version = Integer.parseInt(name.substring(18, i));
                if (version <= targetVersion) {
                    Integer mappedVersion = (Integer)mrVersions.get(baseName);
                    if (mappedVersion == null) {
                        mrVersions.put(baseName, version);
                    } else if (version > mappedVersion) {
                        mrVersions.put(baseName, version);
                    }
                }
            }
            jarEntry = this.jarInputStream.getNextJarEntry();
        }
        this.mrMap = new HashMap<String, String>();
        for (Map.Entry mrVersion : mrVersions.entrySet()) {
            this.mrMap.put((String)mrVersion.getKey(), "META-INF/versions/" + ((Integer)mrVersion.getValue()).toString() + "/" + (String)mrVersion.getKey());
        }
        this.close();
        this.jarInputStream = this.createJarInputStream();
    }
}

