/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.NonClosingJarInputStream;

public class FileUrlNestedJar
implements Jar {
    private final JarFile warFile;
    private final JarEntry jarEntry;
    private NonClosingJarInputStream jarInputStream = null;
    private JarEntry entry = null;

    public FileUrlNestedJar(URL url) throws IOException {
        JarURLConnection jarConn = (JarURLConnection)url.openConnection();
        jarConn.setUseCaches(false);
        this.warFile = jarConn.getJarFile();
        String urlAsString = url.toString();
        int pathStart = urlAsString.indexOf("!/") + 2;
        String jarPath = urlAsString.substring(pathStart);
        this.jarEntry = this.warFile.getJarEntry(jarPath);
        this.jarInputStream = this.createJarInputStream();
    }

    @Override
    public boolean entryExists(String name) throws IOException {
        JarEntry entry = this.jarInputStream.getNextJarEntry();
        while (entry != null && !name.equals(entry.getName())) {
            entry = this.jarInputStream.getNextJarEntry();
        }
        return entry != null;
    }

    @Override
    public InputStream getInputStream(String name) throws IOException {
        JarEntry entry = this.jarInputStream.getNextJarEntry();
        while (entry != null && !name.equals(entry.getName())) {
            entry = this.jarInputStream.getNextJarEntry();
        }
        if (entry == null) {
            return null;
        }
        return this.jarInputStream;
    }

    @Override
    public void close() {
        this.closeInner();
        if (this.warFile != null) {
            try {
                this.warFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeInner() {
        if (this.jarInputStream != null) {
            try {
                this.jarInputStream.reallyClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private NonClosingJarInputStream createJarInputStream() throws IOException {
        return new NonClosingJarInputStream(this.warFile.getInputStream(this.jarEntry));
    }

    @Override
    public void nextEntry() {
        try {
            this.entry = this.jarInputStream.getNextJarEntry();
        }
        catch (IOException ioe) {
            this.entry = null;
        }
    }

    @Override
    public String getEntryName() {
        if (this.entry == null) {
            return null;
        }
        return this.entry.getName();
    }

    @Override
    public InputStream getEntryInputStream() throws IOException {
        return this.jarInputStream;
    }

    @Override
    public void reset() throws IOException {
        this.closeInner();
        this.jarInputStream = this.createJarInputStream();
    }
}

