/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tomcat.util.scan.FileUrlJar;
import org.apache.tomcat.util.scan.FileUrlNestedJar;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.UrlJar;

public class JarFactory {
    private JarFactory() {
    }

    public static Jar newInstance(URL url) throws IOException {
        String jarUrl = url.toString();
        if (jarUrl.startsWith("jar:file:")) {
            if (jarUrl.endsWith("!/")) {
                return new FileUrlJar(url);
            }
            return new FileUrlNestedJar(url);
        }
        return new UrlJar(url);
    }

    public static URL getJarEntryURL(URL baseUrl, String entryName) throws MalformedURLException {
        String baseExternal = baseUrl.toExternalForm();
        if (baseExternal.startsWith("jar")) {
            baseExternal = baseExternal.replaceFirst("^jar:", "war:");
            baseExternal = baseExternal.replaceFirst("!/", "^/");
        }
        return new URL("jar:" + baseExternal + "!/" + entryName);
    }
}

