/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.scan.StandardJarScanFilter;

public class StandardJarScanner
implements JarScanner {
    private static final Log log = LogFactory.getLog(StandardJarScanner.class);
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.scan");
    private boolean scanClassPath = true;
    private boolean scanAllFiles = false;
    private boolean scanAllDirectories = false;
    private boolean scanBootstrapClassPath = false;
    private JarScanFilter jarScanFilter = new StandardJarScanFilter();

    public boolean isScanClassPath() {
        return this.scanClassPath;
    }

    public void setScanClassPath(boolean scanClassPath) {
        this.scanClassPath = scanClassPath;
    }

    public boolean isScanAllFiles() {
        return this.scanAllFiles;
    }

    public void setScanAllFiles(boolean scanAllFiles) {
        this.scanAllFiles = scanAllFiles;
    }

    public boolean isScanAllDirectories() {
        return this.scanAllDirectories;
    }

    public void setScanAllDirectories(boolean scanAllDirectories) {
        this.scanAllDirectories = scanAllDirectories;
    }

    public boolean isScanBootstrapClassPath() {
        return this.scanBootstrapClassPath;
    }

    public void setScanBootstrapClassPath(boolean scanBootstrapClassPath) {
        this.scanBootstrapClassPath = scanBootstrapClassPath;
    }

    public JarScanFilter getJarScanFilter() {
        return this.jarScanFilter;
    }

    public void setJarScanFilter(JarScanFilter jarScanFilter) {
        this.jarScanFilter = jarScanFilter;
    }

    public void scan(JarScanType scanType, ServletContext context, JarScannerCallback callback) {
        Set dirList;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("jarScan.webinflibStart"));
        }
        if ((dirList = context.getResourcePaths("/WEB-INF/lib/")) != null) {
            for (String path : dirList) {
                if (path.endsWith(".jar") && this.jarScanFilter.check(scanType, path.substring(path.lastIndexOf(47) + 1))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("jarScan.webinflibJarScan", path));
                    }
                    URL url = null;
                    try {
                        String realPath = context.getRealPath(path);
                        url = realPath == null ? context.getResource(path) : new File(realPath).toURI().toURL();
                        this.process(scanType, callback, url, true);
                    }
                    catch (IOException e) {
                        log.warn((Object)sm.getString("jarScan.webinflibFail", url), (Throwable)e);
                    }
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)sm.getString("jarScan.webinflibJarNoScan", path));
            }
        }
        if (this.scanAllDirectories) {
            try {
                URL url = context.getResource("/WEB-INF/classes/META-INF");
                if (url != null) {
                    try {
                        callback.scanWebInfClasses();
                    }
                    catch (IOException e) {
                        log.warn((Object)sm.getString("jarScan.webinfclassesFail"), (Throwable)e);
                    }
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (this.scanClassPath) {
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("jarScan.classloaderStart"));
            }
            ClassLoader stopLoader = null;
            if (!this.scanBootstrapClassPath) {
                stopLoader = ClassLoader.getSystemClassLoader().getParent();
            }
            ClassLoader classLoader = context.getClassLoader();
            boolean isWebapp = true;
            for (classLoader = classLoader.getParent(); classLoader != null && classLoader != stopLoader; classLoader = classLoader.getParent()) {
                if (!(classLoader instanceof URLClassLoader)) continue;
                if (isWebapp) {
                    isWebapp = this.isWebappClassLoader(classLoader);
                }
                URL[] urls = ((URLClassLoader)classLoader).getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    ClassPathEntry cpe = new ClassPathEntry(urls[i]);
                    if ((cpe.isJar() || scanType == JarScanType.PLUGGABILITY || this.isScanAllDirectories()) && this.jarScanFilter.check(scanType, cpe.getName())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("jarScan.classloaderJarScan", urls[i]));
                        }
                        try {
                            this.process(scanType, callback, urls[i], isWebapp);
                        }
                        catch (IOException ioe) {
                            log.warn((Object)sm.getString("jarScan.classloaderFail", urls[i]), (Throwable)ioe);
                        }
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)sm.getString("jarScan.classloaderJarNoScan", urls[i]));
                }
            }
        }
    }

    private boolean isWebappClassLoader(ClassLoader classLoader) {
        for (ClassLoader nonWebappLoader = StandardJarScanner.class.getClassLoader(); nonWebappLoader != null; nonWebappLoader = nonWebappLoader.getParent()) {
            if (nonWebappLoader != classLoader) continue;
            return false;
        }
        return true;
    }

    private void process(JarScanType scanType, JarScannerCallback callback, URL url, boolean isWebapp) throws IOException {
        URLConnection conn;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("jarScan.jarUrlStart", url));
        }
        if ((conn = url.openConnection()) instanceof JarURLConnection) {
            callback.scan((JarURLConnection)conn, isWebapp);
        } else {
            String urlStr = url.toString();
            if (urlStr.startsWith("file:") || urlStr.startsWith("jndi:") || urlStr.startsWith("http:") || urlStr.startsWith("https:")) {
                if (urlStr.endsWith(".jar")) {
                    URL jarURL = new URL("jar:" + urlStr + "!/");
                    callback.scan((JarURLConnection)jarURL.openConnection(), isWebapp);
                } else {
                    try {
                        File f = new File(url.toURI());
                        if (f.isFile() && this.scanAllFiles) {
                            URL jarURL = new URL("jar:" + urlStr + "!/");
                            callback.scan((JarURLConnection)jarURL.openConnection(), isWebapp);
                        } else if (f.isDirectory()) {
                            if (scanType == JarScanType.PLUGGABILITY) {
                                callback.scan(f, isWebapp);
                            } else {
                                File metainf = new File(f.getAbsoluteFile() + File.separator + "META-INF");
                                if (metainf.isDirectory()) {
                                    callback.scan(f, isWebapp);
                                }
                            }
                        }
                    }
                    catch (URISyntaxException e) {
                        IOException ioe = new IOException();
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
            }
        }
    }

    private static class ClassPathEntry {
        private final boolean jar;
        private final String name;

        public ClassPathEntry(URL url) {
            String path = url.getPath();
            int end = path.indexOf(".jar");
            if (end != -1) {
                this.jar = true;
                int start = path.lastIndexOf(47, end);
                this.name = path.substring(start + 1, end + 4);
            } else {
                this.jar = false;
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                int start = path.lastIndexOf(47);
                this.name = path.substring(start + 1);
            }
        }

        public boolean isJar() {
            return this.jar;
        }

        public String getName() {
            return this.name;
        }
    }
}

