/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.tomcat.util.compat.Jre9Compat;
import org.apache.tomcat.util.res.StringManager;

public class JreCompat {
    private static final JreCompat instance;
    private static final boolean jre9Available;
    private static final StringManager sm;

    public static JreCompat getInstance() {
        return instance;
    }

    public static boolean isJre9Available() {
        return jre9Available;
    }

    public boolean isInstanceOfInaccessibleObjectException(Throwable t) {
        return false;
    }

    public void setApplicationProtocols(SSLParameters sslParameters, String[] protocols) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noApplicationProtocols"));
    }

    public String getApplicationProtocol(SSLEngine sslEngine) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noApplicationProtocol"));
    }

    static {
        sm = StringManager.getManager(JreCompat.class);
        if (Jre9Compat.isSupported()) {
            instance = new Jre9Compat();
            jre9Available = true;
        } else {
            instance = new JreCompat();
            jre9Available = false;
        }
    }
}

