/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.WsWebSocketContainer;
import org.apache.tomcat.websocket.pojo.PojoEndpointServer;
import org.apache.tomcat.websocket.pojo.PojoMethodMapping;
import org.apache.tomcat.websocket.server.Constants;
import org.apache.tomcat.websocket.server.UriTemplate;
import org.apache.tomcat.websocket.server.WsFilter;
import org.apache.tomcat.websocket.server.WsMappingResult;
import org.apache.tomcat.websocket.server.WsWriteTimeout;

public class WsServerContainer
extends WsWebSocketContainer
implements ServerContainer {
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private static final CloseReason AUTHENTICATED_HTTP_SESSION_CLOSED = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, "This connection was established under an authenticated HTTP session that has ended.");
    private final WsWriteTimeout wsWriteTimeout = new WsWriteTimeout();
    private final ServletContext servletContext;
    private final Map<String, ServerEndpointConfig> configExactMatchMap = new ConcurrentHashMap<String, ServerEndpointConfig>();
    private final ConcurrentHashMap<Integer, SortedSet<TemplatePathMatch>> configTemplateMatchMap = new ConcurrentHashMap();
    private volatile boolean enforceNoAddAfterHandshake = org.apache.tomcat.websocket.Constants.STRICT_SPEC_COMPLIANCE;
    private volatile boolean addAllowed = true;
    private final ConcurrentHashMap<String, Set<WsSession>> authenticatedSessions = new ConcurrentHashMap();

    WsServerContainer(ServletContext servletContext) {
        this.servletContext = servletContext;
        String value = servletContext.getInitParameter("org.apache.tomcat.websocket.binaryBufferSize");
        if (value != null) {
            this.setDefaultMaxBinaryMessageBufferSize(Integer.parseInt(value));
        }
        if ((value = servletContext.getInitParameter("org.apache.tomcat.websocket.textBufferSize")) != null) {
            this.setDefaultMaxTextMessageBufferSize(Integer.parseInt(value));
        }
        if ((value = servletContext.getInitParameter("org.apache.tomcat.websocket.noAddAfterHandshake")) != null) {
            this.setEnforceNoAddAfterHandshake(Boolean.parseBoolean(value));
        }
        FilterRegistration.Dynamic fr = servletContext.addFilter(WsFilter.class.getName(), (Filter)new WsFilter(this));
        EnumSet<DispatcherType> types = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD);
        fr.addMappingForUrlPatterns(types, true, new String[]{"/*"});
    }

    public void addEndpoint(ServerEndpointConfig sec) throws DeploymentException {
        if (this.enforceNoAddAfterHandshake && !this.addAllowed) {
            throw new DeploymentException(sm.getString("serverContainer.addNotAllowed"));
        }
        if (this.servletContext == null) {
            throw new DeploymentException(sm.getString("serverContainer.servletContextMissing"));
        }
        String path = sec.getPath();
        UriTemplate uriTemplate = new UriTemplate(path);
        if (uriTemplate.hasParameters()) {
            Integer key = uriTemplate.getSegmentCount();
            SortedSet<TemplatePathMatch> templateMatches = this.configTemplateMatchMap.get(key);
            if (templateMatches == null) {
                templateMatches = new TreeSet<TemplatePathMatch>(TemplatePathMatchComparator.getInstance());
                this.configTemplateMatchMap.putIfAbsent(key, templateMatches);
                templateMatches = this.configTemplateMatchMap.get(key);
            }
            if (!templateMatches.add(new TemplatePathMatch(sec, uriTemplate))) {
                throw new DeploymentException(sm.getString("serverContainer.duplicatePaths", new Object[]{path}));
            }
        } else {
            ServerEndpointConfig old = this.configExactMatchMap.put(path, sec);
            if (old != null) {
                throw new DeploymentException(sm.getString("serverContainer.duplicatePaths", new Object[]{path}));
            }
        }
    }

    public void addEndpoint(Class<?> pojo) throws DeploymentException {
        ServerEndpoint annotation = pojo.getAnnotation(ServerEndpoint.class);
        if (annotation == null) {
            throw new DeploymentException(sm.getString("serverContainer.missingAnnotation", new Object[]{pojo.getName()}));
        }
        String path = annotation.value();
        WsServerContainer.validateEncoders(annotation.encoders());
        PojoMethodMapping methodMapping = new PojoMethodMapping(pojo, annotation.decoders(), path);
        Class configuratorClazz = annotation.configurator();
        ServerEndpointConfig.Configurator configurator = null;
        if (!configuratorClazz.equals(ServerEndpointConfig.Configurator.class)) {
            try {
                configurator = (ServerEndpointConfig.Configurator)annotation.configurator().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DeploymentException(sm.getString("serverContainer.configuratorFail", new Object[]{annotation.configurator().getName(), pojo.getClass().getName()}), (Throwable)e);
            }
        }
        ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(pojo, (String)path).decoders(Arrays.asList(annotation.decoders())).encoders(Arrays.asList(annotation.encoders())).subprotocols(Arrays.asList(annotation.subprotocols())).configurator(configurator).build();
        sec.getUserProperties().put("org.apache.tomcat.websocket.pojo.PojoEndpoint.methodMapping", methodMapping);
        this.addEndpoint(sec);
    }

    public WsMappingResult findMapping(String path) {
        ServerEndpointConfig sec;
        if (this.addAllowed) {
            this.addAllowed = false;
        }
        if ((sec = this.configExactMatchMap.get(path)) != null) {
            return new WsMappingResult(sec, Collections.EMPTY_MAP);
        }
        UriTemplate pathUriTemplate = null;
        try {
            pathUriTemplate = new UriTemplate(path);
        }
        catch (DeploymentException e) {
            return null;
        }
        Integer key = pathUriTemplate.getSegmentCount();
        SortedSet<TemplatePathMatch> templateMatches = this.configTemplateMatchMap.get(key);
        if (templateMatches == null) {
            return null;
        }
        Map<String, String> pathParams = null;
        for (TemplatePathMatch templateMatch : templateMatches) {
            pathParams = templateMatch.getUriTemplate().match(pathUriTemplate);
            if (pathParams == null) continue;
            sec = templateMatch.getConfig();
            break;
        }
        if (sec == null) {
            return null;
        }
        if (!PojoEndpointServer.class.isAssignableFrom(sec.getEndpointClass())) {
            sec.getUserProperties().put("org.apache.tomcat.websocket.pojo.PojoEndpoint.pathParams", pathParams);
        }
        return new WsMappingResult(sec, pathParams);
    }

    public boolean isEnforceNoAddAfterHandshake() {
        return this.enforceNoAddAfterHandshake;
    }

    public void setEnforceNoAddAfterHandshake(boolean enforceNoAddAfterHandshake) {
        this.enforceNoAddAfterHandshake = enforceNoAddAfterHandshake;
    }

    protected WsWriteTimeout getTimeout() {
        return this.wsWriteTimeout;
    }

    @Override
    protected void registerSession(Endpoint endpoint, WsSession wsSession) {
        super.registerSession(endpoint, wsSession);
        if (wsSession.getUserPrincipal() != null && wsSession.getHttpSessionId() != null) {
            this.registerAuthenticatedSession(wsSession, wsSession.getHttpSessionId());
        }
    }

    @Override
    protected void unregisterSession(Endpoint endpoint, WsSession wsSession) {
        if (wsSession.getUserPrincipal() != null && wsSession.getHttpSessionId() != null) {
            this.unregisterAuthenticatedSession(wsSession, wsSession.getHttpSessionId());
        }
        super.unregisterSession(endpoint, wsSession);
    }

    private void registerAuthenticatedSession(WsSession wsSession, String httpSessionId) {
        Set<WsSession> wsSessions = this.authenticatedSessions.get(httpSessionId);
        if (wsSessions == null) {
            wsSessions = Collections.newSetFromMap(new ConcurrentHashMap());
            this.authenticatedSessions.putIfAbsent(httpSessionId, wsSessions);
            wsSessions = this.authenticatedSessions.get(httpSessionId);
        }
        wsSessions.add(wsSession);
    }

    private void unregisterAuthenticatedSession(WsSession wsSession, String httpSessionId) {
        Set<WsSession> wsSessions = this.authenticatedSessions.get(httpSessionId);
        wsSessions.remove(wsSession);
    }

    public void closeAuthenticatedSession(String httpSessionId) {
        Set<WsSession> wsSessions = this.authenticatedSessions.remove(httpSessionId);
        if (wsSessions != null && !wsSessions.isEmpty()) {
            for (WsSession wsSession : wsSessions) {
                try {
                    wsSession.close(AUTHENTICATED_HTTP_SESSION_CLOSED);
                }
                catch (IOException e) {}
            }
        }
    }

    private static void validateEncoders(Class<? extends Encoder>[] encoders) throws DeploymentException {
        for (Class<? extends Encoder> encoder : encoders) {
            try {
                encoder.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DeploymentException(sm.getString("serverContainer.encoderFail", new Object[]{encoder.getName()}), (Throwable)e);
            }
        }
    }

    private static class TemplatePathMatchComparator
    implements Comparator<TemplatePathMatch> {
        private static final TemplatePathMatchComparator INSTANCE = new TemplatePathMatchComparator();

        public static TemplatePathMatchComparator getInstance() {
            return INSTANCE;
        }

        private TemplatePathMatchComparator() {
        }

        @Override
        public int compare(TemplatePathMatch tpm1, TemplatePathMatch tpm2) {
            return tpm1.getUriTemplate().getNormalizedPath().compareTo(tpm2.getUriTemplate().getNormalizedPath());
        }
    }

    private static class TemplatePathMatch {
        private final ServerEndpointConfig config;
        private final UriTemplate uriTemplate;

        public TemplatePathMatch(ServerEndpointConfig config, UriTemplate uriTemplate) {
            this.config = config;
            this.uriTemplate = uriTemplate;
        }

        public ServerEndpointConfig getConfig() {
            return this.config;
        }

        public UriTemplate getUriTemplate() {
            return this.uriTemplate;
        }
    }
}

