/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import javax.websocket.SendHandler;
import org.apache.tomcat.websocket.AsyncChannelWrapper;
import org.apache.tomcat.websocket.SendHandlerToCompletionHandler;
import org.apache.tomcat.websocket.WsRemoteEndpointImplBase;

public class WsRemoteEndpointImplClient
extends WsRemoteEndpointImplBase {
    private final AsyncChannelWrapper channel;

    public WsRemoteEndpointImplClient(AsyncChannelWrapper channel) {
        this.channel = channel;
    }

    @Override
    protected boolean isMasked() {
        return true;
    }

    @Override
    protected void doWrite(SendHandler handler, ByteBuffer ... data) {
        long timeout = this.getSendTimeout();
        if (timeout < 1L) {
            timeout = Long.MAX_VALUE;
        }
        SendHandlerToCompletionHandler sh2ch = new SendHandlerToCompletionHandler(handler);
        this.channel.write(data, 0, data.length, timeout, TimeUnit.MILLISECONDS, null, sh2ch);
    }

    @Override
    protected void doClose() {
        this.channel.close();
    }
}

