/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import javax.websocket.CloseReason;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.Utf8Decoder;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.Util;
import org.apache.tomcat.websocket.WrappedMessageHandler;
import org.apache.tomcat.websocket.WsIOException;
import org.apache.tomcat.websocket.WsPongMessage;
import org.apache.tomcat.websocket.WsSession;

public abstract class WsFrameBase {
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    protected final WsSession wsSession;
    protected final byte[] inputBuffer;
    private final ByteBuffer controlBufferBinary = ByteBuffer.allocate(125);
    private final CharBuffer controlBufferText = CharBuffer.allocate(125);
    private final CharsetDecoder utf8DecoderControl = new Utf8Decoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    private final CharsetDecoder utf8DecoderMessage = new Utf8Decoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    private boolean continuationExpected = false;
    private boolean textMessage = false;
    private ByteBuffer messageBufferBinary;
    private CharBuffer messageBufferText;
    private MessageHandler binaryMsgHandler = null;
    private MessageHandler textMsgHandler = null;
    private boolean fin = false;
    private int rsv = 0;
    private byte opCode = 0;
    private final byte[] mask = new byte[4];
    private int maskIndex = 0;
    private long payloadLength = 0L;
    private long payloadWritten = 0L;
    private State state = State.NEW_FRAME;
    private volatile boolean open = true;
    private int readPos = 0;
    protected int writePos = 0;

    public WsFrameBase(WsSession wsSession) {
        this.inputBuffer = new byte[8192];
        this.messageBufferBinary = ByteBuffer.allocate(wsSession.getMaxBinaryMessageBufferSize());
        this.messageBufferText = CharBuffer.allocate(wsSession.getMaxTextMessageBufferSize());
        this.wsSession = wsSession;
    }

    protected void processInputBuffer() throws IOException {
        do {
            this.wsSession.updateLastActive();
            if (this.state != State.NEW_FRAME) continue;
            if (this.processInitialHeader()) {
                if (this.open) continue;
                throw new IOException(sm.getString("wsFrame.closed"));
            }
            break;
        } while ((this.state != State.PARTIAL_HEADER || this.processRemainingHeader()) && (this.state != State.DATA || this.processData()));
    }

    private boolean processInitialHeader() throws IOException {
        byte b;
        if (this.writePos - this.readPos < 2) {
            return false;
        }
        this.fin = ((b = this.inputBuffer[this.readPos++]) & 0x80) > 0;
        this.rsv = (b & 0x70) >>> 4;
        if (this.rsv != 0) {
            throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.wrongRsv", new Object[]{this.rsv})));
        }
        this.opCode = (byte)(b & 0xF);
        if (Util.isControl(this.opCode)) {
            if (!this.fin) {
                throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.controlFragmented")));
            }
            if (this.opCode != 9 && this.opCode != 10 && this.opCode != 8) {
                throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.invalidOpCode", new Object[]{(int)this.opCode})));
            }
        } else {
            block16: {
                if (this.continuationExpected) {
                    if (this.opCode != 0) {
                        throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.noContinuation")));
                    }
                } else {
                    try {
                        if (this.opCode == 2) {
                            this.textMessage = false;
                            int size = this.wsSession.getMaxBinaryMessageBufferSize();
                            if (size != this.messageBufferBinary.capacity()) {
                                this.messageBufferBinary = ByteBuffer.allocate(size);
                            }
                            this.binaryMsgHandler = this.wsSession.getBinaryMessageHandler();
                            this.textMsgHandler = null;
                            break block16;
                        }
                        if (this.opCode == 1) {
                            this.textMessage = true;
                            int size = this.wsSession.getMaxTextMessageBufferSize();
                            if (size != this.messageBufferText.capacity()) {
                                this.messageBufferText = CharBuffer.allocate(size);
                            }
                            this.binaryMsgHandler = null;
                            this.textMsgHandler = this.wsSession.getTextMessageHandler();
                            break block16;
                        }
                        throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.invalidOpCode", new Object[]{(int)this.opCode})));
                    }
                    catch (IllegalStateException ise) {
                        throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.sessionClosed")));
                    }
                }
            }
            boolean bl = this.continuationExpected = !this.fin;
        }
        if (((b = this.inputBuffer[this.readPos++]) & 0x80) == 0 && this.isMasked()) {
            throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.notMasked")));
        }
        this.payloadLength = b & 0x7F;
        this.state = State.PARTIAL_HEADER;
        return true;
    }

    protected abstract boolean isMasked();

    private boolean processRemainingHeader() throws IOException {
        int headerLength = this.isMasked() ? 4 : 0;
        if (this.payloadLength == 126L) {
            headerLength += 2;
        } else if (this.payloadLength == 127L) {
            headerLength += 8;
        }
        if (this.writePos - this.readPos < headerLength) {
            return false;
        }
        if (this.payloadLength == 126L) {
            this.payloadLength = WsFrameBase.byteArrayToLong(this.inputBuffer, this.readPos, 2);
            this.readPos += 2;
        } else if (this.payloadLength == 127L) {
            this.payloadLength = WsFrameBase.byteArrayToLong(this.inputBuffer, this.readPos, 8);
            this.readPos += 8;
        }
        if (Util.isControl(this.opCode)) {
            if (this.payloadLength > 125L) {
                throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.controlPayloadTooBig", new Object[]{this.payloadLength})));
            }
            if (!this.fin) {
                throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.controlNoFin")));
            }
        }
        if (this.isMasked()) {
            System.arraycopy(this.inputBuffer, this.readPos, this.mask, 0, 4);
            this.readPos += 4;
        }
        this.state = State.DATA;
        return true;
    }

    private boolean processData() throws IOException {
        this.checkRoomPayload();
        if (Util.isControl(this.opCode)) {
            return this.processDataControl();
        }
        if (this.textMessage) {
            return this.processDataText();
        }
        return this.processDataBinary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processDataControl() throws IOException {
        if (!this.appendPayloadToMessage(this.controlBufferBinary)) {
            return false;
        }
        this.controlBufferBinary.flip();
        if (this.opCode == 8) {
            this.open = false;
            String reason = null;
            int code = CloseReason.CloseCodes.NORMAL_CLOSURE.getCode();
            if (this.controlBufferBinary.remaining() == 1) {
                this.controlBufferBinary.clear();
                throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.oneByteCloseCode")));
            }
            if (this.controlBufferBinary.remaining() > 1) {
                code = this.controlBufferBinary.getShort();
                if (this.controlBufferBinary.remaining() > 0) {
                    CoderResult cr = this.utf8DecoderControl.decode(this.controlBufferBinary, this.controlBufferText, true);
                    if (cr.isError()) {
                        this.controlBufferBinary.clear();
                        this.controlBufferText.clear();
                        throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.invalidUtf8Close")));
                    }
                    this.controlBufferText.flip();
                    reason = this.controlBufferText.toString();
                }
            }
            this.wsSession.onClose(new CloseReason(Util.getCloseCode(code), reason));
        } else if (this.opCode == 9) {
            if (this.wsSession.isOpen()) {
                this.wsSession.getBasicRemote().sendPong(this.controlBufferBinary);
            }
        } else if (this.opCode == 10) {
            MessageHandler.Whole<PongMessage> mhPong = this.wsSession.getPongMessageHandler();
            if (mhPong != null) {
                try {
                    mhPong.onMessage((Object)new WsPongMessage(this.controlBufferBinary));
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    this.wsSession.getLocal().onError((Session)this.wsSession, t);
                }
                finally {
                    this.controlBufferBinary.clear();
                }
            }
        } else {
            this.controlBufferBinary.clear();
            throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, sm.getString("wsFrame.invalidOpCode", new Object[]{(int)this.opCode})));
        }
        this.controlBufferBinary.clear();
        this.newFrame();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageText(boolean last) throws WsIOException {
        if (this.textMsgHandler != null) {
            long maxMessageSize;
            if (this.textMsgHandler instanceof WrappedMessageHandler && (maxMessageSize = ((WrappedMessageHandler)this.textMsgHandler).getMaxMessageSize()) > -1L && (long)this.messageBufferText.remaining() > maxMessageSize) {
                throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.TOO_BIG, sm.getString("wsFrame.messageTooBig", new Object[]{(long)this.messageBufferText.remaining(), maxMessageSize})));
            }
            try {
                if (this.textMsgHandler instanceof MessageHandler.Partial) {
                    ((MessageHandler.Partial)this.textMsgHandler).onMessage((Object)this.messageBufferText.toString(), last);
                } else {
                    ((MessageHandler.Whole)this.textMsgHandler).onMessage((Object)this.messageBufferText.toString());
                }
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                this.wsSession.getLocal().onError((Session)this.wsSession, t);
            }
            finally {
                this.messageBufferText.clear();
            }
        }
    }

    private boolean processDataText() throws IOException {
        while (!this.appendPayloadToMessage(this.messageBufferBinary)) {
            this.messageBufferBinary.flip();
            while (true) {
                CoderResult cr;
                if ((cr = this.utf8DecoderMessage.decode(this.messageBufferBinary, this.messageBufferText, false)).isError()) {
                    throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NOT_CONSISTENT, sm.getString("wsFrame.invalidUtf8")));
                }
                if (cr.isOverflow()) {
                    if (this.usePartial()) {
                        this.messageBufferText.flip();
                        this.sendMessageText(false);
                        this.messageBufferText.clear();
                        continue;
                    }
                    throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.TOO_BIG, sm.getString("wsFrame.textMessageTooBig")));
                }
                if (cr.isUnderflow()) break;
            }
            this.messageBufferBinary.compact();
            if (this.readPos != this.writePos) continue;
            return false;
        }
        this.messageBufferBinary.flip();
        boolean last = false;
        while (true) {
            CoderResult cr;
            if ((cr = this.utf8DecoderMessage.decode(this.messageBufferBinary, this.messageBufferText, last)).isError()) {
                throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NOT_CONSISTENT, sm.getString("wsFrame.invalidUtf8")));
            }
            if (cr.isOverflow()) {
                if (this.usePartial()) {
                    this.messageBufferText.flip();
                    this.sendMessageText(false);
                    this.messageBufferText.clear();
                    continue;
                }
                throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.TOO_BIG, sm.getString("wsFrame.textMessageTooBig")));
            }
            if (!(cr.isUnderflow() & !last)) break;
            if (this.continuationExpected) {
                if (this.usePartial()) {
                    this.messageBufferText.flip();
                    this.sendMessageText(false);
                    this.messageBufferText.clear();
                }
                this.messageBufferBinary.compact();
                this.newFrame();
                return true;
            }
            last = true;
        }
        this.messageBufferText.flip();
        this.sendMessageText(true);
        this.newMessage();
        return true;
    }

    private boolean processDataBinary() throws IOException {
        ByteBuffer copy;
        while (!this.appendPayloadToMessage(this.messageBufferBinary)) {
            if (this.readPos == this.writePos) {
                return false;
            }
            if (!this.usePartial()) {
                CloseReason cr = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.TOO_BIG, sm.getString("wsFrame.bufferTooSmall", new Object[]{this.messageBufferBinary.capacity(), this.payloadLength}));
                throw new WsIOException(cr);
            }
            this.messageBufferBinary.flip();
            copy = ByteBuffer.allocate(this.messageBufferBinary.limit());
            copy.put(this.messageBufferBinary);
            copy.flip();
            this.sendMessageBinary(copy, false);
            this.messageBufferBinary.clear();
        }
        if (this.usePartial() || !this.continuationExpected) {
            this.messageBufferBinary.flip();
            copy = ByteBuffer.allocate(this.messageBufferBinary.limit());
            copy.put(this.messageBufferBinary);
            copy.flip();
            this.sendMessageBinary(copy, !this.continuationExpected);
            this.messageBufferBinary.clear();
        }
        if (this.continuationExpected) {
            this.newFrame();
        } else {
            this.newMessage();
        }
        return true;
    }

    private void sendMessageBinary(ByteBuffer msg, boolean last) throws WsIOException {
        if (this.binaryMsgHandler != null) {
            long maxMessageSize;
            if (this.binaryMsgHandler instanceof WrappedMessageHandler && (maxMessageSize = ((WrappedMessageHandler)this.binaryMsgHandler).getMaxMessageSize()) > -1L && (long)msg.remaining() > maxMessageSize) {
                throw new WsIOException(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.TOO_BIG, sm.getString("wsFrame.messageTooBig", new Object[]{(long)msg.remaining(), maxMessageSize})));
            }
            try {
                if (this.binaryMsgHandler instanceof MessageHandler.Partial) {
                    ((MessageHandler.Partial)this.binaryMsgHandler).onMessage((Object)msg, last);
                } else {
                    ((MessageHandler.Whole)this.binaryMsgHandler).onMessage((Object)msg);
                }
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                this.wsSession.getLocal().onError((Session)this.wsSession, t);
            }
        }
    }

    private void newMessage() {
        this.messageBufferBinary.clear();
        this.messageBufferText.clear();
        this.utf8DecoderMessage.reset();
        this.continuationExpected = false;
        this.newFrame();
    }

    private void newFrame() {
        if (this.readPos == this.writePos) {
            this.readPos = 0;
            this.writePos = 0;
        }
        this.maskIndex = 0;
        this.payloadWritten = 0L;
        this.state = State.NEW_FRAME;
        this.checkRoomHeaders();
    }

    private void checkRoomHeaders() {
        if (this.inputBuffer.length - this.readPos < 131) {
            this.makeRoom();
        }
    }

    private void checkRoomPayload() {
        if ((long)(this.inputBuffer.length - this.readPos) - this.payloadLength + this.payloadWritten < 0L) {
            this.makeRoom();
        }
    }

    private void makeRoom() {
        System.arraycopy(this.inputBuffer, this.readPos, this.inputBuffer, 0, this.writePos - this.readPos);
        this.writePos -= this.readPos;
        this.readPos = 0;
    }

    private boolean usePartial() {
        if (Util.isControl(this.opCode)) {
            return false;
        }
        if (this.textMessage) {
            if (this.textMsgHandler != null) {
                return this.textMsgHandler instanceof MessageHandler.Partial;
            }
            return false;
        }
        if (this.binaryMsgHandler != null) {
            return this.binaryMsgHandler instanceof MessageHandler.Partial;
        }
        return false;
    }

    private boolean appendPayloadToMessage(ByteBuffer dest) {
        if (this.isMasked()) {
            while (this.payloadWritten < this.payloadLength && this.readPos < this.writePos && dest.hasRemaining()) {
                byte b = (byte)((this.inputBuffer[this.readPos] ^ this.mask[this.maskIndex]) & 0xFF);
                ++this.maskIndex;
                if (this.maskIndex == 4) {
                    this.maskIndex = 0;
                }
                ++this.readPos;
                ++this.payloadWritten;
                dest.put(b);
            }
            return this.payloadWritten == this.payloadLength;
        }
        long toWrite = Math.min(this.payloadLength - this.payloadWritten, (long)(this.writePos - this.readPos));
        toWrite = Math.min(toWrite, (long)dest.remaining());
        dest.put(this.inputBuffer, this.readPos, (int)toWrite);
        this.readPos = (int)((long)this.readPos + toWrite);
        this.payloadWritten += toWrite;
        return this.payloadWritten == this.payloadLength;
    }

    protected static long byteArrayToLong(byte[] b, int start, int len) throws IOException {
        if (len > 8) {
            throw new IOException(sm.getString("wsFrame.byteToLongFail", new Object[]{(long)len}));
        }
        int shift = 0;
        long result = 0L;
        for (int i = start + len - 1; i >= start; --i) {
            result += (long)((b[i] & 0xFF) << shift);
            shift += 8;
        }
        return result;
    }

    protected boolean isOpen() {
        return this.open;
    }

    private static enum State {
        NEW_FRAME,
        PARTIAL_HEADER,
        DATA;

    }
}

