/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import javax.servlet.ServletOutputStream;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.WsRemoteEndpointImplBase;
import org.apache.tomcat.websocket.server.Constants;
import org.apache.tomcat.websocket.server.WsHttpUpgradeHandler;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.apache.tomcat.websocket.server.WsWriteTimeout;

public class WsRemoteEndpointImplServer
extends WsRemoteEndpointImplBase {
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private static final Log log = LogFactory.getLog(WsHttpUpgradeHandler.class);
    private final ServletOutputStream sos;
    private final WsWriteTimeout wsWriteTimeout;
    private volatile SendHandler handler = null;
    private volatile ByteBuffer[] buffers = null;
    private volatile long timeoutExpiry = -1L;
    private volatile boolean close;

    public WsRemoteEndpointImplServer(ServletOutputStream sos, WsServerContainer serverContainer) {
        this.sos = sos;
        this.wsWriteTimeout = serverContainer.getTimeout();
    }

    @Override
    protected final boolean isMasked() {
        return false;
    }

    @Override
    protected void doWrite(SendHandler handler, ByteBuffer ... buffers) {
        this.handler = handler;
        this.buffers = buffers;
        this.onWritePossible();
    }

    public void onWritePossible() {
        long timeout;
        boolean complete = true;
        try {
            while (this.sos.isReady()) {
                complete = true;
                for (ByteBuffer buffer : this.buffers) {
                    if (!buffer.hasRemaining()) continue;
                    complete = false;
                    this.sos.write(buffer.array(), buffer.arrayOffset(), buffer.limit());
                    buffer.position(buffer.limit());
                    break;
                }
                if (!complete) continue;
                this.wsWriteTimeout.unregister(this);
                this.clearHandler(null);
                if (this.close) {
                    this.close();
                }
                break;
            }
        }
        catch (IOException ioe) {
            this.wsWriteTimeout.unregister(this);
            this.clearHandler(ioe);
            this.close();
        }
        if (!complete && (timeout = this.getSendTimeout()) > 0L) {
            this.timeoutExpiry = timeout + System.currentTimeMillis();
            this.wsWriteTimeout.register(this);
        }
    }

    @Override
    protected void doClose() {
        block3: {
            if (this.handler != null) {
                this.clearHandler(new EOFException());
            }
            try {
                this.sos.close();
            }
            catch (IOException e) {
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)sm.getString("wsRemoteEndpointServer.closeFailed"), (Throwable)e);
            }
        }
        this.wsWriteTimeout.unregister(this);
    }

    protected long getTimeoutExpiry() {
        return this.timeoutExpiry;
    }

    protected void onTimeout() {
        if (this.handler != null) {
            this.clearHandler(new SocketTimeoutException());
        }
        this.close();
    }

    private void clearHandler(Throwable t) {
        SendHandler sh = this.handler;
        this.handler = null;
        if (sh != null) {
            if (t == null) {
                sh.onResult(new SendResult());
            } else {
                sh.onResult(new SendResult(t));
            }
        }
    }
}

