/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.websocket.Extension;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.MessagePart;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.TransformationResult;
import org.apache.tomcat.websocket.Util;
import org.apache.tomcat.websocket.WsExtension;
import org.apache.tomcat.websocket.WsExtensionParameter;

public class PerMessageDeflate
implements Transformation {
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private static final String SERVER_NO_CONTEXT_TAKEOVER = "server_no_context_takeover";
    private static final String CLIENT_NO_CONTEXT_TAKEOVER = "client_no_context_takeover";
    private static final String SERVER_MAX_WINDOW_BITS = "server_max_window_bits";
    private static final String CLIENT_MAX_WINDOW_BITS = "client_max_window_bits";
    private static final int RSV_BITMASK = 4;
    private static final byte[] EOM_BYTES = new byte[]{0, 0, -1, -1};
    public static final String NAME = "permessage-deflate";
    private final boolean serverContextTakeover;
    private final int serverMaxWindowBits;
    private final boolean clientContextTakeover;
    private final int clientMaxWindowBits;
    private final Inflater inflator = new Inflater(true);
    private final ByteBuffer readBuffer = ByteBuffer.allocate(8192);
    private Transformation next;
    private boolean skipDecompression = false;

    static PerMessageDeflate negotiate(List<List<Extension.Parameter>> preferences) {
        for (List<Extension.Parameter> preference : preferences) {
            boolean ok = true;
            boolean serverContextTakeover = true;
            int serverMaxWindowBits = -1;
            boolean clientContextTakeover = true;
            int clientMaxWindowBits = -1;
            for (Extension.Parameter param : preference) {
                if (SERVER_NO_CONTEXT_TAKEOVER.equals(param.getName())) {
                    if (serverContextTakeover) {
                        serverContextTakeover = false;
                        continue;
                    }
                    throw new IllegalArgumentException(sm.getString("perMessageDeflate.duplicateParameter", new Object[]{SERVER_NO_CONTEXT_TAKEOVER}));
                }
                if (CLIENT_NO_CONTEXT_TAKEOVER.equals(param.getName())) {
                    if (clientContextTakeover) {
                        clientContextTakeover = false;
                        continue;
                    }
                    throw new IllegalArgumentException(sm.getString("perMessageDeflate.duplicateParameter", new Object[]{CLIENT_NO_CONTEXT_TAKEOVER}));
                }
                if (SERVER_MAX_WINDOW_BITS.equals(param.getName())) {
                    if (serverMaxWindowBits == -1) {
                        serverMaxWindowBits = Integer.parseInt(param.getValue());
                        if (serverMaxWindowBits < 8 || serverMaxWindowBits > 15) {
                            throw new IllegalArgumentException(sm.getString("perMessageDeflate.invalidWindowSize", new Object[]{SERVER_MAX_WINDOW_BITS, serverMaxWindowBits}));
                        }
                        if (serverMaxWindowBits == 15) continue;
                        ok = false;
                        break;
                    }
                    throw new IllegalArgumentException(sm.getString("perMessageDeflate.duplicateParameter", new Object[]{SERVER_MAX_WINDOW_BITS}));
                }
                if (CLIENT_MAX_WINDOW_BITS.equals(param.getName())) {
                    if (clientMaxWindowBits == -1) {
                        if (param.getValue() == null) {
                            clientMaxWindowBits = 15;
                            continue;
                        }
                        clientMaxWindowBits = Integer.parseInt(param.getValue());
                        if (clientMaxWindowBits >= 8 && clientMaxWindowBits <= 15) continue;
                        throw new IllegalArgumentException(sm.getString("perMessageDeflate.invalidWindowSize", new Object[]{CLIENT_MAX_WINDOW_BITS, clientMaxWindowBits}));
                    }
                    throw new IllegalArgumentException(sm.getString("perMessageDeflate.duplicateParameter", new Object[]{CLIENT_MAX_WINDOW_BITS}));
                }
                throw new IllegalArgumentException(sm.getString("perMessageDeflate.unknownParameter", new Object[]{param.getName()}));
            }
            if (!ok) continue;
            return new PerMessageDeflate(serverContextTakeover, serverMaxWindowBits, clientContextTakeover, clientMaxWindowBits);
        }
        return null;
    }

    private PerMessageDeflate(boolean serverContextTakeover, int serverMaxWindowBits, boolean clientContextTakeover, int clientMaxWindowBits) {
        this.serverContextTakeover = serverContextTakeover;
        this.serverMaxWindowBits = serverMaxWindowBits;
        this.clientContextTakeover = clientContextTakeover;
        this.clientMaxWindowBits = clientMaxWindowBits;
    }

    @Override
    public TransformationResult getMoreData(byte opCode, boolean fin, int rsv, ByteBuffer dest) throws IOException {
        if (Util.isControl(opCode)) {
            return this.next.getMoreData(opCode, fin, rsv, dest);
        }
        if (!Util.isContinuation(opCode)) {
            boolean bl = this.skipDecompression = (rsv & 4) == 0;
        }
        if (this.skipDecompression) {
            return this.next.getMoreData(opCode, fin, rsv, dest);
        }
        boolean usedEomBytes = false;
        while (dest.remaining() > 0) {
            int written;
            try {
                written = this.inflator.inflate(dest.array(), dest.arrayOffset() + dest.position(), dest.remaining());
            }
            catch (DataFormatException e) {
                throw new IOException(sm.getString("perMessageDeflate.deflateFailed"), e);
            }
            dest.position(dest.position() + written);
            if (this.inflator.needsInput() && !usedEomBytes) {
                if (!dest.hasRemaining()) continue;
                this.readBuffer.clear();
                TransformationResult nextResult = this.next.getMoreData(opCode, fin, rsv ^ 4, this.readBuffer);
                this.inflator.setInput(this.readBuffer.array(), this.readBuffer.arrayOffset(), this.readBuffer.position());
                if (TransformationResult.UNDERFLOW.equals((Object)nextResult)) {
                    return nextResult;
                }
                if (!TransformationResult.END_OF_FRAME.equals((Object)nextResult) || this.readBuffer.position() != 0) continue;
                if (fin) {
                    this.inflator.setInput(EOM_BYTES);
                    usedEomBytes = true;
                    continue;
                }
                return TransformationResult.END_OF_FRAME;
            }
            if (written != 0) continue;
            return TransformationResult.END_OF_FRAME;
        }
        return TransformationResult.OVERFLOW;
    }

    @Override
    public boolean validateRsv(int rsv, byte opCode) {
        if (Util.isControl(opCode)) {
            if ((rsv & 4) > 0) {
                return false;
            }
            if (this.next == null) {
                return true;
            }
            return this.next.validateRsv(rsv, opCode);
        }
        int rsvNext = rsv;
        if ((rsv & 4) > 0) {
            rsvNext = rsv ^ 4;
        }
        if (this.next == null) {
            return true;
        }
        return this.next.validateRsv(rsvNext, opCode);
    }

    @Override
    public Extension getExtensionResponse() {
        WsExtension result = new WsExtension(NAME);
        List params = result.getParameters();
        if (!this.serverContextTakeover) {
            params.add(new WsExtensionParameter(SERVER_NO_CONTEXT_TAKEOVER, null));
        }
        if (this.serverMaxWindowBits != -1) {
            params.add(new WsExtensionParameter(SERVER_MAX_WINDOW_BITS, Integer.toString(this.serverMaxWindowBits)));
        }
        if (!this.clientContextTakeover) {
            params.add(new WsExtensionParameter(CLIENT_NO_CONTEXT_TAKEOVER, null));
        }
        if (this.clientMaxWindowBits != -1) {
            params.add(new WsExtensionParameter(CLIENT_MAX_WINDOW_BITS, Integer.toString(this.clientMaxWindowBits)));
        }
        return result;
    }

    @Override
    public void setNext(Transformation t) {
        if (this.next == null) {
            this.next = t;
        } else {
            this.next.setNext(t);
        }
    }

    @Override
    public boolean validateRsvBits(int i) {
        if ((i & 4) > 0) {
            return false;
        }
        if (this.next == null) {
            return true;
        }
        return this.next.validateRsvBits(i | 4);
    }

    @Override
    public List<MessagePart> sendMessagePart(List<MessagePart> messageParts) {
        if (this.next == null) {
            return messageParts;
        }
        return this.next.sendMessagePart(messageParts);
    }
}

