/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import org.apache.activemq.MaxFrameSizeExceededException;

public final class JMSExceptionSupport {
    private JMSExceptionSupport() {
    }

    public static JMSException create(String msg, Throwable cause) {
        JMSException exception = new JMSException(msg);
        exception.initCause(cause);
        return exception;
    }

    public static JMSException create(String msg, Exception cause) {
        JMSException exception = new JMSException(msg);
        exception.setLinkedException(cause);
        exception.initCause((Throwable)cause);
        return exception;
    }

    public static JMSException create(Throwable cause) {
        if (cause instanceof JMSException) {
            return (JMSException)cause;
        }
        String msg = cause.getMessage();
        if (msg == null || msg.length() == 0) {
            msg = cause.toString();
        }
        Object exception = cause instanceof SecurityException ? new JMSSecurityException(msg) : new JMSException(msg);
        exception.initCause(cause);
        return exception;
    }

    public static JMSException create(Exception cause) {
        if (cause instanceof JMSException) {
            return (JMSException)((Object)cause);
        }
        if (cause instanceof MaxFrameSizeExceededException) {
            JMSException jmsException = new JMSException(cause.getMessage(), "41300");
            jmsException.setLinkedException(cause);
            jmsException.initCause((Throwable)cause);
            return jmsException;
        }
        String msg = cause.getMessage();
        if (msg == null || msg.length() == 0) {
            msg = cause.toString();
        }
        Object exception = cause instanceof SecurityException ? new JMSSecurityException(msg) : new JMSException(msg);
        exception.setLinkedException(cause);
        exception.initCause((Throwable)cause);
        return exception;
    }

    public static MessageEOFException createMessageEOFException(Exception cause) {
        String msg = cause.getMessage();
        if (msg == null || msg.length() == 0) {
            msg = cause.toString();
        }
        MessageEOFException exception = new MessageEOFException(msg);
        exception.setLinkedException(cause);
        exception.initCause((Throwable)cause);
        return exception;
    }

    public static MessageFormatException createMessageFormatException(Exception cause) {
        String msg = cause.getMessage();
        if (msg == null || msg.length() == 0) {
            msg = cause.toString();
        }
        MessageFormatException exception = new MessageFormatException(msg);
        exception.setLinkedException(cause);
        exception.initCause((Throwable)cause);
        return exception;
    }
}

