/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.container.spi.event.container.AfterDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeUnDeploy;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;

public class TestObserver {
    @Inject
    private Instance<ClassLoaders> classLoader;
    @Inject
    private Instance<TestClass> testClass;
    @Inject
    @DeploymentScoped
    private InstanceProducer<DeploymentContext> contextProducer;
    @Inject
    private Instance<DeploymentContext> context;

    public void observesDeploy(@Observes AfterDeploy afterDeployment) {
        String name;
        this.contextProducer.set((Object)new DeploymentContext(Thread.currentThread().getContextClassLoader()));
        ClassLoaders loader = (ClassLoaders)this.classLoader.get();
        String string = name = afterDeployment.getDeployment().getArchive() != null ? afterDeployment.getDeployment().getArchive().getName() : null;
        if (loader != null && loader.classloaders.containsKey(name)) {
            this.setTCCL((ClassLoader)loader.classloaders.get(name));
        }
    }

    public void observesUndeploy(@Observes BeforeUnDeploy beforeUnDeploy) {
        ClassLoaders loader = (ClassLoaders)this.classLoader.get();
        if (loader != null) {
            this.setTCCL(loader.original);
        } else {
            DeploymentContext deploymentContext = (DeploymentContext)this.context.get();
            if (deploymentContext != null) {
                this.setTCCL(deploymentContext.loader);
            }
        }
    }

    public void observesTest(@Observes EventContext<TestEvent> event) {
        this.switchLoader(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchLoader(EventContext<?> event) {
        if (!SystemInstance.isInitialized()) {
            event.proceed();
            return;
        }
        BeanContext context = this.beanContext();
        ThreadContext oldCtx = null;
        ClassLoader oldCl = null;
        if (context != null) {
            oldCtx = ThreadContext.enter((ThreadContext)new ThreadContext(context, null));
        } else {
            oldCl = Thread.currentThread().getContextClassLoader();
            ClassLoaders classLoaders = (ClassLoaders)this.classLoader.get();
            if (classLoaders != null) {
                ClassLoader loader = classLoaders.classloaders.size() == 1 ? (ClassLoader)classLoaders.classloaders.values().iterator().next() : oldCl;
                this.setTCCL(loader);
            }
        }
        try {
            event.proceed();
        }
        finally {
            if (context != null) {
                ThreadContext.exit((ThreadContext)oldCtx);
            } else {
                this.setTCCL(oldCl);
            }
        }
    }

    private void setTCCL(ClassLoader cl) {
        Thread.currentThread().setContextClassLoader(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(@Observes EventContext<BeforeUnDeploy> event) {
        if (!SystemInstance.isInitialized()) {
            event.proceed();
            return;
        }
        try {
            event.proceed();
        }
        finally {
            CreationalContext cc;
            BeanContext bc = this.beanContext();
            if (bc != null && (cc = (CreationalContext)bc.get(CreationalContext.class)) != null) {
                cc.release();
            }
        }
    }

    private BeanContext beanContext() {
        TestClass tc = (TestClass)this.testClass.get();
        if (tc == null) {
            return null;
        }
        String className = tc.getName();
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        for (AppContext app : containerSystem.getAppContexts()) {
            BeanContext context = containerSystem.getBeanContext((Object)(app.getId() + "_" + className));
            if (context == null) continue;
            return context;
        }
        return null;
    }

    public static class DeploymentContext {
        private final ClassLoader loader;

        public DeploymentContext(ClassLoader loader) {
            this.loader = loader;
        }
    }

    public static class ClassLoaders {
        private final ClassLoader original = Thread.currentThread().getContextClassLoader();
        private final Map<String, ClassLoader> classloaders = new HashMap<String, ClassLoader>();

        public void register(String name, ClassLoader loader) {
            this.classloaders.put(name, loader);
        }

        public void unregister(String name) {
            this.classloaders.remove(name);
        }
    }
}

