/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.openejb;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ModuleTestContext;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.arquillian.common.ArquillianUtil;
import org.apache.openejb.arquillian.common.TestObserver;
import org.apache.openejb.arquillian.openejb.Closeables;
import org.apache.openejb.arquillian.openejb.OpenEJBArchiveProcessor;
import org.apache.openejb.arquillian.openejb.OpenEJBConfiguration;
import org.apache.openejb.arquillian.openejb.server.ServiceManagers;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.ClassListInfo;
import org.apache.openejb.assembler.classic.OpenEjbConfigurationFactory;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.cdi.ScopeHelper;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.core.LocalInitialContext;
import org.apache.openejb.core.LocalInitialContextFactory;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.session.SessionManager;
import org.apache.openejb.web.LightweightWebAppBuilder;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.web.lifecycle.test.MockHttpSession;
import org.apache.webbeans.web.lifecycle.test.MockServletContext;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class OpenEJBDeployableContainer
implements DeployableContainer<OpenEJBConfiguration> {
    private static final Properties PROPERTIES = new Properties();
    private static final ConcurrentMap<String, DeploymentInfo> DEPLOYMENT_INFO;
    public static final AppContext NO_APP_CTX;
    private Properties properties;
    private Assembler assembler;
    private InitialContext initialContext;
    private ConfigurationFactory configurationFactory;
    private Collection<Archive<?>> containerArchives;
    @Inject
    @DeploymentScoped
    private InstanceProducer<AppInfo> appInfoProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<AppContext> appContextProducer;
    @Inject
    @SuiteScoped
    private InstanceProducer<Context> contextProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<ServletContext> servletContextProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<HttpSession> sessionProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<Closeables> closeablesProducer;
    @Inject
    @SuiteScoped
    private InstanceProducer<TestObserver.ClassLoaders> classLoader;
    @Inject
    private Instance<Closeables> closeables;
    @Inject
    private Instance<ServletContext> servletContext;
    @Inject
    private Instance<HttpSession> session;
    @Inject
    private Instance<AppInfo> info;
    @Inject
    private Instance<AppContext> appContext;
    @Inject
    private Instance<TestClass> testClass;
    private OpenEJBConfiguration configuration;

    public Class<OpenEJBConfiguration> getConfigurationClass() {
        return OpenEJBConfiguration.class;
    }

    public void setup(OpenEJBConfiguration openEJBConfiguration) {
        this.properties = new Properties();
        this.configuration = openEJBConfiguration;
        ByteArrayInputStream bais = new ByteArrayInputStream(openEJBConfiguration.getProperties().getBytes());
        try {
            this.properties.load(bais);
        }
        catch (IOException e) {
            throw new OpenEJBRuntimeException((Exception)e);
        }
        finally {
            IO.close((Closeable)bais);
        }
        for (Map.Entry<Object, Object> defaultKey : PROPERTIES.entrySet()) {
            String key = defaultKey.getKey().toString();
            if (this.properties.containsKey(key)) continue;
            this.properties.setProperty(key, defaultKey.getValue().toString());
        }
        ArquillianUtil.preLoadClassesAsynchronously((String)openEJBConfiguration.getPreloadClasses());
    }

    public void start() throws LifecycleException {
        try {
            this.initialContext = new InitialContext(this.properties);
        }
        catch (NamingException e) {
            throw new LifecycleException("can't start the OpenEJB container", (Throwable)e);
        }
        this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        this.configurationFactory = (ConfigurationFactory)SystemInstance.get().getComponent(OpenEjbConfigurationFactory.class);
        if ("true".equalsIgnoreCase(PROPERTIES.getProperty("openejb.embedded.remotable")) && SystemInstance.get().getComponent(WebAppBuilder.class) == null) {
            SystemInstance.get().setComponent(WebAppBuilder.class, (Object)new LightweightWebAppBuilder());
        }
        this.contextProducer.set((Object)this.initialContext);
        this.containerArchives = ArquillianUtil.toDeploy((Properties)this.properties);
        Closeables globalScopeCloseables = new Closeables();
        SystemInstance.get().setComponent(Closeables.class, (Object)globalScopeCloseables);
        for (Archive<?> archive : this.containerArchives) {
            try {
                this.quickDeploy(archive, (TestClass)this.testClass.get(), globalScopeCloseables);
            }
            catch (DeploymentException e) {
                Logger.getLogger(OpenEJBDeployableContainer.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        DeploymentInfo info;
        try {
            List beanContexts;
            Closeables cl = new Closeables();
            this.closeablesProducer.set((Object)cl);
            info = this.quickDeploy(archive, (TestClass)this.testClass.get(), cl);
            if (archive.getName().endsWith(".war") && (beanContexts = info.appCtx.getBeanContexts()).size() > 1) {
                block2: for (BeanContext next : beanContexts) {
                    if (!ModuleTestContext.class.isInstance(next.getModuleContext()) || BeanContext.Comp.class == next.getBeanClass()) continue;
                    for (BeanContext b : beanContexts) {
                        if (b.getModuleContext() == next.getModuleContext()) continue;
                        ((ModuleTestContext)ModuleTestContext.class.cast(next.getModuleContext())).setModuleJndiContextOverride(b.getModuleContext().getModuleJndiContext());
                        break block2;
                    }
                }
            }
            this.servletContextProducer.set((Object)info.appServletContext);
            this.sessionProducer.set((Object)info.appSession);
            this.appInfoProducer.set((Object)info.appInfo);
            this.appContextProducer.set((Object)info.appCtx);
            ClassLoader loader = info.appCtx.getWebContexts().isEmpty() ? info.appCtx.getClassLoader() : ((WebContext)info.appCtx.getWebContexts().iterator().next()).getClassLoader();
            ClassLoader classLoader = loader == null ? info.appCtx.getClassLoader() : loader;
            TestObserver.ClassLoaders classLoaders = (TestObserver.ClassLoaders)this.classLoader.get();
            if (classLoaders == null) {
                classLoaders = new TestObserver.ClassLoaders();
                this.classLoader.set((Object)classLoaders);
            }
            classLoaders.register(archive.getName(), classLoader);
        }
        catch (Exception e) {
            throw new DeploymentException("can't deploy " + archive.getName(), (Throwable)e);
        }
        if (PROPERTIES.containsKey("openejb.embedded.remotable")) {
            ProtocolMetaData metaData = ServiceManagers.protocolMetaData((AppInfo)this.appInfoProducer.get());
            HTTPContext http = null;
            for (WebAppInfo webapp : info.appInfo.webApps) {
                for (ServletInfo servletInfo : webapp.servlets) {
                    if (http != null) continue;
                    http = (HTTPContext)HTTPContext.class.cast(metaData.getContexts().iterator().next());
                    http.add(new Servlet(servletInfo.servletName, webapp.contextRoot));
                }
                for (ClassListInfo classListInfo : webapp.webAnnotatedClasses) {
                    for (String path : classListInfo.list) {
                        if (!path.contains("!")) continue;
                        if (http == null) {
                            http = (HTTPContext)HTTPContext.class.cast(metaData.getContexts().iterator().next());
                        }
                        http.add(new Servlet(path.substring(path.lastIndexOf(33) + 2).replace(".class", "").replace("/", "."), webapp.contextRoot));
                    }
                }
            }
            if (metaData != null) {
                return metaData;
            }
        }
        return new ProtocolMetaData();
    }

    private DeploymentInfo quickDeploy(Archive<?> archive, TestClass testClass, Closeables cls) throws DeploymentException {
        String name = archive.getName();
        DeploymentInfo info = (DeploymentInfo)DEPLOYMENT_INFO.get(name);
        if (info == null) {
            try {
                boolean isEmbeddedWebAppBuilder;
                AppModule module = OpenEJBArchiveProcessor.createModule(archive, testClass, cls);
                AppInfo appInfo = this.configurationFactory.configureApplication(module);
                WebAppBuilder webAppBuilder = (WebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
                boolean bl = isEmbeddedWebAppBuilder = webAppBuilder != null && LightweightWebAppBuilder.class.isInstance(webAppBuilder);
                if (isEmbeddedWebAppBuilder) {
                    final LightweightWebAppBuilder lightweightWebAppBuilder = (LightweightWebAppBuilder)LightweightWebAppBuilder.class.cast(webAppBuilder);
                    for (WebModule w : module.getWebModules()) {
                        final String moduleId = w.getModuleId();
                        lightweightWebAppBuilder.setClassLoader(moduleId, w.getClassLoader());
                        cls.add(new Closeable(){

                            @Override
                            public void close() throws IOException {
                                lightweightWebAppBuilder.removeClassLoader(moduleId);
                            }
                        });
                    }
                }
                final AppContext appCtx = this.assembler.createApplication(appInfo, module.getClassLoader());
                if (isEmbeddedWebAppBuilder && PROPERTIES.containsKey("openejb.embedded.remotable") && !appCtx.getWebContexts().isEmpty()) {
                    cls.add(new Closeable(){

                        @Override
                        public void close() throws IOException {
                            try {
                                SessionManager sessionManager = (SessionManager)SystemInstance.get().getComponent(SessionManager.class);
                                if (sessionManager != null) {
                                    for (WebContext web : appCtx.getWebContexts()) {
                                        sessionManager.destroy(web);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
                MockServletContext appServletContext = new MockServletContext();
                MockHttpSession appSession = new MockHttpSession();
                if (this.configuration.isStartDefaultScopes() && appCtx.getWebBeansContext() != null) {
                    ScopeHelper.startContexts((ContextsService)appCtx.getWebBeansContext().getContextsService(), (ServletContext)appServletContext, (HttpSession)appSession);
                }
                info = new DeploymentInfo((ServletContext)appServletContext, (HttpSession)appSession, appInfo, appCtx);
                if (this.configuration.isSingleDeploymentByArchiveName(name)) {
                    DEPLOYMENT_INFO.putIfAbsent(name, info);
                }
            }
            catch (Exception e) {
                throw new DeploymentException("can't deploy " + name, (Throwable)e);
            }
        }
        return info;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        AppContext ctx;
        TestObserver.ClassLoaders classLoaders;
        Closeables cl = (Closeables)this.closeables.get();
        if (cl != null) {
            try {
                cl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((classLoaders = (TestObserver.ClassLoaders)this.classLoader.get()) != null) {
            classLoaders.unregister(archive.getName());
        }
        if ((ctx = (AppContext)this.appContext.get()) == null) {
            return;
        }
        this.appContextProducer.set((Object)NO_APP_CTX);
        try {
            if (!this.configuration.isSingleDeploymentByArchiveName(archive.getName())) {
                this.assembler.destroyApplication(((AppInfo)this.info.get()).path);
            }
            if (this.configuration.isStartDefaultScopes() && ctx.getWebBeansContext() != null) {
                ScopeHelper.stopContexts((ContextsService)ctx.getWebBeansContext().getContextsService(), (ServletContext)((ServletContext)this.servletContext.get()), (HttpSession)((HttpSession)this.session.get()));
            }
        }
        catch (Exception e) {
            throw new DeploymentException("can't undeploy " + archive.getName(), (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        ArquillianUtil.undeploy((DeployableContainer)this, this.containerArchives);
        try {
            Closeables closeables;
            if (this.initialContext != null) {
                this.initialContext.close();
            }
            if ((closeables = (Closeables)SystemInstance.get().getComponent(Closeables.class)) != null) {
                closeables.close();
            }
        }
        catch (NamingException e) {
            throw new LifecycleException("can't close the OpenEJB container", (Throwable)e);
        }
        catch (IOException iOException) {
        }
        finally {
            OpenEJB.destroy();
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    static {
        PROPERTIES.setProperty("java.naming.factory.initial", LocalInitialContextFactory.class.getName());
        PROPERTIES.setProperty("openejb.embedded.initialcontext.close", LocalInitialContext.Close.DESTROY.name());
        PROPERTIES.setProperty("openejb.deployments.classpath", "false");
        try {
            OpenEJBDeployableContainer.class.getClassLoader().loadClass("org.apache.openejb.server.ServiceManager");
            PROPERTIES.setProperty("openejb.embedded.remotable", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEPLOYMENT_INFO = new ConcurrentHashMap<String, DeploymentInfo>();
        NO_APP_CTX = new AppContext(null, SystemInstance.get(), null, null, null, false);
    }

    private static final class DeploymentInfo {
        public final ServletContext appServletContext;
        public final HttpSession appSession;
        public final AppInfo appInfo;
        public final AppContext appCtx;

        private DeploymentInfo(ServletContext appServletContext, HttpSession appSession, AppInfo appInfo, AppContext appCtx) {
            this.appServletContext = appServletContext;
            this.appSession = appSession;
            this.appInfo = appInfo;
            this.appCtx = appCtx;
        }
    }
}

