/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.openejb.cucumber;

import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceIteratorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.openejb.arquillian.openejb.SWClassLoader;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Node;

public class ArchiveResourceIteratorFactory
implements ResourceIteratorFactory {
    public boolean isFactoryFor(URL url) {
        return url.getProtocol().startsWith("archive");
    }

    public Iterator<Resource> createIterator(URL url, String path, String suffix) {
        return this.findResources(path, suffix).iterator();
    }

    private Collection<Resource> findResources(final String path, final String suffix) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (SWClassLoader.class.isInstance(loader)) {
            Collection<Archive<?>> archives = ((SWClassLoader)SWClassLoader.class.cast(loader)).getArchives();
            final ClassLoader parent = loader.getParent();
            for (Archive<?> archive : archives) {
                Map content = archive.getContent((Filter)new Filter<ArchivePath>(){

                    public boolean include(ArchivePath object) {
                        String currentPath = ArchiveResourceIteratorFactory.classloaderPath(object);
                        return (parent == null || parent.getResource(currentPath) == null) && currentPath.startsWith('/' + path) && currentPath.endsWith(suffix);
                    }
                });
                for (Map.Entry entry : content.entrySet()) {
                    resources.add(new SWResource((ArchivePath)entry.getKey(), (Node)entry.getValue()));
                }
            }
        }
        return resources;
    }

    private static String classloaderPath(ArchivePath key) {
        return key.get().replace("/WEB-INF/classes/", "");
    }

    private static class SWResource
    implements Resource {
        private final Node node;
        private final String path;

        public SWResource(ArchivePath key, Node value) {
            this.path = ArchiveResourceIteratorFactory.classloaderPath(key);
            this.node = value;
        }

        public String getPath() {
            return this.path;
        }

        public String getAbsolutePath() {
            return this.path;
        }

        public InputStream getInputStream() throws IOException {
            return this.node.getAsset().openStream();
        }

        public String getClassName(String extension) {
            return this.path.replace('/', '.') + extension;
        }
    }
}

