/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.transaction;

import jakarta.transaction.TransactionManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBRuntimeException;
import org.jboss.arquillian.transaction.spi.provider.TransactionProvider;
import org.jboss.arquillian.transaction.spi.test.TransactionalTest;

public class OpenEJBTransactionProvider
implements TransactionProvider {
    public void beginTransaction(TransactionalTest test) {
        try {
            OpenEJBTransactionProvider.lookup(test.getManager()).begin();
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
    }

    public void commitTransaction(TransactionalTest test) {
        try {
            OpenEJBTransactionProvider.lookup(test.getManager()).commit();
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
    }

    public void rollbackTransaction(TransactionalTest test) {
        try {
            OpenEJBTransactionProvider.lookup(test.getManager()).rollback();
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
    }

    private static TransactionManager lookup(String manager) throws NamingException {
        if (OpenEJBTransactionProvider.builtIn(manager)) {
            return OpenEJB.getTransactionManager();
        }
        return (TransactionManager)new InitialContext().lookup(manager);
    }

    private static boolean builtIn(String manager) {
        return manager == null || manager.isEmpty() || "openejb".equalsIgnoreCase(manager) || "tomee".equalsIgnoreCase(manager);
    }
}

