/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.arquillian.common.IO;
import org.apache.openejb.arquillian.common.ObjectMap;
import org.apache.openejb.arquillian.common.TomEEContainer;

public class ConfigurationOverrides {
    protected static final Logger LOGGER = Logger.getLogger(TomEEContainer.class.getName());

    public static List<URL> apply(Object configuration, Properties systemProperties, String ... prefixes) {
        List<URL> overridePropFiles;
        List<URL> propertiesFiles = ConfigurationOverrides.findPropertiesFiles("default.arquillian-%s.properties", prefixes);
        if (!propertiesFiles.isEmpty()) {
            ConfigurationOverrides.apply(configuration, systemProperties, propertiesFiles, false, prefixes);
        }
        if (!(overridePropFiles = ConfigurationOverrides.findPropertiesFiles("arquillian-%s.properties", prefixes)).isEmpty()) {
            ConfigurationOverrides.apply(configuration, systemProperties, overridePropFiles, true, prefixes);
        }
        propertiesFiles.addAll(overridePropFiles);
        ConfigurationOverrides.apply(configuration, systemProperties, Collections.emptyList(), true, prefixes);
        return propertiesFiles;
    }

    public static void apply(Object configuration, Properties systemProperties, List<URL> urls, boolean overrideNotNull, String ... prefixes) {
        List<Properties> propertiesList = ConfigurationOverrides.read(urls);
        Properties defaults = new Properties();
        for (Properties p : propertiesList) {
            defaults.putAll((Map<?, ?>)p);
        }
        ObjectMap map = new ObjectMap(configuration);
        for (Map.Entry<Object, Object> entry : defaults.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            ConfigurationOverrides.setProperty(map, key, key, value, Level.FINE, overrideNotNull);
        }
        for (String key : map.keySet()) {
            for (String prefix : prefixes) {
                String property = prefix + "." + key;
                String value = systemProperties.getProperty(property);
                ConfigurationOverrides.setProperty(map, key, property, value, Level.INFO, true);
            }
        }
    }

    private static List<Properties> read(List<URL> urls) {
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        for (URL url : urls) {
            try {
                propertiesList.add(IO.readProperties(url));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Cannot read : " + String.valueOf(url), e);
            }
        }
        return propertiesList;
    }

    public static List<URL> findPropertiesFiles(String name, String ... prefixes) {
        ArrayList<URL> urls = new ArrayList<URL>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (String prefix : prefixes) {
            String resourceName = String.format(name, prefix.replace('.', '-'));
            ConfigurationOverrides.addResources(urls, loader, resourceName);
        }
        return urls;
    }

    private static void addResources(List<URL> urls, ClassLoader loader, String resourceName) {
        try {
            Enumeration<URL> resources = loader.getResources(resourceName);
            while (resources.hasMoreElements()) {
                urls.add(resources.nextElement());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed getResources: " + resourceName, e);
        }
    }

    private static void setProperty(ObjectMap map, String key, String property, String value, Level info, boolean overrideNotNull) {
        if (value == null) {
            LOGGER.log(Level.FINE, String.format("Unset '%s'", property));
            return;
        }
        if (!overrideNotNull && !ConfigurationOverrides.isNull(map.get(key))) {
            LOGGER.log(Level.FINE, String.format("Unset '%s' because already set", property));
            return;
        }
        try {
            LOGGER.log(info, String.format("Applying override '%s=%s'", property, value));
            map.put(key, (Object)value);
        }
        catch (Exception e) {
            try {
                map.put(key, (Object)Integer.parseInt(value));
            }
            catch (Exception ignored) {
                try {
                    map.put(key, (Object)Boolean.parseBoolean(value));
                }
                catch (Exception ignored2) {
                    LOGGER.log(Level.WARNING, String.format("Override failed '%s=%s'", property, value), e);
                }
            }
        }
    }

    private static boolean isNull(Object o) {
        if (Number.class.isInstance(o)) {
            return ((Number)Number.class.cast(o)).intValue() == 0;
        }
        return o == null;
    }
}

