/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

public class ArquillianFilterRunner
implements Filter {
    private static final String ARQUILLIAN_SERVLET_RUNNER = "org.jboss.arquillian.protocol.servlet.runner.ServletTestRunner";
    private HttpServlet delegate;

    public void init(final FilterConfig filterConfig) throws ServletException {
        try {
            this.delegate = (HttpServlet)HttpServlet.class.cast(Thread.currentThread().getContextClassLoader().loadClass(ARQUILLIAN_SERVLET_RUNNER).newInstance());
            this.delegate.init(new ServletConfig(){

                public String getServletName() {
                    return ArquillianFilterRunner.class.getName();
                }

                public ServletContext getServletContext() {
                    return filterConfig.getServletContext();
                }

                public String getInitParameter(String name) {
                    return null;
                }

                public Enumeration<String> getInitParameterNames() {
                    return Collections.emptyEnumeration();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.delegate != null) {
            this.delegate.service(servletRequest, servletResponse);
        }
    }

    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }
}

