/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.io.File;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.openejb.arquillian.common.Files;
import org.apache.openejb.arquillian.common.IO;

public class Zips {
    private static final Logger logger = Logger.getLogger(Zips.class.getName());

    public static void unzip(File zipFile, File destination) {
        Zips.unzip(zipFile, destination, false);
    }

    public static void unzip(File zipFile, File destination, boolean noparent) {
        logger.info(String.format("Extracting '%s' to '%s'", zipFile.getAbsolutePath(), destination.getAbsolutePath()));
        Files.assertDir(destination);
        Files.writable(destination);
        Files.assertFile(zipFile);
        Files.readable(zipFile);
        try {
            ZipEntry entry;
            ZipInputStream in = IO.unzip(zipFile);
            while ((entry = in.getNextEntry()) != null) {
                String path = entry.getName();
                if (noparent) {
                    path = path.replaceFirst("^[^/]+/", "");
                }
                File file = new File(destination, path);
                if (entry.isDirectory()) {
                    Files.mkdir(file);
                    continue;
                }
                Files.mkdir(file.getParentFile());
                IO.copy((InputStream)in, file);
                long lastModified = entry.getTime();
                if (lastModified <= 0L) continue;
                file.setLastModified(lastModified);
            }
            in.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to unzip " + zipFile.getAbsolutePath(), e);
            throw new IllegalStateException("Unable to unzip " + zipFile.getAbsolutePath(), e);
        }
    }
}

