/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.arquillian.remote;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.apache.openejb.arquillian.common.ArquillianFilterRunner;
import org.apache.openejb.arquillian.common.ArquillianUtil;
import org.apache.openejb.arquillian.common.Files;
import org.apache.openejb.arquillian.common.IO;
import org.apache.openejb.arquillian.common.Setup;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.apache.openejb.arquillian.common.TomEEContainer;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.config.RemoteServer;
import org.apache.openejb.util.NetworkUtil;
import org.apache.tomee.arquillian.remote.RemoteTomEEConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.shrinkwrap.api.Archive;

public class RemoteTomEEContainer
extends TomEEContainer<RemoteTomEEConfiguration> {
    private static final Logger logger = Logger.getLogger(RemoteTomEEContainer.class.getName());
    private static final String ARQUILLIAN_FILTER = "-Dorg.apache.openejb.servlet.filters=" + ArquillianFilterRunner.class.getName() + "=/ArquillianServletRunnerEE9";
    private RemoteServer container;
    private boolean shutdown;
    private File tomeeHome;
    private Collection<Archive<?>> containerArchives;
    private final Properties deployerProperties = new Properties();

    public void setup(RemoteTomEEConfiguration configuration) {
        super.setup((TomEEConfiguration)configuration);
        if (configuration.getDeployerProperties() != null) {
            try {
                InputStream bytes = IO.read((byte[])configuration.getDeployerProperties().getBytes());
                IO.readProperties((InputStream)bytes, (Properties)this.deployerProperties);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Can't parse <property name=\"properties\"> value '" + configuration.getProperties() + "'", e);
            }
        }
    }

    protected String providerUrl() {
        return String.format(((RemoteTomEEConfiguration)this.configuration).getProviderUrlPattern(), super.providerUrl());
    }

    public void start() throws LifecycleException {
        int httpPort = ((RemoteTomEEConfiguration)this.configuration).getHttpPort();
        if (Setup.isRunning((String)((RemoteTomEEConfiguration)this.configuration).getHost(), (int)httpPort)) {
            String host = "local";
            if (!NetworkUtil.isLocalAddress((String)((RemoteTomEEConfiguration)this.configuration).getHost())) {
                if (null == this.deployerProperties.getProperty("openejb.deployer.binaries.use")) {
                    this.deployerProperties.setProperty("openejb.deployer.binaries.use", "true");
                }
                host = "remote";
            }
            logger.info(String.format("TomEE found running on %s port %s", host, httpPort));
            return;
        }
        this.shutdown = true;
        String shutdownPort = System.getProperty("server.shutdown.port");
        String shutdownHost = System.getProperty("server.shutdown.host");
        String shutdownCommand = System.getProperty("server.shutdown.command");
        String debug = System.getProperty("openejb.server.debug");
        String debugPort = System.getProperty("server.debug.port");
        try {
            this.configure();
            int stopPort = ((RemoteTomEEConfiguration)this.configuration).getStopPort();
            System.setProperty("server.shutdown.port", Integer.toString(stopPort));
            System.setProperty("server.shutdown.command", ((RemoteTomEEConfiguration)this.configuration).getStopCommand());
            System.setProperty("server.shutdown.host", ((RemoteTomEEConfiguration)this.configuration).getStopHost());
            if (((RemoteTomEEConfiguration)this.configuration).isDebug()) {
                System.setProperty("openejb.server.debug", "true");
                System.setProperty("server.debug.port", Integer.toString(((RemoteTomEEConfiguration)this.configuration).getDebugPort()));
            }
            this.container = new RemoteServer();
            this.container.setPortStartup(httpPort);
            try {
                this.container.start(this.args(), "start", true);
            }
            catch (Exception e) {
                this.container.destroy();
                throw e;
            }
            this.container.killOnExit();
            if (((RemoteTomEEConfiguration)this.configuration).getProperties() != null) {
                Properties props = new Properties();
                IO.readProperties((InputStream)IO.read((byte[])((RemoteTomEEConfiguration)this.configuration).getProperties().getBytes()), (Properties)props);
                this.containerArchives = ArquillianUtil.toDeploy((Properties)props);
                for (Archive<?> archive : this.containerArchives) {
                    this.deploy(archive);
                }
            }
        }
        catch (Exception e) {
            if (this.container != null) {
                this.container.destroy();
            }
            logger.log(Level.SEVERE, "Unable to start remote container", e);
            throw new LifecycleException("Unable to start remote container:" + e.getMessage(), (Throwable)e);
        }
        finally {
            RemoteTomEEContainer.resetSystemProperty("server.shutdown.port", shutdownPort);
            RemoteTomEEContainer.resetSystemProperty("server.shutdown.host", shutdownHost);
            RemoteTomEEContainer.resetSystemProperty("server.shutdown.command", shutdownCommand);
            RemoteTomEEContainer.resetSystemProperty("openejb.server.debug", debug);
            RemoteTomEEContainer.resetSystemProperty("server.debug.port", debugPort);
        }
    }

    protected Properties getDeployerProperties() {
        if (this.deployerProperties.isEmpty()) {
            return null;
        }
        return this.deployerProperties;
    }

    private List<String> args() {
        String opts = ((RemoteTomEEConfiguration)this.configuration).getCatalina_opts();
        if (opts != null) {
            opts = opts.trim();
        }
        if (opts == null || opts.isEmpty()) {
            return Arrays.asList("-Dorg.apache.catalina.STRICT_SERVLET_COMPLIANCE=false", ARQUILLIAN_FILTER, "-Dopenejb.system.apps=true", "-Dtomee.remote.support=true");
        }
        ArrayList<String> splitOnSpace = new ArrayList<String>();
        ArgsIterator it = new ArgsIterator(opts);
        while (it.hasNext()) {
            splitOnSpace.add((String)it.next());
        }
        if (!splitOnSpace.contains("-Dorg.apache.catalina.STRICT_SERVLET_COMPLIANCE=true")) {
            splitOnSpace.add("-Dorg.apache.catalina.STRICT_SERVLET_COMPLIANCE=false");
        }
        splitOnSpace.add(ARQUILLIAN_FILTER);
        splitOnSpace.add("-Dopenejb.system.apps=true");
        splitOnSpace.add("-Dtomee.remote.support=true");
        return splitOnSpace;
    }

    private static void resetSystemProperty(String key, String value) {
        if (value == null) {
            System.getProperties().remove(key);
        } else {
            System.setProperty(key, value);
        }
    }

    private void configure() throws LifecycleException, IOException {
        File workingDirectory = new File(((RemoteTomEEConfiguration)this.configuration).getDir()).getAbsoluteFile();
        if (((RemoteTomEEConfiguration)this.configuration).getCleanOnStartUp()) {
            Files.delete((File)workingDirectory);
        }
        if (workingDirectory.exists()) {
            Files.assertDir((File)workingDirectory);
        } else {
            Files.mkdir((File)workingDirectory);
            Files.deleteOnExit((File)workingDirectory);
        }
        Files.readable((File)workingDirectory);
        Files.writable((File)workingDirectory);
        this.tomeeHome = Setup.findHome((File)workingDirectory);
        if (this.tomeeHome == null) {
            this.tomeeHome = Setup.downloadAndUnpack((File)workingDirectory, (String)((RemoteTomEEConfiguration)this.configuration).getArtifactName(), (String)((RemoteTomEEConfiguration)this.configuration).getDir());
            logger.log(Level.INFO, "Downloaded container to: " + this.tomeeHome);
        }
        Files.assertDir((File)this.tomeeHome);
        Files.readable((File)this.tomeeHome);
        Files.writable((File)this.tomeeHome);
        Setup.synchronizeFolder((File)this.tomeeHome, (String)((RemoteTomEEConfiguration)this.configuration).getConf(), (String)"conf");
        Setup.synchronizeFolder((File)this.tomeeHome, (String)((RemoteTomEEConfiguration)this.configuration).getBin(), (String)"bin");
        Setup.synchronizeFolder((File)this.tomeeHome, (String)((RemoteTomEEConfiguration)this.configuration).getLib(), (String)"lib");
        Setup.addTomEELibraries((File)new File(this.tomeeHome, "lib"), (String)((RemoteTomEEConfiguration)this.configuration).getAdditionalLibs(), (boolean)false);
        if (((RemoteTomEEConfiguration)this.configuration).getEndorsed() != null && !((RemoteTomEEConfiguration)this.configuration).getEndorsed().isEmpty()) {
            File endorsed = new File(this.tomeeHome, "endorsed");
            Files.mkdir((File)endorsed);
            Setup.addTomEELibraries((File)endorsed, (String)((RemoteTomEEConfiguration)this.configuration).getEndorsed(), (boolean)false);
        }
        Object opts = ((RemoteTomEEConfiguration)this.configuration).getCatalina_opts();
        if (((RemoteTomEEConfiguration)this.configuration).getJavaagent() != null && !((RemoteTomEEConfiguration)this.configuration).getJavaagent().isEmpty()) {
            File javaagent = new File(this.tomeeHome, "javaagent");
            Files.mkdir((File)javaagent);
            Map agents = Setup.addTomEELibraries((File)javaagent, (String)((RemoteTomEEConfiguration)this.configuration).getJavaagent(), (boolean)true);
            if (!agents.isEmpty()) {
                if (opts == null) {
                    opts = "";
                }
                for (Map.Entry entry : agents.entrySet()) {
                    opts = (String)opts + " \"-javaagent:" + ((File)entry.getKey()).getAbsolutePath() + (String)entry.getValue() + "\"";
                }
            }
            ((RemoteTomEEConfiguration)this.configuration).setCatalina_opts((String)opts);
        }
        Setup.configureServerXml((File)this.tomeeHome, (TomEEConfiguration)this.configuration);
        Setup.configureSystemProperties((File)this.tomeeHome, (TomEEConfiguration)this.configuration);
        Setup.exportProperties((File)this.tomeeHome, (TomEEConfiguration)this.configuration, (opts == null || !((String)opts).contains("-Xm") && !((String)opts).matches(".*-XX:[^=]*Size=.*") ? 1 : 0) != 0);
        Setup.installArquillianBeanDiscoverer((File)this.tomeeHome);
        if (((RemoteTomEEConfiguration)this.configuration).isRemoveUnusedWebapps()) {
            Setup.removeUselessWebapps((File)this.tomeeHome, (String[])new String[0]);
        }
        if (((RemoteTomEEConfiguration)this.configuration).isSimpleLog() && this.noLoggingConfigProvided()) {
            File loggingProperties = Files.path((File)this.tomeeHome, (String[])new String[]{"conf", "logging.properties"});
            Properties logging = new Properties();
            logging.put("handlers", "java.util.logging.ConsoleHandler");
            logging.put(".handlers", "java.util.logging.ConsoleHandler");
            logging.put("java.util.logging.ConsoleHandler.level", "INFO");
            logging.put("java.util.logging.ConsoleHandler.formatter", "org.apache.tomee.jul.formatter.SimpleTomEEFormatter");
            IO.writeProperties((File)loggingProperties, (Properties)logging);
        }
        if (logger.isLoggable(Level.FINE)) {
            TreeMap<Object, Object> map = new TreeMap<Object, Object>(System.getProperties());
            for (Map.Entry entry : map.entrySet()) {
                logger.log(Level.FINE, String.format("%s = %s\n", entry.getKey(), entry.getValue()));
            }
        }
    }

    private boolean noLoggingConfigProvided() {
        if (((RemoteTomEEConfiguration)this.configuration).getConf() == null) {
            return true;
        }
        File conf = new File(((RemoteTomEEConfiguration)this.configuration).getConf());
        return !conf.exists() || !new File(conf, "logging.properties").exists() && !new File(conf, "log4j.properties").exists() && !new File(conf, "log4j.xml").exists();
    }

    public void stop() throws LifecycleException {
        ArquillianUtil.undeploy((DeployableContainer)this, this.containerArchives);
        if (this.shutdown) {
            try {
                Setup.removeArquillianBeanDiscoverer((File)this.tomeeHome);
                this.container.destroy();
            }
            finally {
                this.resetSerialization();
            }
        }
    }

    public Class<RemoteTomEEConfiguration> getConfigurationClass() {
        return RemoteTomEEConfiguration.class;
    }

    protected Deployer deployer() throws NamingException {
        try {
            return super.deployer();
        }
        catch (RuntimeException ne) {
            if (Boolean.getBoolean("openejb.arquillian.debug")) {
                this.container.kill3UNIX();
                LOGGER.info("Can't connect to deployer through: " + this.providerUrl());
                try {
                    LOGGER.info("Here is the server.xml:\n" + IO.slurp((File)new File(Setup.findHome((File)new File(((RemoteTomEEConfiguration)this.configuration).getDir()).getAbsoluteFile()), "conf/server.xml")));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw ne;
        }
    }

    private static class ArgsIterator
    implements Iterator<String> {
        private final String string;
        private int currentIndex;

        public ArgsIterator(String opts) {
            this.string = opts;
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.string != null && this.currentIndex < this.string.length();
        }

        @Override
        public String next() {
            int endChar;
            this.skipWhiteCharacters();
            if (this.done()) {
                throw new UnsupportedOperationException("No more element");
            }
            if (this.string.charAt(this.currentIndex) == '\"') {
                ++this.currentIndex;
                endChar = 34;
            } else {
                endChar = 32;
            }
            int start = this.currentIndex;
            int end = this.string.indexOf(endChar, this.currentIndex + 1);
            if (end <= 0) {
                end = this.string.length();
            }
            this.currentIndex = end + 1;
            return this.string.substring(start, end);
        }

        private void skipWhiteCharacters() {
            while (!(this.done() || this.string.charAt(this.currentIndex) != ' ' && this.string.charAt(this.currentIndex) != '\t')) {
                ++this.currentIndex;
            }
        }

        private boolean done() {
            return this.currentIndex >= this.string.length();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

