/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.cpdsadapter;

import java.util.Arrays;
import org.apache.commons.dbcp2.PStmtKey;

public class PStmtKeyCPDS
extends PStmtKey {
    private final Integer _resultSetHoldability;
    private final int[] _columnIndexes;
    private final String[] _columnNames;

    public PStmtKeyCPDS(String sql) {
        super(sql);
        this._resultSetHoldability = null;
        this._columnIndexes = null;
        this._columnNames = null;
    }

    public PStmtKeyCPDS(String sql, int autoGeneratedKeys) {
        super(sql, null, autoGeneratedKeys);
        this._resultSetHoldability = null;
        this._columnIndexes = null;
        this._columnNames = null;
    }

    public PStmtKeyCPDS(String sql, int resultSetType, int resultSetConcurrency) {
        super(sql, resultSetType, resultSetConcurrency);
        this._resultSetHoldability = null;
        this._columnIndexes = null;
        this._columnNames = null;
    }

    public PStmtKeyCPDS(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(sql, resultSetType, resultSetConcurrency);
        this._resultSetHoldability = resultSetHoldability;
        this._columnIndexes = null;
        this._columnNames = null;
    }

    public PStmtKeyCPDS(String sql, int[] columnIndexes) {
        super(sql);
        this._columnIndexes = Arrays.copyOf(columnIndexes, columnIndexes.length);
        this._resultSetHoldability = null;
        this._columnNames = null;
    }

    public PStmtKeyCPDS(String sql, String[] columnNames) {
        super(sql);
        this._columnNames = Arrays.copyOf(columnNames, columnNames.length);
        this._resultSetHoldability = null;
        this._columnIndexes = null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PStmtKeyCPDS other = (PStmtKeyCPDS)obj;
        if (!Arrays.equals(this._columnIndexes, other._columnIndexes)) {
            return false;
        }
        if (!Arrays.equals(this._columnNames, other._columnNames)) {
            return false;
        }
        return !(this._resultSetHoldability == null ? other._resultSetHoldability != null : !this._resultSetHoldability.equals(other._resultSetHoldability));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this._columnIndexes);
        result = 31 * result + Arrays.hashCode(this._columnNames);
        result = 31 * result + (this._resultSetHoldability == null ? 0 : this._resultSetHoldability.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("PStmtKey: sql=");
        buf.append(this.getSql());
        buf.append(", catalog=");
        buf.append(this.getCatalog());
        buf.append(", resultSetType=");
        buf.append(this.getResultSetType());
        buf.append(", resultSetConcurrency=");
        buf.append(this.getResultSetConcurrency());
        buf.append(", statementType=");
        buf.append((Object)this.getStmtType());
        buf.append(", resultSetHoldability=");
        buf.append(this._resultSetHoldability);
        buf.append(", columnIndexes=");
        buf.append(Arrays.toString(this._columnIndexes));
        buf.append(", columnNames=");
        buf.append(Arrays.toString(this._columnNames));
        return buf.toString();
    }
}

