/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.jaxrs.provider.AbstractCachingMessageProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;

@Provider
public class CachingMessageBodyReader<T>
extends AbstractCachingMessageProvider<T>
implements MessageBodyReader<T> {
    private List<MessageBodyReader<T>> delegatingReaders;

    public boolean isReadable(Class<?> type, Type gType, Annotation[] anns, MediaType mt) {
        if (this.delegatingReaders != null) {
            return this.getDelegatingReader(type, gType, anns, mt) != null;
        }
        return this.isProviderKeyNotSet();
    }

    private MessageBodyReader<T> getDelegatingReader(Class<?> type, Type gType, Annotation[] anns, MediaType mt) {
        for (MessageBodyReader<T> reader : this.delegatingReaders) {
            if (!reader.isReadable(type, gType, anns, mt)) continue;
            return reader;
        }
        return null;
    }

    public T readFrom(Class<T> type, Type gType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> theheaders, InputStream is) throws IOException, WebApplicationException {
        this.setObject(this.getReader(type, gType, anns, mt).readFrom(type, gType, anns, mt, theheaders, is));
        return this.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageBodyReader<T> getReader(Class<?> type, Type gType, Annotation[] anns, MediaType mt) {
        MessageBodyReader r;
        if (this.delegatingReaders != null) {
            return this.getDelegatingReader(type, gType, anns, mt);
        }
        this.mc.put("active.jaxrs.provider", this);
        try {
            Class<?> actualType = type;
            r = this.mc.getProviders().getMessageBodyReader(actualType, gType, anns, mt);
        }
        finally {
            this.mc.put("active.jaxrs.provider", null);
        }
        if (r == null) {
            Message message = new Message("NO_MSG_READER", BUNDLE, type);
            LOG.severe(message.toString());
            throw ExceptionUtils.toNotAcceptableException(null, null);
        }
        return r;
    }

    public void setDelegatingReader(MessageBodyReader<T> reader) {
        this.delegatingReaders = Collections.singletonList(reader);
    }

    public void setDelegatingReaders(List<MessageBodyReader<T>> readers) {
        this.delegatingReaders = readers;
    }
}

