/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.attachment.HeaderSizeExceededException;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.io.CacheSizeExceededException;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ProvidersImpl;
import org.apache.cxf.jaxrs.interceptor.AttachmentInputInterceptor;
import org.apache.cxf.jaxrs.interceptor.AttachmentOutputInterceptor;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;

public class MessageContextImpl
implements MessageContext {
    private Message m;

    public MessageContextImpl(Message m) {
        this.m = m;
    }

    @Override
    public Object get(Object key) {
        String keyValue = key.toString();
        if ("org.apache.cxf.jaxrs.attachments.inbound".equals(keyValue) || "org.apache.cxf.jaxrs.attachments.inbound.embedded".equals(keyValue)) {
            try {
                return this.createAttachments(key.toString());
            }
            catch (CacheSizeExceededException e) {
                this.m.getExchange().put("cxf.io.cacheinput", Boolean.FALSE);
                throw new WebApplicationException((Throwable)e, 413);
            }
            catch (HeaderSizeExceededException e) {
                throw new WebApplicationException((Throwable)e, 413);
            }
        }
        if (keyValue.equals("WRITE-" + Message.ATTACHMENTS) && this.m.getExchange().getOutMessage() != null) {
            return this.m.getExchange().getOutMessage().get(Message.ATTACHMENTS);
        }
        Message currentMessage = this.getCurrentMessage();
        Object value = currentMessage.get(key);
        if (value == null) {
            if (Message.class.getName().equals(key)) {
                return currentMessage;
            }
            Exchange exchange = currentMessage.getExchange();
            if (exchange != null) {
                Message otherMessage;
                Message message = otherMessage = exchange.getInMessage() == currentMessage ? exchange.getOutMessage() : exchange.getInMessage();
                if (otherMessage != null) {
                    value = otherMessage.get(key);
                }
                if (value == null) {
                    value = this.m.getExchange().get(key);
                }
            }
        }
        return value;
    }

    private Message getCurrentMessage() {
        Message currentMessage = JAXRSUtils.getCurrentMessage();
        if (currentMessage == null) {
            currentMessage = this.m;
        }
        return currentMessage;
    }

    @Override
    public <T> T getContent(Class<T> format) {
        if (MessageUtils.isRequestor(this.m) && this.m.getExchange().getInMessage() != null) {
            Message inMessage = this.m.getExchange().getInMessage();
            return inMessage.getContent(format);
        }
        return this.m.getContent(format);
    }

    @Override
    public Object getContextualProperty(Object key) {
        Object value = this.m.getContextualProperty(key.toString());
        if (value == null && key.getClass() == Class.class) {
            return this.m.getExchange().get((Class)key);
        }
        return value;
    }

    @Override
    public <T> T getContext(Class<T> contextClass) {
        return this.getContext(contextClass, contextClass);
    }

    protected <T> T getContext(Type genericType, Class<T> clazz) {
        return JAXRSUtils.createContextValue(this.m, genericType, clazz);
    }

    @Override
    public <T, E> T getResolver(Class<T> resolverClazz, Class<E> resolveClazz) {
        if (ContextResolver.class == resolverClazz) {
            return resolverClazz.cast(this.getContext(resolveClazz, ContextResolver.class));
        }
        return null;
    }

    @Override
    public Request getRequest() {
        return this.getContext(Request.class);
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.getContext(HttpHeaders.class);
    }

    @Override
    public Providers getProviders() {
        return this.getContext(Providers.class);
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.getContext(SecurityContext.class);
    }

    @Override
    public UriInfo getUriInfo() {
        return this.getContext(UriInfo.class);
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        try {
            return this.getContext(HttpServletRequest.class);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return this.getContext(HttpServletResponse.class);
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.getContext(ServletConfig.class);
    }

    @Override
    public ServletContext getServletContext() {
        return this.getContext(ServletContext.class);
    }

    @Override
    public void put(Object key, Object value) {
        if ("org.apache.cxf.jaxrs.attachments.outbound".equals(key.toString())) {
            this.convertToAttachments(value);
        }
        Message currentMessage = this.getCurrentMessage();
        currentMessage.put(key.toString(), value);
        currentMessage.getExchange().put(key.toString(), value);
    }

    private void convertToAttachments(Object value) {
        String messageContentType;
        int index;
        List handlers = (List)value;
        ArrayList<org.apache.cxf.message.Attachment> atts = new ArrayList<org.apache.cxf.message.Attachment>();
        for (int i = 1; i < handlers.size(); ++i) {
            Attachment handler = (Attachment)handlers.get(i);
            AttachmentImpl att = new AttachmentImpl(handler.getContentId(), handler.getDataHandler());
            for (String key : handler.getHeaders().keySet()) {
                att.setHeader(key, handler.getHeader(key));
            }
            att.setXOP(false);
            atts.add(att);
        }
        Message outMessage = this.getOutMessage();
        outMessage.setAttachments(atts);
        outMessage.put("write.attachments", "true");
        Attachment root = (Attachment)handlers.get(0);
        String rootContentType = root.getContentType().toString();
        MetadataMap rootHeaders = new MetadataMap(root.getHeaders(), true, false, true);
        if (!AttachmentUtil.isMtomEnabled(outMessage)) {
            rootHeaders.putSingle("Content-Type", rootContentType);
        }
        if ((index = (messageContentType = outMessage.get("Content-Type").toString()).indexOf(";type")) > 0) {
            messageContentType = messageContentType.substring(0, index).trim();
        }
        AttachmentOutputInterceptor attInterceptor = new AttachmentOutputInterceptor(messageContentType, (Map<String, List<String>>)((Object)rootHeaders));
        outMessage.put("Content-Type", rootContentType);
        Map allHeaders = CastUtils.cast((Map)outMessage.get(Message.PROTOCOL_HEADERS));
        if (allHeaders != null) {
            allHeaders.remove("Content-Type");
        }
        attInterceptor.handleMessage(outMessage);
    }

    private Message getOutMessage() {
        Message message = this.m.getExchange().getOutMessage();
        if (message == null) {
            Endpoint ep = this.m.getExchange().getEndpoint();
            message = new MessageImpl();
            message.setExchange(this.m.getExchange());
            message = ep.getBinding().createMessage(message);
            this.m.getExchange().setOutMessage(message);
        }
        return message;
    }

    private MultipartBody createAttachments(String propertyName) {
        Message inMessage = this.m.getExchange().getInMessage();
        boolean embeddedAttachment = inMessage.get("org.apache.cxf.multipart.embedded") != null;
        Object o = inMessage.get(propertyName);
        if (o != null) {
            return (MultipartBody)o;
        }
        if (embeddedAttachment) {
            inMessage = new MessageImpl();
            inMessage.setExchange(new ExchangeImpl());
            inMessage.put("attachment-directory", this.m.getExchange().getInMessage().get("attachment-directory"));
            inMessage.put("attachment-memory-threshold", this.m.getExchange().getInMessage().get("attachment-memory-threshold"));
            inMessage.put("attachment-max-size", this.m.getExchange().getInMessage().get("attachment-max-size"));
            inMessage.put("attachment-max-header-size", this.m.getExchange().getInMessage().get("attachment-max-header-size"));
            inMessage.setContent(InputStream.class, this.m.getExchange().getInMessage().get("org.apache.cxf.multipart.embedded.input"));
            inMessage.put("Content-Type", this.m.getExchange().getInMessage().get("org.apache.cxf.multipart.embedded.ctype").toString());
        }
        new AttachmentInputInterceptor().handleMessage(inMessage);
        LinkedList<Attachment> newAttachments = new LinkedList<Attachment>();
        try {
            Map<String, List<String>> headers = CastUtils.cast((Map)inMessage.get(AttachmentDeserializer.ATTACHMENT_PART_HEADERS));
            Attachment first = new Attachment(AttachmentUtil.createAttachment(inMessage.getContent(InputStream.class), headers, inMessage), new ProvidersImpl(inMessage));
            newAttachments.add(first);
        }
        catch (IOException ex) {
            throw ExceptionUtils.toInternalServerErrorException(ex, null);
        }
        Collection<org.apache.cxf.message.Attachment> childAttachments = inMessage.getAttachments();
        if (childAttachments == null) {
            childAttachments = Collections.emptyList();
        }
        for (org.apache.cxf.message.Attachment a : childAttachments) {
            newAttachments.add(new Attachment(a, new ProvidersImpl(inMessage)));
        }
        MediaType mt = embeddedAttachment ? (MediaType)inMessage.get("org.apache.cxf.multipart.embedded.ctype") : this.getHttpHeaders().getMediaType();
        MultipartBody body = new MultipartBody(newAttachments, mt, false);
        inMessage.put(propertyName, body);
        return body;
    }
}

