/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

public class RequestImpl
implements Request {
    private final Message m;
    private final HttpHeaders headers;

    public RequestImpl(Message m) {
        this.m = m;
        this.headers = new HttpHeadersImpl(m);
    }

    public Variant selectVariant(List<Variant> vars) throws IllegalArgumentException {
        if (vars == null || vars.isEmpty()) {
            throw new IllegalArgumentException("List of Variants is either null or empty");
        }
        List acceptMediaTypes = this.headers.getAcceptableMediaTypes();
        List acceptLangs = this.headers.getAcceptableLanguages();
        List<String> acceptEncs = RequestImpl.parseAcceptEnc((String)this.headers.getRequestHeaders().getFirst((Object)"Accept-Encoding"));
        List<Variant> requestVariants = RequestImpl.sortAllCombinations(acceptMediaTypes, acceptLangs, acceptEncs);
        LinkedList<Object> varyValues = new LinkedList<Object>();
        for (Variant requestVar : requestVariants) {
            for (Variant var : vars) {
                boolean encMatched;
                boolean langMatched;
                boolean mtMatched;
                MediaType mt = var.getMediaType();
                Locale lang = var.getLanguage();
                String enc = var.getEncoding();
                boolean bl = mtMatched = mt == null || requestVar.getMediaType().isCompatible(mt);
                if (mtMatched) {
                    RequestImpl.handleVaryValues(varyValues, "Accept");
                }
                boolean bl2 = langMatched = lang == null || RequestImpl.isLanguageMatched(requestVar.getLanguage(), lang);
                if (langMatched) {
                    RequestImpl.handleVaryValues(varyValues, "Accept-Language");
                }
                boolean bl3 = encMatched = acceptEncs.isEmpty() || enc == null || RequestImpl.isEncMatached(requestVar.getEncoding(), enc);
                if (encMatched) {
                    RequestImpl.handleVaryValues(varyValues, "Accept-Encoding");
                }
                if (!mtMatched || !encMatched || !langMatched) continue;
                RequestImpl.addVaryHeader(varyValues);
                return var;
            }
        }
        return null;
    }

    private static List<Variant> sortAllCombinations(List<MediaType> mediaTypes, List<Locale> langs, List<String> encs) {
        LinkedList<Variant> requestVars = new LinkedList<Variant>();
        for (MediaType mt : mediaTypes) {
            for (Locale lang : langs) {
                if (encs.isEmpty()) {
                    requestVars.add(new Variant(mt, lang, null));
                    continue;
                }
                for (String enc : encs) {
                    requestVars.add(new Variant(mt, lang, enc));
                }
            }
        }
        Collections.sort(requestVars, VariantComparator.INSTANCE);
        return requestVars;
    }

    private static void handleVaryValues(List<Object> varyValues, String ... values) {
        for (String v : values) {
            if (v == null || varyValues.contains(v)) continue;
            varyValues.add(v);
        }
    }

    private static void addVaryHeader(List<Object> varyValues) {
        Object httpResponse;
        Message message = PhaseInterceptorChain.getCurrentMessage();
        if (message != null && (httpResponse = message.get("HTTP.RESPONSE")) != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < varyValues.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(varyValues.get(i).toString());
            }
            ((HttpServletResponse)httpResponse).setHeader("Vary", sb.toString());
        }
    }

    private static boolean isLanguageMatched(Locale locale, Locale l) {
        String language = locale.getLanguage();
        return "*".equals(language) || language.equalsIgnoreCase(l.getLanguage());
    }

    private static boolean isEncMatached(String accepts, String enc) {
        return accepts == null || "*".equals(accepts) || accepts.contains(enc);
    }

    private static List<String> parseAcceptEnc(String acceptEnc) {
        String[] values;
        if (StringUtils.isEmpty(acceptEnc)) {
            return Collections.emptyList();
        }
        LinkedList<String> list = new LinkedList<String>();
        for (String value : values = acceptEnc.split(",")) {
            String[] pair = value.trim().split(";");
            list.add(pair[0]);
        }
        return list;
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        if (eTag == null) {
            throw new IllegalArgumentException("ETag is null");
        }
        return this.evaluateAll(eTag, null);
    }

    private Response.ResponseBuilder evaluateAll(EntityTag eTag, Date lastModified) {
        Response.ResponseBuilder rb = this.evaluateIfMatch(eTag, lastModified);
        if (rb == null) {
            rb = this.evaluateIfNonMatch(eTag, lastModified);
        }
        return rb;
    }

    private Response.ResponseBuilder evaluateIfMatch(EntityTag eTag, Date date) {
        List ifMatch = this.headers.getRequestHeader("If-Match");
        if (ifMatch == null || ifMatch.isEmpty()) {
            return date == null ? null : this.evaluateIfNotModifiedSince(date);
        }
        try {
            for (String value : ifMatch) {
                if ("*".equals(value)) {
                    return null;
                }
                EntityTag requestTag = EntityTag.valueOf((String)value);
                if (requestTag.isWeak() || eTag.isWeak() || !requestTag.equals((Object)eTag)) continue;
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).tag(eTag);
    }

    private Response.ResponseBuilder evaluateIfNonMatch(EntityTag eTag, Date lastModified) {
        List ifNonMatch = this.headers.getRequestHeader("If-None-Match");
        if (ifNonMatch == null || ifNonMatch.isEmpty()) {
            return lastModified == null ? null : this.evaluateIfModifiedSince(lastModified);
        }
        String method = this.getMethod();
        boolean getOrHead = "GET".equals(method) || "HEAD".equals(method);
        try {
            for (String value : ifNonMatch) {
                boolean result = "*".equals(value);
                if (!result) {
                    EntityTag requestTag = EntityTag.valueOf((String)value);
                    boolean bl = getOrHead ? requestTag.equals((Object)eTag) : (result = !requestTag.isWeak() && !eTag.isWeak() && requestTag.equals((Object)eTag));
                }
                if (!result) continue;
                Response.Status status = getOrHead ? Response.Status.NOT_MODIFIED : Response.Status.PRECONDITION_FAILED;
                return Response.status((Response.Status)status).tag(eTag);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        if (lastModified == null) {
            throw new IllegalArgumentException("Date is null");
        }
        Response.ResponseBuilder rb = this.evaluateIfNotModifiedSince(lastModified);
        if (rb == null) {
            rb = this.evaluateIfModifiedSince(lastModified);
        }
        return rb;
    }

    private Response.ResponseBuilder evaluateIfModifiedSince(Date lastModified) {
        Date dateSince;
        List ifModifiedSince = this.headers.getRequestHeader("If-Modified-Since");
        if (ifModifiedSince == null || ifModifiedSince.isEmpty()) {
            return null;
        }
        SimpleDateFormat dateFormat = HttpUtils.getHttpDateFormat();
        dateFormat.setLenient(false);
        try {
            dateSince = dateFormat.parse((String)ifModifiedSince.get(0));
        }
        catch (ParseException ex) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED);
        }
        if (dateSince.before(lastModified)) {
            return null;
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED);
    }

    private Response.ResponseBuilder evaluateIfNotModifiedSince(Date lastModified) {
        Date dateSince;
        List ifNotModifiedSince = this.headers.getRequestHeader("If-Unmodified-Since");
        if (ifNotModifiedSince == null || ifNotModifiedSince.isEmpty()) {
            return null;
        }
        SimpleDateFormat dateFormat = HttpUtils.getHttpDateFormat();
        dateFormat.setLenient(false);
        try {
            dateSince = dateFormat.parse((String)ifNotModifiedSince.get(0));
        }
        catch (ParseException ex) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED);
        }
        if (dateSince.before(lastModified)) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED);
        }
        return null;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        if (eTag == null || lastModified == null) {
            throw new IllegalArgumentException("ETag or Date is null");
        }
        return this.evaluateAll(eTag, lastModified);
    }

    public String getMethod() {
        return this.m.get("org.apache.cxf.request.method").toString();
    }

    public Response.ResponseBuilder evaluatePreconditions() {
        List ifMatch = this.headers.getRequestHeader("If-Match");
        if (ifMatch != null) {
            for (String value : ifMatch) {
                if ("*".equals(value)) continue;
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).tag(EntityTag.valueOf((String)value));
            }
        }
        return null;
    }

    private static final class VariantComparator
    implements Comparator<Variant> {
        static final VariantComparator INSTANCE = new VariantComparator();

        private VariantComparator() {
        }

        @Override
        public int compare(Variant v1, Variant v2) {
            int result = VariantComparator.compareMediaTypes(v1.getMediaType(), v2.getMediaType());
            if (result != 0) {
                return result;
            }
            result = VariantComparator.compareLanguages(v1.getLanguage(), v2.getLanguage());
            if (result == 0) {
                result = VariantComparator.compareEncodings(v1.getEncoding(), v2.getEncoding());
            }
            return result;
        }

        private static int compareMediaTypes(MediaType mt1, MediaType mt2) {
            if (mt1 != null && mt2 == null) {
                return -1;
            }
            if (mt1 == null && mt2 != null) {
                return 1;
            }
            return JAXRSUtils.compareMediaTypes(mt1, mt2);
        }

        private static int compareLanguages(Locale l1, Locale l2) {
            if (l1 != null && l2 == null) {
                return -1;
            }
            if (l1 == null && l2 != null) {
                return 1;
            }
            return 0;
        }

        private static int compareEncodings(String enc1, String enc2) {
            if (enc1 != null && enc2 == null) {
                return -1;
            }
            if (enc1 == null && enc2 != null) {
                return 1;
            }
            return 0;
        }
    }
}

