/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.transport.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.management.MBeanServer;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.counters.CounterRepository;
import org.apache.cxf.management.jmx.InstrumentationManagerImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.event.AssemblerBeforeApplicationDestroyed;
import org.apache.openejb.assembler.classic.event.AssemblerDestroyed;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.assembler.classic.util.ServiceInfos;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.server.cxf.transport.OpenEJBHttpDestinationFactory;
import org.apache.openejb.server.cxf.transport.event.BusCreated;
import org.apache.openejb.server.cxf.transport.util.CxfContainerClassLoader;
import org.apache.openejb.util.PropertiesHelper;
import org.apache.openejb.util.reflection.Reflections;

public final class CxfUtil {
    public static final String ENDPOINT_PROPERTIES = "properties";
    public static final String FEATURES = "features";
    public static final String IN_INTERCEPTORS = "in-interceptors";
    public static final String IN_FAULT_INTERCEPTORS = "in-fault-interceptors";
    public static final String OUT_INTERCEPTORS = "out-interceptors";
    public static final String OUT_FAULT_INTERCEPTORS = "out-fault-interceptors";
    public static final String DATABINDING = "databinding";
    public static final String ADDRESS = "address";
    public static final String PUBLISHED_URL = "published-url";
    public static final String DEBUG = "debug";
    public static final String BUS_PREFIX = "org.apache.openejb.cxf.bus.";
    public static final String BUS_CONFIGURED_FLAG = "openejb.cxf.bus.configured";
    private static final AtomicReference<Bus> DEFAULT_BUS = new AtomicReference();
    private static final AtomicInteger USER_COUNT = new AtomicInteger();
    private static Map<String, BindingFactory> bindingFactoryMap;

    private CxfUtil() {
    }

    public static void release() {
        Bus b;
        if (USER_COUNT.decrementAndGet() == 0 && (b = DEFAULT_BUS.get()) != null) {
            b.shutdown(true);
        }
    }

    public static boolean hasService(String name) {
        return bindingFactoryMap != null && bindingFactoryMap.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bus initDefaultBus() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.class.getClassLoader());
        try {
            Bus bus = BusFactory.newInstance((String)CXFBusFactory.class.getName()).createBus();
            bus.setId(SystemInstance.get().getProperty("openejb.cxf.bus.id", "openejb.cxf.bus"));
            BindingFactoryManager bfm = (BindingFactoryManager)bus.getExtension(BindingFactoryManager.class);
            bindingFactoryMap = (Map)Reflections.get((Object)bfm, (String)"bindingFactories");
            bus.setExtension((Object)new OpenEJBHttpDestinationFactory(), HttpDestinationFactory.class);
            CXFBusFactory.setDefaultBus((Bus)((Bus)Bus.class.cast(Proxy.newProxyInstance(CxfUtil.class.getClassLoader(), new Class[]{Bus.class}, (InvocationHandler)new ClientAwareBusHandler()))));
            SystemInstance.get().addObserver((Object)new LifecycleManager());
            Bus bus2 = bus;
            return bus2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bus getBus() {
        Bus bus = DEFAULT_BUS.get();
        if (bus == null) {
            AtomicReference<Bus> atomicReference = DEFAULT_BUS;
            synchronized (atomicReference) {
                bus = DEFAULT_BUS.get();
                if (bus == null) {
                    bus = CxfUtil.initDefaultBus();
                    DEFAULT_BUS.set(bus);
                }
            }
        }
        return bus;
    }

    public static ClassLoader initBusLoader() {
        ClassLoader loader = (ClassLoader)CxfUtil.getBus().getExtension(ClassLoader.class);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            if (CxfContainerClassLoader.class.isInstance(loader) && !CxfContainerClassLoader.class.isInstance(tccl)) {
                ((CxfContainerClassLoader)CxfContainerClassLoader.class.cast(loader)).tccl(tccl);
            }
            return loader;
        }
        return tccl;
    }

    public static void clearBusLoader(ClassLoader old) {
        ClassLoader loader = (ClassLoader)CxfUtil.getBus().getExtension(ClassLoader.class);
        if (loader != null && CxfContainerClassLoader.class.isInstance(loader) && (old == null || !CxfContainerClassLoader.class.isInstance(old))) {
            ((CxfContainerClassLoader)CxfContainerClassLoader.class.cast(loader)).clear();
        }
        Thread.currentThread().setContextClassLoader(old);
    }

    public static void configureEndpoint(AbstractEndpointFactory svrFactory, ServiceConfiguration configuration, String prefix) {
        String publishedUrl;
        String changedAddress;
        String featuresIds;
        String debugKey;
        Properties beanConfig = configuration.getProperties();
        if (beanConfig == null || beanConfig.isEmpty()) {
            return;
        }
        Collection availableServices = configuration.getAvailableServices();
        Properties properties = ServiceInfos.serviceProperties((Collection)availableServices, (String)beanConfig.getProperty(prefix + ENDPOINT_PROPERTIES));
        if (properties != null) {
            svrFactory.setProperties(PropertiesHelper.map((Properties)properties));
        }
        if ("true".equalsIgnoreCase(beanConfig.getProperty(debugKey = prefix + DEBUG, SystemInstance.get().getOptions().get(debugKey, "false")))) {
            svrFactory.getProperties(true).put("faultStackTraceEnabled", "true");
        }
        if ((featuresIds = beanConfig.getProperty(prefix + FEATURES)) != null) {
            List<Feature> features = CxfUtil.createFeatures(availableServices, featuresIds);
            svrFactory.setFeatures(features);
        }
        CxfUtil.configureInterceptors((InterceptorProvider)svrFactory, prefix, availableServices, beanConfig);
        String databinding = beanConfig.getProperty(prefix + DATABINDING);
        if (databinding != null && !databinding.trim().isEmpty()) {
            Object instance = ServiceInfos.resolve((Collection)availableServices, (String)databinding);
            if (instance == null) {
                try {
                    instance = Thread.currentThread().getContextClassLoader().loadClass(databinding).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!DataBinding.class.isInstance(instance)) {
                throw new OpenEJBRuntimeException(instance + " is not a " + DataBinding.class.getName() + ", please check configuration of service [id=" + databinding + "]");
            }
            svrFactory.setDataBinding((DataBinding)instance);
        }
        if ((changedAddress = beanConfig.getProperty(prefix + ADDRESS)) != null && !changedAddress.trim().isEmpty()) {
            svrFactory.setAddress(changedAddress);
        }
        if ((publishedUrl = beanConfig.getProperty(prefix + PUBLISHED_URL)) != null && !publishedUrl.trim().isEmpty()) {
            svrFactory.setPublishedEndpointUrl(publishedUrl);
        }
    }

    public static void configureInterceptors(InterceptorProvider abip, String prefix, Collection<ServiceInfo> availableServices, Properties beanConfig) {
        String outFaultInterceptorsIds;
        String outInterceptorsIds;
        String inFaultInterceptorsIds;
        String inInterceptorsIds = beanConfig.getProperty(prefix + IN_INTERCEPTORS);
        if (inInterceptorsIds != null && !inInterceptorsIds.trim().isEmpty()) {
            abip.getInInterceptors().addAll(CxfUtil.createInterceptors(availableServices, inInterceptorsIds));
        }
        if ((inFaultInterceptorsIds = beanConfig.getProperty(prefix + IN_FAULT_INTERCEPTORS)) != null && !inFaultInterceptorsIds.trim().isEmpty()) {
            abip.getInFaultInterceptors().addAll(CxfUtil.createInterceptors(availableServices, inFaultInterceptorsIds));
        }
        if ((outInterceptorsIds = beanConfig.getProperty(prefix + OUT_INTERCEPTORS)) != null && !outInterceptorsIds.trim().isEmpty()) {
            abip.getOutInterceptors().addAll(CxfUtil.createInterceptors(availableServices, outInterceptorsIds));
        }
        if ((outFaultInterceptorsIds = beanConfig.getProperty(prefix + OUT_FAULT_INTERCEPTORS)) != null && !outFaultInterceptorsIds.trim().isEmpty()) {
            abip.getOutFaultInterceptors().addAll(CxfUtil.createInterceptors(availableServices, outFaultInterceptorsIds));
        }
    }

    public static List<Feature> createFeatures(Collection<ServiceInfo> availableServices, String featuresIds) {
        List features = ServiceInfos.resolve(availableServices, (String[])featuresIds.split(","));
        for (Object instance : features) {
            if (AbstractFeature.class.isInstance(instance)) continue;
            throw new OpenEJBRuntimeException("feature should inherit from " + AbstractFeature.class.getName());
        }
        return features;
    }

    public static List<Interceptor<? extends Message>> createInterceptors(Collection<ServiceInfo> availableServices, String ids) {
        List instances = ServiceInfos.resolve(availableServices, (String[])ids.split(","));
        for (Object instance : instances) {
            if (Interceptor.class.isInstance(instance)) continue;
            throw new OpenEJBRuntimeException("interceptors should implement " + Interceptor.class.getName());
        }
        return instances;
    }

    public static void configureBus() {
        Properties busProperties;
        List<Feature> features;
        String featuresIds;
        InstrumentationManager mgr;
        boolean hasMonitoring;
        if (USER_COUNT.incrementAndGet() > 1) {
            return;
        }
        SystemInstance systemInstance = SystemInstance.get();
        Bus bus = CxfUtil.getBus();
        if ("true".equalsIgnoreCase(systemInstance.getProperty("openejb.cxf.CxfContainerClassLoader", "true"))) {
            bus.setExtension((Object)new CxfContainerClassLoader(), ClassLoader.class);
        }
        if (((hasMonitoring = CxfUtil.hasMonitoring(systemInstance)) || "true".equalsIgnoreCase(systemInstance.getProperty("openejb.cxf.jmx", "true"))) && InstrumentationManagerImpl.class.isInstance(mgr = (InstrumentationManager)bus.getExtension(InstrumentationManager.class))) {
            bus.setExtension((Object)LocalMBeanServer.get(), MBeanServer.class);
            InstrumentationManagerImpl manager = (InstrumentationManagerImpl)InstrumentationManagerImpl.class.cast(mgr);
            manager.setEnabled(true);
            manager.setServer(LocalMBeanServer.get());
            manager.setDaemon(true);
            try {
                LogUtils.getL7dLogger(InstrumentationManagerImpl.class).setLevel(Level.WARNING);
            }
            catch (Throwable th) {
                // empty catch block
            }
            manager.init();
        }
        if (hasMonitoring) {
            new CounterRepository().setBus(bus);
        }
        ServiceConfiguration configuration = new ServiceConfiguration(systemInstance.getProperties(), (Collection)((OpenEjbConfiguration)systemInstance.getComponent(OpenEjbConfiguration.class)).facilities.services);
        Collection serviceInfos = configuration.getAvailableServices();
        Properties properties = configuration.getProperties();
        if (properties == null) {
            properties = new Properties();
        }
        if ((featuresIds = properties.getProperty("org.apache.openejb.cxf.bus.features")) != null && (features = CxfUtil.createFeatures(serviceInfos, featuresIds)) != null) {
            features.addAll(bus.getFeatures());
            bus.setFeatures(features);
        }
        if ((busProperties = ServiceInfos.serviceProperties((Collection)serviceInfos, (String)properties.getProperty("org.apache.openejb.cxf.bus.properties"))) != null) {
            bus.getProperties().putAll(PropertiesHelper.map((Properties)busProperties));
        }
        CxfUtil.configureInterceptors((InterceptorProvider)bus, BUS_PREFIX, serviceInfos, configuration.getProperties());
        systemInstance.getProperties().setProperty(BUS_CONFIGURED_FLAG, "true");
        systemInstance.fireEvent((Object)new BusCreated(bus));
    }

    private static boolean hasMonitoring(SystemInstance systemInstance) {
        return "true".equalsIgnoreCase(systemInstance.getProperty("openejb.cxf.monitoring.jmx", "false"));
    }

    public static class LifecycleManager {
        public void destroy(@Observes AssemblerDestroyed ignored) {
            InstrumentationManager mgr;
            SystemInstance systemInstance = SystemInstance.get();
            Bus bus = CxfUtil.getBus();
            if ("true".equalsIgnoreCase(systemInstance.getProperty("openejb.cxf.jmx", "true")) && InstrumentationManagerImpl.class.isInstance(mgr = (InstrumentationManager)bus.getExtension(InstrumentationManager.class))) {
                mgr.shutdown();
            }
            systemInstance.removeObserver((Object)this);
        }

        public void destroy(@Observes AssemblerBeforeApplicationDestroyed ignored) {
            CounterRepository repo;
            SystemInstance systemInstance = SystemInstance.get();
            Bus bus = CxfUtil.getBus();
            if ("true".equalsIgnoreCase(systemInstance.getProperty("openejb.cxf.monitoring.jmx.clear-on-undeploy", "true")) && (repo = (CounterRepository)bus.getExtension(CounterRepository.class)) != null) {
                repo.getCounters().clear();
            }
        }
    }

    private static class ClientAwareBusHandler
    implements InvocationHandler {
        private ClientAwareBusHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Bus bus = CxfUtil.getBus();
            if ("getExtension".equals(method.getName()) && args != null && args.length == 1 && ClassLoader.class.equals(args[0])) {
                ClassLoader extensionLoader = (ClassLoader)ClassLoader.class.cast(method.invoke((Object)bus, args));
                if (CxfContainerClassLoader.class.isInstance(extensionLoader) && !((CxfContainerClassLoader)CxfContainerClassLoader.class.cast(extensionLoader)).hasTccl()) {
                    return null;
                }
                return extensionLoader;
            }
            return method.invoke((Object)bus, args);
        }
    }
}

