/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.login.LoginException;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.BeginWebBeansListener;
import org.apache.openejb.server.httpd.EEFilter;
import org.apache.openejb.server.httpd.EndWebBeansListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.HttpSession;
import org.apache.openejb.server.httpd.HttpSessionImpl;
import org.apache.openejb.server.httpd.LightweightWebAppBuilderListenerExtractor;
import org.apache.openejb.server.httpd.OpenEJBAsyncContext;
import org.apache.openejb.server.httpd.OpenEJBHttpServer;
import org.apache.openejb.server.httpd.ServletByteArrayIntputStream;
import org.apache.openejb.server.httpd.ServletResponseAdapter;
import org.apache.openejb.server.httpd.ServletSessionAdapter;
import org.apache.openejb.server.httpd.part.CommonsFileUploadPartFactory;
import org.apache.openejb.server.httpd.session.SessionManager;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.AppFinder;
import org.apache.openejb.util.ArrayEnumeration;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;

public class HttpRequestImpl
implements HttpRequest {
    private static final String FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String CHUNKED = "chunked";
    public static final Class<?>[] SERVLET_CONTEXT_INTERFACES = new Class[]{ServletContext.class};
    public static final InvocationHandler SERVLET_CONTEXT_HANDLER = (proxy, method, args) -> null;
    private EndWebBeansListener end;
    private BeginWebBeansListener begin;
    private WebContext application;
    private String method;
    private URI uri;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final Map<String, String> formParams = new HashMap<String, String>();
    private final Map<String, List<String>> queryParams = new HashMap<String, List<String>>();
    private final Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private volatile Collection<Part> parts;
    private Map<String, String> cookies;
    private byte[] body;
    private ServletByteArrayIntputStream in;
    private int length;
    private String contentType;
    private final URI socketURI;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private String path = "/";
    private Locale locale = Locale.getDefault();
    private HttpSession session;
    private String encoding = "UTF-8";
    private ServletContext context = null;
    private String contextPath = "";
    private String servletPath = null;
    private Collection<ServletRequestListener> listeners;
    private volatile boolean asyncStarted;
    private boolean noPathInfo;

    public HttpRequestImpl(URI socketURI) {
        this.socketURI = socketURI;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getHeader(String name) {
        List<String> strings = this.headers.get(name);
        return strings == null || strings.isEmpty() ? null : strings.get(0);
    }

    public Enumeration<String> getHeaderNames() {
        return new ArrayEnumeration(new ArrayList<String>(this.headers.keySet()));
    }

    public Enumeration<String> getHeaders(String s) {
        List<String> list = this.headers.get(s);
        return new ArrayEnumeration(list == null ? Collections.emptyList() : list);
    }

    public int getIntHeader(String s) {
        String header = this.getHeader(s);
        return header == null ? -1 : Integer.parseInt(header);
    }

    public String getFormParameter(String name) {
        return this.formParams.get(name);
    }

    public Map<String, String> getFormParameters() {
        return new HashMap<String, String>(this.formParams);
    }

    public String getMethod() {
        return this.method;
    }

    public Part getPart(String s) throws IOException, ServletException {
        this.getParts();
        if (this.parts != null) {
            for (Part p : this.parts) {
                if (!s.equals(p.getName())) continue;
                return p;
            }
        }
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException("upgrade not supported");
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.parts == null) {
            this.parts = CommonsFileUploadPartFactory.read(this);
        }
        return this.parts;
    }

    public void noPathInfo() {
        this.noPathInfo = true;
    }

    public String getPathInfo() {
        if (this.noPathInfo) {
            return null;
        }
        if (this.servletPath != null) {
            return this.path.length() < this.servletPath.length() ? "" : this.path.substring(this.servletPath.length());
        }
        return this.path;
    }

    public String getPathTranslated() {
        return this.path;
    }

    public String getQueryString() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, List<String>> q : this.queryParams.entrySet()) {
            for (String v : q.getValue()) {
                str.append(q.getKey()).append("=").append(v).append("&");
            }
        }
        String out = str.toString();
        if (out.isEmpty()) {
            return out;
        }
        return out.substring(0, out.length() - 1);
    }

    public String getRemoteUser() {
        return null;
    }

    public String getRequestedSessionId() {
        if (this.session != null) {
            return this.session.getId();
        }
        return null;
    }

    public String getRequestURI() {
        return this.getURI().getRawPath();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.uri.getScheme() + "://" + this.uri.getAuthority() + this.uri.getRawPath());
    }

    public String getServletPath() {
        if (this.servletPath != null) {
            return this.servletPath;
        }
        if ("/".equals(this.path) && this.uri != null && "".equals(this.contextPath)) {
            return this.uri.getPath();
        }
        return this.path;
    }

    public void initServletPath(String servlet) {
        this.servletPath = servlet;
    }

    public void addQueryParams(String query) {
        this.parseQueryParams(query);
        this.parameters.putAll(this.queryParams);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public int getContentLength() {
        return this.length;
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.in;
    }

    public String getLocalAddr() {
        return this.getURI().getHost();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration<Locale> getLocales() {
        return new ArrayEnumeration(Arrays.asList(Locale.getAvailableLocales()));
    }

    public String getLocalName() {
        return this.locale.getLanguage();
    }

    public int getLocalPort() {
        return this.getURI().getPort();
    }

    protected boolean readMessage(InputStream input) throws IOException {
        String cookie;
        DataInputStream di = new DataInputStream(input);
        if (!this.readRequestLine(di)) {
            return false;
        }
        this.readHeaders(di);
        this.readBody(di);
        for (Map.Entry<String, String> formParameters : this.getFormParameters().entrySet()) {
            this.parameters.put(formParameters.getKey(), Collections.singletonList(formParameters.getValue()));
        }
        this.parameters.putAll(this.queryParams);
        if (this.headers.containsKey("Cookie") && (cookie = this.getHeader("Cookie")) != null) {
            String[] cookies;
            for (String c : cookies = cookie.split(";")) {
                SessionManager.SessionWrapper sessionWrapper;
                String current = c.trim();
                if (current.startsWith("EJBSESSIONID=")) {
                    sessionWrapper = ((SessionManager)SystemInstance.get().getComponent(SessionManager.class)).findSession(current.substring("EJBSESSIONID=".length()));
                    this.session = sessionWrapper == null ? null : sessionWrapper.session;
                    continue;
                }
                if (!current.startsWith("JSESSIONID=")) continue;
                sessionWrapper = ((SessionManager)SystemInstance.get().getComponent(SessionManager.class)).findSession(current.substring("JSESSIONID=".length()));
                this.session = sessionWrapper == null ? null : sessionWrapper.session;
            }
        }
        return true;
    }

    public void print(Logger log, boolean formatXml) {
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("******************* REQUEST ******************\n");
            builder.append(this.method).append(" ").append(this.uri).append("\n");
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                builder.append(entry).append("\n");
            }
            builder.append("\n");
            String text = new String(this.body);
            if (formatXml && OpenEJBHttpServer.isTextXml(this.headers)) {
                builder.append(OpenEJBHttpServer.reformat(text)).append("\n");
            } else {
                builder.append(text).append("\n");
            }
            builder.append("**********************************************").append("\n");
            log.debug(builder.toString());
        }
    }

    private boolean readRequestLine(DataInput in) throws IOException {
        String line;
        try {
            line = in.readLine();
        }
        catch (Exception e) {
            throw new IOException("Could not read the HTTP Request Line :" + e.getClass().getName() + " : " + e.getMessage());
        }
        if (line == null) {
            return false;
        }
        StringTokenizer lineParts = new StringTokenizer(line, " ");
        this.parseMethod(lineParts);
        this.parseURI(lineParts);
        return true;
    }

    private void parseMethod(StringTokenizer lineParts) throws IOException {
        String token;
        try {
            token = lineParts.nextToken();
        }
        catch (Exception e) {
            throw new IOException("Could not parse the HTTP Request Method :" + e.getClass().getName() + " : " + e.getMessage());
        }
        try {
            this.method = HttpRequest.Method.valueOf(token.toUpperCase(Locale.ENGLISH)).name();
        }
        catch (Exception e) {
            this.method = token;
        }
    }

    public void parseURI(StringTokenizer lineParts) throws IOException {
        String token;
        try {
            token = lineParts.nextToken();
        }
        catch (Exception e) {
            throw new IOException("Could not parse the HTTP Request Method :" + e.getClass().getName() + " : " + e.getMessage());
        }
        try {
            this.uri = new URI(this.socketURI.toString() + token.replace("//", "/"));
        }
        catch (URISyntaxException e) {
            throw new IOException("Malformed URI :" + token + " Exception: " + e.getMessage());
        }
        this.parseQueryParams(this.uri.getQuery());
    }

    private void parseQueryParams(String query) {
        if (query == null) {
            return;
        }
        StringTokenizer parameters = new StringTokenizer(query, "&");
        while (parameters.hasMoreTokens()) {
            String name;
            StringTokenizer param = new StringTokenizer(parameters.nextToken(), "=");
            if (!param.hasMoreTokens() || (name = URLDecoder.decode(param.nextToken())) == null) continue;
            String value = !param.hasMoreTokens() ? "" : URLDecoder.decode(param.nextToken());
            List<String> list = this.queryParams.get(name);
            if (list == null) {
                list = new LinkedList<String>();
                this.queryParams.put(name, list);
            }
            list.add(value);
        }
    }

    private void readHeaders(DataInput in) throws IOException {
        while (true) {
            String hf;
            try {
                hf = in.readLine();
            }
            catch (Exception e) {
                throw new IOException("Could not read the HTTP Request Header Field :" + e.getClass().getName() + " : " + e.getMessage());
            }
            if (hf == null || hf.equals("")) break;
            int colonIndex = hf.indexOf(58);
            String name = hf.substring(0, colonIndex);
            String value = hf.substring(colonIndex + 1, hf.length()).trim();
            List<String> values = this.headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(name, values);
            }
            values.add(value);
        }
        String host = this.getHeader("Host");
        if (host != null) {
            String hostName;
            int port = this.uri.getPort();
            int idx = host.indexOf(":");
            if (idx >= 0) {
                hostName = host.substring(0, idx);
                try {
                    port = Integer.parseInt(host.substring(idx + 1));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                hostName = host;
            }
            try {
                this.uri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), hostName, port, this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private boolean hasBody() {
        return !this.method.equals(HttpRequest.Method.GET.name()) && !this.method.equals(HttpRequest.Method.DELETE.name()) && !this.method.equals(HttpRequest.Method.HEAD.name()) && !this.method.equals(HttpRequest.Method.OPTIONS.name());
    }

    private void readBody(DataInput in) throws IOException {
        this.length = this.parseContentLength();
        this.contentType = this.getHeader("Content-Type");
        boolean hasBody = this.hasBody();
        if (hasBody && this.contentType != null && (this.contentType.startsWith(FORM_URL_ENCODED) || this.contentType.startsWith(MULTIPART_FORM_DATA))) {
            StringTokenizer param;
            String name;
            String rawParams;
            try {
                this.body = this.readContent(in);
                this.in = new ServletByteArrayIntputStream(this.body);
                rawParams = new String(this.body);
            }
            catch (Exception e) {
                throw (IOException)new IOException("Could not read the HTTP Request Body: " + e.getMessage()).initCause(e);
            }
            StringTokenizer parameters = new StringTokenizer(rawParams, "&");
            while (parameters.hasMoreTokens() && (name = URLDecoder.decode((param = new StringTokenizer(parameters.nextToken(), "=")).nextToken(), "UTF-8")) != null) {
                String value = param.hasMoreTokens() ? URLDecoder.decode(param.nextToken(), "UTF-8") : "";
                if (value == null) {
                    value = "";
                }
                this.formParams.put(name, value);
            }
        } else if (hasBody && CHUNKED.equals(this.getHeader(TRANSFER_ENCODING))) {
            try {
                String sizeString;
                int size;
                ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
                String line = in.readLine();
                while (line != null && (size = Integer.parseInt(sizeString = line.split(";", 2)[0], 16)) != 0) {
                    byte[] chunk = new byte[size];
                    in.readFully(chunk);
                    out.write(chunk);
                    in.readLine();
                    line = in.readLine();
                }
                this.body = out.toByteArray();
                this.in = new ServletByteArrayIntputStream(this.body);
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to read chunked body").initCause(e);
            }
        } else if (hasBody) {
            this.body = this.readContent(in);
            this.in = new ServletByteArrayIntputStream(this.body);
        } else {
            this.body = new byte[0];
            this.in = new ServletByteArrayIntputStream(this.body);
        }
    }

    private byte[] readContent(DataInput in) throws IOException {
        if (this.length >= 0) {
            byte[] body = new byte[this.length];
            in.readFully(body);
            return body;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        try {
            boolean atLineStart = true;
            while (true) {
                byte b;
                if ((b = in.readByte()) == 13) {
                    out.write(b);
                    b = in.readByte();
                }
                if (b == 10) {
                    if (atLineStart) break;
                    atLineStart = true;
                } else {
                    atLineStart = false;
                }
                out.write(b);
            }
        }
        catch (EOFException atLineStart) {
            // empty catch block
        }
        byte[] body = out.toByteArray();
        return body;
    }

    private int parseContentLength() {
        String len = this.getHeader("Content-Length");
        int length = -1;
        if (len != null) {
            try {
                length = Integer.parseInt(len);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return length;
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return true;
    }

    public String getAuthType() {
        return "BASIC";
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String extractContextPath() {
        int idx;
        if (SystemInstance.get().getOptions().get("openejb.webservice.old-deployment", false)) {
            return this.path;
        }
        String uri = this.getURI().getPath();
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if ((idx = uri.indexOf("/")) < 0) {
            return uri;
        }
        return uri.substring(0, idx);
    }

    public Cookie[] getCookies() {
        if (this.cookies != null) {
            return this.toCookies(this.cookies);
        }
        this.cookies = new HashMap<String, String>();
        String cookieHeader = this.getHeader("Cookie");
        if (cookieHeader == null) {
            return this.toCookies(this.cookies);
        }
        StringTokenizer tokens = new StringTokenizer(cookieHeader, ";");
        while (tokens.hasMoreTokens()) {
            StringTokenizer token = new StringTokenizer(tokens.nextToken(), "=");
            String name = token.nextToken();
            String value = token.nextToken();
            this.cookies.put(name, value);
        }
        return this.toCookies(this.cookies);
    }

    protected Map<?, ?> getInternalCookies() {
        if (this.cookies != null) {
            return this.cookies;
        }
        this.cookies = new HashMap<String, String>();
        String cookieHeader = this.getHeader("Cookie");
        if (cookieHeader == null) {
            return this.cookies;
        }
        StringTokenizer tokens = new StringTokenizer(cookieHeader, ";");
        while (tokens.hasMoreTokens()) {
            StringTokenizer token = new StringTokenizer(tokens.nextToken(), "=");
            String name = token.nextToken();
            String value = token.nextToken();
            this.cookies.put(name, value);
        }
        return this.cookies;
    }

    private Cookie[] toCookies(Map<String, String> cookies) {
        Cookie[] out = new Cookie[cookies.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            out[i++] = new Cookie(entry.getKey(), entry.getValue());
        }
        return out;
    }

    public long getDateHeader(String s) {
        return Long.parseLong(s);
    }

    protected String getCookie(String name) {
        return (String)this.getInternalCookies().get(name);
    }

    public HttpSession getSession(boolean create) {
        if (this.session == null && create) {
            Assembler assembler;
            long timeout = -1L;
            if (this.contextPath != null && (assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class)) != null) {
                for (AppInfo info : assembler.getDeployedApplications()) {
                    for (WebAppInfo webApp : info.webApps) {
                        if (!webApp.contextRoot.replace("/", "").equals(this.contextPath.replace("/", ""))) continue;
                        timeout = webApp.sessionTimeout;
                    }
                }
            }
            HttpSessionImpl impl = new HttpSessionImpl(this.contextPath, timeout){

                @Override
                public void invalidate() {
                    super.invalidate();
                    HttpRequestImpl.this.session = null;
                }
            };
            this.session = impl;
            if (this.begin != null) {
                this.begin.sessionCreated(new HttpSessionEvent((javax.servlet.http.HttpSession)this.session));
                this.session = new SessionInvalidateListener(this.session, this.begin);
            }
            impl.callListeners();
            SessionManager sessionManager = (SessionManager)SystemInstance.get().getComponent(SessionManager.class);
            SessionManager.SessionWrapper previous = sessionManager.newSession(this.begin, this.end, this.session, this.application);
            if (previous != null) {
                this.session = previous.session;
            }
        }
        return this.session;
    }

    protected URI getSocketURI() {
        return this.socketURI;
    }

    public Principal getUserPrincipal() {
        return ((SecurityService)SystemInstance.get().getComponent(SecurityService.class)).getCallerPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isUserInRole(String s) {
        return ((SecurityService)SystemInstance.get().getComponent(SecurityService.class)).isCallerInRole(s);
    }

    public void login(String s, String s1) throws ServletException {
        SecurityService component = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
        try {
            Object uuid = component.login(s, s1);
            component.associate(uuid);
        }
        catch (LoginException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void logout() throws ServletException {
        SecurityService component = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
        try {
            Object disassociate = component.disassociate();
            if (disassociate != null) {
                component.logout(disassociate);
            }
        }
        catch (LoginException e) {
            throw new SecurityException(e);
        }
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        if (this.session != null) {
            if (HttpSessionImpl.class.isInstance(this.session)) {
                ((HttpSessionImpl)HttpSessionImpl.class.cast(this.session)).newSessionId();
            }
            return this.session.getId();
        }
        return null;
    }

    public AsyncContext getAsyncContext() {
        this.setAttribute("openejb_async", "true");
        return new OpenEJBAsyncContext(this, (ServletResponse)HttpResponse.class.cast(this.getAttribute("openejb_response")), this.contextPath);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new ArrayEnumeration(new ArrayList<String>(this.attributes.keySet()));
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        this.encoding = s;
    }

    public AsyncContext startAsync() {
        return this.startAsync((ServletRequest)this, (ServletResponse)HttpResponse.class.cast(this.getAttribute("openejb_response")));
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        this.setAttribute("openejb_async", "true");
        OpenEJBAsyncContext asyncContext = new OpenEJBAsyncContext((HttpServletRequest)HttpServletRequest.class.cast(servletRequest), servletResponse, this.contextPath);
        asyncContext.internalStartAsync();
        this.asyncStarted = true;
        WebBeansContext webBeansContext = (WebBeansContext)AppFinder.findAppContextOrWeb((ClassLoader)Thread.currentThread().getContextClassLoader(), (AppFinder.Transformer)AppFinder.WebBeansContextTransformer.INSTANCE);
        return webBeansContext != null ? new EEFilter.AsynContextWrapper(asyncContext, servletRequest, servletResponse, webBeansContext) : asyncContext;
    }

    public void addInternalParameter(String key, String val) {
        this.parameters.put(key, Arrays.asList(val));
    }

    @Override
    public String getParameter(String name) {
        List<String> strings = this.parameters.get(name);
        return strings == null ? null : strings.iterator().next();
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        for (Map.Entry<String, List<String>> p : this.parameters.entrySet()) {
            List<String> values = p.getValue();
            params.put(p.getKey(), values.toArray(new String[values.size()]));
        }
        return params;
    }

    public Enumeration<String> getParameterNames() {
        return new ArrayEnumeration(new ArrayList<String>(this.parameters.keySet()));
    }

    public String[] getParameterValues(String s) {
        List<String> strings = this.parameters.get(s);
        return strings == null ? null : strings.toArray(new String[strings.size()]);
    }

    public String getProtocol() {
        return this.uri.getScheme();
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRealPath(String s) {
        return this.path;
    }

    @Override
    @Deprecated
    public Map<String, String> getParameters() {
        HashMap<String, String> converted = new HashMap<String, String>(this.parameters.size());
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            converted.put(entry.getKey(), entry.getValue().iterator().next());
        }
        return converted;
    }

    @Override
    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return this.getURI().getHost();
    }

    public int getRemotePort() {
        return this.getURI().getPort();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return new SimpleDispatcher(s);
    }

    public String getScheme() {
        return this.getURI().getScheme();
    }

    public String getServerName() {
        return this.getURI().getHost();
    }

    public int getServerPort() {
        return this.getURI().getPort();
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = (ServletContext)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), SERVLET_CONTEXT_INTERFACES, SERVLET_CONTEXT_HANDLER);
        }
        return this.context;
    }

    public boolean isAsyncStarted() {
        return this.asyncStarted;
    }

    public boolean isAsyncSupported() {
        return true;
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String s) {
        this.attributes.remove(s);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String requestRawPath() {
        try {
            return new URI(this.getRequestURI()).getRawPath();
        }
        catch (URISyntaxException e) {
            return this.getRequestURI();
        }
    }

    public void initPathFromContext(String context) {
        if (!"/".equals(this.path) && !"".equals(this.contextPath)) {
            return;
        }
        String rawPath = this.requestRawPath();
        if (context != null) {
            if (context.endsWith("/")) {
                this.path = rawPath.substring(0, rawPath.length());
                this.contextPath = "";
            } else {
                this.path = rawPath.substring(context.length(), rawPath.length());
                this.contextPath = context;
            }
        }
    }

    public void setEndListener(EndWebBeansListener end) {
        if (this.end == null) {
            this.end = end;
        }
    }

    public void setApplication(WebContext app) {
        this.application = app;
    }

    public void setBeginListener(BeginWebBeansListener begin) {
        if (this.begin == null) {
            this.begin = begin;
        }
    }

    public void init() {
        if (this.begin != null && this.getAttribute("openejb_requestInitialized") == null) {
            this.setAttribute("openejb_requestInitialized", "ok");
            this.begin.requestInitialized(new ServletRequestEvent(this.getServletContext(), (ServletRequest)this));
        }
        this.listeners = LightweightWebAppBuilderListenerExtractor.findByTypeForContext(this.contextPath, ServletRequestListener.class);
        if (!this.listeners.isEmpty()) {
            ServletRequestEvent event = new ServletRequestEvent(this.getServletContext(), (ServletRequest)this);
            for (ServletRequestListener listener : this.listeners) {
                listener.requestInitialized(event);
            }
        }
    }

    public void destroy() {
        boolean openejbRequestDestroyed;
        boolean bl = openejbRequestDestroyed = this.getAttribute("openejb_requestDestroyed") == null;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            if (this.begin != null && this.end != null && openejbRequestDestroyed) {
                this.end.requestDestroyed(new ServletRequestEvent(this.getServletContext(), (ServletRequest)this));
            }
            ServletRequestEvent event = new ServletRequestEvent(this.getServletContext(), (ServletRequest)this);
            for (ServletRequestListener listener : this.listeners) {
                listener.requestDestroyed(event);
            }
        }
        if (this.begin != null && openejbRequestDestroyed) {
            this.setAttribute("openejb_requestDestroyed", "ok");
            this.begin.requestDestroyed(new ServletRequestEvent(this.getServletContext(), (ServletRequest)this));
        }
    }

    protected class SessionInvalidateListener
    extends ServletSessionAdapter {
        private final BeginWebBeansListener listener;

        public SessionInvalidateListener(javax.servlet.http.HttpSession session, BeginWebBeansListener end) {
            super(session);
            this.listener = end;
        }

        @Override
        public void invalidate() {
            try {
                super.invalidate();
            }
            finally {
                this.listener.sessionDestroyed(new HttpSessionEvent(this.session));
            }
        }
    }

    private static class SimpleDispatcher
    implements RequestDispatcher {
        private final String path;

        public SimpleDispatcher(String path) {
            this.path = path;
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            if (!HttpRequestImpl.class.isInstance(request)) {
                if (HttpServletResponse.class.isInstance(response)) {
                    ((HttpServletResponse)HttpServletResponse.class.cast(response)).sendError(404);
                }
                return;
            }
            HttpRequestImpl cast = (HttpRequestImpl)HttpRequestImpl.class.cast(request);
            HttpRequestImpl httpRequest = new HttpRequestImpl(cast.socketURI);
            httpRequest.uri = cast.uri;
            httpRequest.parameters.putAll(cast.parameters);
            httpRequest.initPathFromContext(cast.contextPath);
            httpRequest.initServletPath(this.path);
            httpRequest.method = cast.method;
            try {
                ((HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class)).onMessage(httpRequest, HttpResponse.class.isInstance(response) ? (HttpResponse)HttpResponse.class.cast(response) : new ServletResponseAdapter((HttpServletResponse)HttpServletResponse.class.cast(response)));
            }
            catch (Exception e) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        }
    }
}

