/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd.part;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;

public class CommonsFileUploadPart
implements Part {
    private final FileItem fileItem;
    private final File location;

    public CommonsFileUploadPart(FileItem fileItem, File location) {
        this.fileItem = fileItem;
        this.location = location;
    }

    public void delete() throws IOException {
        this.fileItem.delete();
    }

    public String getContentType() {
        return this.fileItem.getContentType();
    }

    public String getHeader(String name) {
        return this.fileItem.getHeaders().getHeader(name);
    }

    public Collection<String> getHeaderNames() {
        if (this.fileItem instanceof DiskFileItem) {
            LinkedHashSet<String> headerNames = new LinkedHashSet<String>();
            Iterator iter = this.fileItem.getHeaders().getHeaderNames();
            while (iter.hasNext()) {
                headerNames.add((String)iter.next());
            }
            return headerNames;
        }
        return Collections.emptyList();
    }

    public Collection<String> getHeaders(String name) {
        LinkedHashSet<String> headers = new LinkedHashSet<String>();
        Iterator iter = this.fileItem.getHeaders().getHeaders(name);
        while (iter.hasNext()) {
            headers.add((String)iter.next());
        }
        return headers;
    }

    public InputStream getInputStream() throws IOException {
        return this.fileItem.getInputStream();
    }

    public String getName() {
        return this.fileItem.getFieldName();
    }

    public long getSize() {
        return this.fileItem.getSize();
    }

    public void write(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(this.location, fileName);
        }
        try {
            this.fileItem.write(file);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return this.fileItem.getString(encoding);
    }

    public String getSubmittedFileName() {
        return this.fileItem.getName();
    }
}

