/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp;

import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.ObjectNotFoundException;
import org.apache.openejb.test.entity.cmp.UnknownCmpHome;
import org.apache.openejb.test.entity.cmp.UnknownCmpTestClient;

public class UnknownEjbObjectTests
extends UnknownCmpTestClient {
    public UnknownEjbObjectTests() {
        super("EJBObject.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/entity/cmp/UnknownCmpHome");
        this.ejbHome = (UnknownCmpHome)obj;
        this.ejbObject = this.ejbHome.createObject("Third Bean");
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.ejbObject != null) {
            this.ejbObject.remove();
        }
        super.tearDown();
    }

    public void test01_getHandle() {
        try {
            this.ejbHandle = this.ejbObject.getHandle();
            UnknownEjbObjectTests.assertNotNull((String)"The Handle is null", (Object)this.ejbHandle);
        }
        catch (Exception e) {
            UnknownEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_getPrimaryKey() {
        try {
            this.ejbPrimaryKey = this.ejbObject.getPrimaryKey();
            UnknownEjbObjectTests.assertNotNull((String)"The primary key is null", (Object)this.ejbPrimaryKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            UnknownEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_isIdentical() {
        try {
            UnknownEjbObjectTests.assertTrue((String)"The EJBObjects are not equal", (boolean)this.ejbObject.isIdentical((EJBObject)this.ejbObject));
        }
        catch (Exception e) {
            UnknownEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_getEjbHome() {
        try {
            EJBHome home = this.ejbObject.getEJBHome();
            UnknownEjbObjectTests.assertNotNull((String)"The EJBHome is null", (Object)home);
        }
        catch (Exception e) {
            UnknownEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_remove() {
        try {
            this.ejbObject.remove();
            try {
                this.ejbHome.findByPrimaryKey(this.ejbPrimaryKey);
                UnknownEjbObjectTests.fail((String)"Entity was not actually removed");
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            try {
                this.ejbObject.businessMethod("Should throw an exception");
                UnknownEjbObjectTests.assertTrue((String)"Calling business method after removing the EJBObject does not throw an exception", (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception e) {
            UnknownEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        finally {
            this.ejbObject = null;
        }
    }
}

