/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmr;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.TransactionRolledbackLocalException;
import org.apache.openejb.test.entity.cmr.AbstractCMRTest;
import org.apache.openejb.test.entity.cmr.manytomany.GameLocal;
import org.apache.openejb.test.entity.cmr.manytomany.GameLocalHome;
import org.apache.openejb.test.entity.cmr.manytomany.PlatformLocal;
import org.apache.openejb.test.entity.cmr.manytomany.PlatformLocalHome;

public class ManyToManyTests
extends AbstractCMRTest {
    private PlatformLocalHome platformLocalHome;
    private GameLocalHome gameLocalHome;

    public ManyToManyTests() {
        super("ManyToMany.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.platformLocalHome = (PlatformLocalHome)this.initialContext.lookup("client/tests/entity/cmr/manyToMany/PlatformLocal");
        this.gameLocalHome = (GameLocalHome)this.initialContext.lookup("client/tests/entity/cmr/manyToMany/GameLocal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAGetBExistingAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.findPlatform(new Integer(1));
            Set gameSets = platform.getGames();
            ManyToManyTests.assertEquals((long)2L, (long)gameSets.size());
            for (GameLocal game : gameSets) {
                if (game.getId().equals(new Integer(11))) {
                    ManyToManyTests.assertEquals((Object)"value11", (Object)game.getName());
                    continue;
                }
                if (game.getId().equals(new Integer(22))) {
                    ManyToManyTests.assertEquals((Object)"value22", (Object)game.getName());
                    continue;
                }
                ManyToManyTests.fail();
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetCmrNull() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.findPlatform(new Integer(1));
            try {
                platform.setGames(null);
                ManyToManyTests.fail((String)"expected platform.setGames(null) to throw an IllegalArgumentException");
            }
            catch (TransactionRolledbackLocalException e) {
                Throwable cause = e.getCause();
                ManyToManyTests.assertNotNull((String)"cause is null", (Object)cause);
                ManyToManyTests.assertTrue((String)"cause is not a instance of IllegalArgumentException", (boolean)(cause instanceof IllegalArgumentException));
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBGetAExistingAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            GameLocal game = this.findGame(new Integer(22));
            Set aSet = game.getPlatforms();
            ManyToManyTests.assertEquals((long)3L, (long)aSet.size());
            for (PlatformLocal platform : aSet) {
                if (platform.getId().equals(new Integer(1))) {
                    ManyToManyTests.assertEquals((Object)"value1", (Object)platform.getName());
                    continue;
                }
                if (platform.getId().equals(new Integer(2))) {
                    ManyToManyTests.assertEquals((Object)"value2", (Object)platform.getName());
                    continue;
                }
                if (platform.getId().equals(new Integer(3))) {
                    ManyToManyTests.assertEquals((Object)"value3", (Object)platform.getName());
                    continue;
                }
                ManyToManyTests.fail();
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    public void testASetBDropExisting() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.findPlatform(new Integer(1));
            platform.setGames(new HashSet());
            platform = this.findPlatform(new Integer(2));
            platform.setGames(new HashSet());
            platform = this.findPlatform(new Integer(3));
            platform.setGames(new HashSet());
        }
        finally {
            this.completeTransaction();
        }
        this.assertAllUnlinked();
    }

    public void testBSetADropExisting() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            GameLocal game = this.findGame(new Integer(11));
            game.setPlatforms(new HashSet());
            game = this.findGame(new Integer(22));
            game.setPlatforms(new HashSet());
        }
        finally {
            this.completeTransaction();
        }
        this.assertAllUnlinked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testASetBNewAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.createPlatform(new Integer(4));
            GameLocal game = this.createGame(new Integer(33));
            Set gameSets = platform.getGames();
            gameSets.add(game);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(4, 33);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBSetANewAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.createPlatform(new Integer(4));
            GameLocal game = this.createGame(new Integer(33));
            Set platformSets = game.getPlatforms();
            platformSets.add(platform);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(4, 33);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testASetBExistingBNewA() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.createPlatform(new Integer(4));
            GameLocal game = this.findGame(new Integer(11));
            Set gameSets = platform.getGames();
            gameSets.add(game);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(4, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBSetAExistingBNewA() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.createPlatform(new Integer(4));
            GameLocal game = this.findGame(new Integer(11));
            Set platformSets = game.getPlatforms();
            platformSets.add(platform);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(4, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testASetBExistingANewB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.findPlatform(new Integer(1));
            GameLocal game = this.createGame(new Integer(33));
            Set gameSets = platform.getGames();
            gameSets.add(game);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(1, 33);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBSetAExistingANewB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.findPlatform(new Integer(1));
            GameLocal game = this.createGame(new Integer(33));
            Set platformSets = game.getPlatforms();
            platformSets.add(platform);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(1, 33);
    }

    public void testRemoveRelationships() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.findPlatform(new Integer(1));
            platform.remove();
        }
        finally {
            this.completeTransaction();
        }
        this.assertPlatformDeleted(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIllegalCmrCollectionArgument() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.findPlatform(new Integer(1));
            Set games = platform.getGames();
            try {
                games.add(new Object());
                ManyToManyTests.fail((String)"expected games.add(new Object()) to throw an IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                games.addAll(Arrays.asList(new Object()));
                ManyToManyTests.fail((String)"expected games.addAll(Arrays.asList(new Object())) to throw an IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifyCmrCollectionOusideTx() throws Exception {
        Set games;
        GameLocal newGame;
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.findPlatform(new Integer(1));
            newGame = this.createGame(new Integer(33));
            games = platform.getGames();
        }
        finally {
            this.completeTransaction();
        }
        ManyToManyTests.assertFalse((boolean)games.isEmpty());
        ManyToManyTests.assertEquals((long)2L, (long)games.size());
        for (GameLocal game : games) {
            if (game.getId().equals(new Integer(11))) {
                ManyToManyTests.assertEquals((Object)"value11", (Object)game.getName());
                continue;
            }
            if (game.getId().equals(new Integer(22))) {
                ManyToManyTests.assertEquals((Object)"value22", (Object)game.getName());
                continue;
            }
            ManyToManyTests.fail();
        }
        try {
            games.add(newGame);
            ManyToManyTests.fail((String)"expected games.add(game) to throw an IllegalStateException");
        }
        catch (IllegalStateException iter) {
            // empty catch block
        }
        try {
            games.addAll(Arrays.asList(newGame));
            ManyToManyTests.fail((String)"expected games.addAll(Arrays.asList(game)) to throw an IllegalStateException");
        }
        catch (IllegalStateException iter) {
            // empty catch block
        }
        try {
            games.remove(newGame);
            ManyToManyTests.fail((String)"expected games.remove(game) to throw an IllegalStateException");
        }
        catch (IllegalStateException iter) {
            // empty catch block
        }
        try {
            games.removeAll(Arrays.asList(newGame));
            ManyToManyTests.fail((String)"expected games.removeAll(game) to throw an IllegalStateException");
        }
        catch (IllegalStateException iter) {
            // empty catch block
        }
        Iterator iterator = games.iterator();
        try {
            iterator.remove();
            ManyToManyTests.fail((String)"expected iterator.remove() to throw an ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifyCmrCollectionInNewTx() throws Exception {
        Set games;
        GameLocal newGame;
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.findPlatform(new Integer(1));
            newGame = this.createGame(new Integer(33));
            games = platform.getGames();
        }
        finally {
            this.completeTransaction();
        }
        this.beginTransaction();
        try {
            ManyToManyTests.assertFalse((boolean)games.isEmpty());
            ManyToManyTests.assertEquals((long)2L, (long)games.size());
            for (GameLocal game : games) {
                if (game.getId().equals(new Integer(11))) {
                    ManyToManyTests.assertEquals((Object)"value11", (Object)game.getName());
                    continue;
                }
                if (game.getId().equals(new Integer(22))) {
                    ManyToManyTests.assertEquals((Object)"value22", (Object)game.getName());
                    continue;
                }
                ManyToManyTests.fail();
            }
            try {
                games.add(newGame);
                ManyToManyTests.fail((String)"expected games.add(game) to throw an IllegalStateException");
            }
            catch (IllegalStateException iter) {
                // empty catch block
            }
            try {
                games.addAll(Arrays.asList(newGame));
                ManyToManyTests.fail((String)"expected games.addAll(Arrays.asList(game)) to throw an IllegalStateException");
            }
            catch (IllegalStateException iter) {
                // empty catch block
            }
            try {
                games.remove(newGame);
                ManyToManyTests.fail((String)"expected games.remove(game) to throw an IllegalStateException");
            }
            catch (IllegalStateException iter) {
                // empty catch block
            }
            try {
                games.removeAll(Arrays.asList(newGame));
                ManyToManyTests.fail((String)"expected games.removeAll(game) to throw an IllegalStateException");
            }
            catch (IllegalStateException iter) {
                // empty catch block
            }
            Iterator iterator = games.iterator();
            try {
                iterator.remove();
                ManyToManyTests.fail((String)"expected iterator.remove() to throw an ConcurrentModificationException");
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIteratorConcurrentModification() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.findPlatform(new Integer(1));
            GameLocal game = this.findGame(new Integer(11));
            Set games = platform.getGames();
            ManyToManyTests.assertFalse((boolean)games.isEmpty());
            ManyToManyTests.assertEquals((long)2L, (long)games.size());
            Iterator iterator = games.iterator();
            games.remove(game);
            ManyToManyTests.assertEquals((long)1L, (long)games.size());
            try {
                iterator.next();
                ManyToManyTests.fail((String)"expected iterator.next() to throw an ConcurrentModificationException");
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIteratorAndRemove() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PlatformLocal platform = this.findPlatform(new Integer(1));
            GameLocal game = this.findGame(new Integer(11));
            Set games = platform.getGames();
            ManyToManyTests.assertFalse((boolean)games.isEmpty());
            ManyToManyTests.assertEquals((long)2L, (long)games.size());
            Iterator iterator = games.iterator();
            ManyToManyTests.assertTrue((boolean)games.contains(game));
            platform.remove();
            ManyToManyTests.assertFalse((boolean)games.contains(game));
            ManyToManyTests.assertEquals((long)0L, (long)games.size());
            try {
                iterator.next();
                ManyToManyTests.fail((String)"expected iterator.next() to throw an ConcurrentModificationException");
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        finally {
            this.completeTransaction();
        }
    }

    private void assertPlatformDeleted(int platformId) throws Exception {
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM Game_Platform WHERE Platforms_id=" + platformId);
        ManyToManyTests.assertTrue((boolean)rs.next());
        ManyToManyTests.assertEquals((long)0L, (long)rs.getInt(1));
        rs.close();
        rs = s.executeQuery("SELECT COUNT(*) FROM Platform WHERE id=" + platformId);
        ManyToManyTests.assertTrue((boolean)rs.next());
        ManyToManyTests.assertEquals((long)0L, (long)rs.getInt(1));
        rs.close();
        s.close();
        c.close();
    }

    private void assertAllUnlinked() throws Exception {
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM Game_Platform");
        ManyToManyTests.assertTrue((boolean)rs.next());
        ManyToManyTests.assertEquals((long)0L, (long)rs.getInt(1));
        rs.close();
        s.close();
        c.close();
    }

    private void assertLinked(int platformId, int gameId) throws Exception {
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM Game_Platform WHERE Platforms_id = " + platformId + " AND Games_id = " + gameId);
        ManyToManyTests.assertTrue((boolean)rs.next());
        ManyToManyTests.assertEquals((long)1L, (long)rs.getInt(1));
        rs.close();
        rs = s.executeQuery("SELECT name FROM Platform WHERE id = " + platformId);
        ManyToManyTests.assertTrue((boolean)rs.next());
        ManyToManyTests.assertEquals((Object)("value" + platformId), (Object)rs.getString(1));
        rs = s.executeQuery("SELECT name FROM Game WHERE id = " + gameId);
        ManyToManyTests.assertTrue((boolean)rs.next());
        ManyToManyTests.assertEquals((Object)("value" + gameId), (Object)rs.getString(1));
        rs.close();
        s.close();
        c.close();
    }

    private GameLocal createGame(int gameId) throws CreateException {
        GameLocal menu = this.gameLocalHome.create(Integer.valueOf(gameId));
        menu.setName("value" + gameId);
        return menu;
    }

    private GameLocal findGame(int gameId) throws FinderException {
        return this.gameLocalHome.findByPrimaryKey(Integer.valueOf(gameId));
    }

    private PlatformLocal createPlatform(int platformId) throws CreateException {
        PlatformLocal platform = this.platformLocalHome.create(Integer.valueOf(platformId));
        platform.setName("value" + platformId);
        return platform;
    }

    private PlatformLocal findPlatform(int platformId) throws FinderException {
        return this.platformLocalHome.findByPrimaryKey(Integer.valueOf(platformId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDB() throws Exception {
        Connection connection = this.ds.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            try {
                statement.execute("DELETE FROM Game_Platform");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                statement.execute("DELETE FROM Game");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                statement.execute("DELETE FROM Platform");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            ManyToManyTests.close(statement);
            ManyToManyTests.close(connection);
        }
        this.beginTransaction();
        try {
            PlatformLocal platform1 = this.createPlatform(1);
            ManyToManyTests.assertNotNull((String)"platform1.getGames() is null", (Object)platform1.getGames());
            PlatformLocal platform2 = this.createPlatform(2);
            ManyToManyTests.assertNotNull((String)"platform2.getGames() is null", (Object)platform2.getGames());
            PlatformLocal platform3 = this.createPlatform(3);
            ManyToManyTests.assertNotNull((String)"platform3.getGames() is null", (Object)platform3.getGames());
            GameLocal game1 = this.createGame(11);
            ManyToManyTests.assertNotNull((String)"game1.getPlatforms() is null", (Object)game1.getPlatforms());
            GameLocal game2 = this.createGame(22);
            ManyToManyTests.assertNotNull((String)"game2.getPlatforms() is null", (Object)game2.getPlatforms());
            platform1.getGames().add(game1);
            platform1.getGames().add(game2);
            platform2.getGames().add(game2);
            platform3.getGames().add(game2);
        }
        finally {
            this.completeTransaction();
        }
    }

    protected void dump() throws SQLException {
        ManyToManyTests.dumpTable(this.ds, "Game");
        ManyToManyTests.dumpTable(this.ds, "Platform");
        ManyToManyTests.dumpTable(this.ds, "Game_Platform");
    }
}

