/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmr;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import org.apache.openejb.test.entity.cmr.AbstractCMRTest;
import org.apache.openejb.test.entity.cmr.onetoone.LicenseLocal;
import org.apache.openejb.test.entity.cmr.onetoone.LicenseLocalHome;
import org.apache.openejb.test.entity.cmr.onetoone.LicensePk;
import org.apache.openejb.test.entity.cmr.onetoone.PersonLocal;
import org.apache.openejb.test.entity.cmr.onetoone.PersonLocalHome;
import org.apache.openejb.test.entity.cmr.onetoone.PersonPk;

public class OneToOneComplexPkTests
extends AbstractCMRTest {
    private PersonLocalHome personLocalHome;
    private LicenseLocalHome licenseLocalHome;

    public OneToOneComplexPkTests() {
        super("OneToOneCompound.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.personLocalHome = (PersonLocalHome)this.initialContext.lookup("client/tests/entity/cmr/oneToOne/ComplexPersonLocal");
        this.licenseLocalHome = (LicenseLocalHome)this.initialContext.lookup("client/tests/entity/cmr/oneToOne/ComplexLicenseLocal");
    }

    public void test00_AGetBExistingAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(1);
            OneToOneComplexPkTests.assertNotNull((String)"person is null", (Object)person);
            LicenseLocal license = person.getLicense();
            OneToOneComplexPkTests.assertNotNull((String)"license is null", (Object)license);
            OneToOneComplexPkTests.assertEquals((Object)new Integer(11), (Object)license.getId());
            OneToOneComplexPkTests.assertEquals((Object)"value11", (Object)license.getNumber());
        }
        finally {
            this.completeTransaction();
        }
    }

    public void test01_BGetAExistingAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            LicenseLocal license = this.findLicense(11);
            PersonLocal person = license.getPerson();
            OneToOneComplexPkTests.assertNotNull((Object)person);
            OneToOneComplexPkTests.assertEquals((Object)new Integer(1), (Object)person.getId());
            OneToOneComplexPkTests.assertEquals((Object)"value1", (Object)person.getName());
        }
        finally {
            this.completeTransaction();
        }
    }

    public void test02_ASetBDropExisting() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(1);
            person.setLicense(null);
        }
        finally {
            this.completeTransaction();
        }
        this.assertUnlinked(1);
    }

    public void test03_BSetADropExisting() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            LicenseLocal license = this.findLicense(11);
            license.setPerson(null);
        }
        finally {
            this.completeTransaction();
        }
        this.assertUnlinked(1);
    }

    public void test04_ASetBNewAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(2);
            LicenseLocal license = this.createLicense(22);
            person.setLicense(license);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 22);
    }

    public void test05_BSetANewAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(2);
            LicenseLocal license = this.createLicense(22);
            license.setPerson(person);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 22);
    }

    public void test06_ASetBExistingBNewA() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(2);
            LicenseLocal license = this.findLicense(11);
            person.setLicense(license);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 11);
    }

    public void test07_BSetAExistingBNewA() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.createPerson(3);
            LicenseLocal license = this.findLicense(11);
            license.setPerson(person);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(3, 11);
    }

    public void test09_BSetAExistingANewB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(1);
            LicenseLocal license = this.createLicense(22);
            license.setPerson(person);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(1, 22);
    }

    public void test10_RemoveRelationships() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(1);
            person.remove();
        }
        finally {
            this.completeTransaction();
        }
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM ComplexLicense");
        OneToOneComplexPkTests.assertTrue((boolean)rs.next());
        OneToOneComplexPkTests.assertEquals((long)1L, (long)rs.getInt(1));
        OneToOneComplexPkTests.close(rs);
        rs = s.executeQuery("SELECT COUNT(*) FROM ComplexLicense WHERE person_id = 1");
        OneToOneComplexPkTests.assertTrue((boolean)rs.next());
        OneToOneComplexPkTests.assertEquals((long)0L, (long)rs.getInt(1));
        OneToOneComplexPkTests.close(rs);
        OneToOneComplexPkTests.close(s);
        OneToOneComplexPkTests.close(c);
    }

    public void test11_CascadeDelete() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            LicenseLocal license = this.findLicense(11);
            license.remove();
        }
        finally {
            this.completeTransaction();
        }
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM ComplexPerson WHERE id = 1");
        OneToOneComplexPkTests.assertTrue((boolean)rs.next());
        OneToOneComplexPkTests.assertEquals((long)0L, (long)rs.getInt(1));
        OneToOneComplexPkTests.close(rs);
        OneToOneComplexPkTests.close(s);
        OneToOneComplexPkTests.close(c);
    }

    public void Xtest12_CMPMappedToForeignKeyColumn() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            LicenseLocal license = this.findLicense(11);
            Integer field3 = license.getPoints();
            OneToOneComplexPkTests.assertEquals((Object)license.getPerson().getPrimaryKey(), (Object)field3);
        }
        finally {
            this.completeTransaction();
        }
    }

    public void Xtest13_SetCMPMappedToForeignKeyColumn() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            LicenseLocal license = this.findLicense(11);
            license.setPoints(new Integer(2));
            PersonLocal person = license.getPerson();
            OneToOneComplexPkTests.assertEquals((Object)new Integer(2), (Object)person.getId());
            OneToOneComplexPkTests.assertEquals((Object)"value2", (Object)person.getName());
        }
        finally {
            this.completeTransaction();
        }
    }

    private PersonLocal createPerson(int personId) throws CreateException {
        PersonLocal person = this.personLocalHome.create(new PersonPk(Integer.valueOf(personId), "value" + personId));
        return person;
    }

    private PersonLocal findPerson(int personId) throws FinderException {
        return this.personLocalHome.findByPrimaryKey(new PersonPk(Integer.valueOf(personId), "value" + personId));
    }

    private LicenseLocal createLicense(int licenseId) throws CreateException {
        LicenseLocal license = this.licenseLocalHome.create(new LicensePk(Integer.valueOf(licenseId), "value" + licenseId));
        return license;
    }

    private LicenseLocal findLicense(int licenseId) throws FinderException {
        return this.licenseLocalHome.findByPrimaryKey(new LicensePk(Integer.valueOf(licenseId), "value" + licenseId));
    }

    private void assertLinked(int personId, int licenseId) throws Exception {
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT name FROM ComplexPerson WHERE id = " + personId);
        OneToOneComplexPkTests.assertTrue((boolean)rs.next());
        OneToOneComplexPkTests.assertEquals((Object)("value" + personId), (Object)rs.getString("name"));
        OneToOneComplexPkTests.close(rs);
        rs = s.executeQuery("SELECT id, number FROM ComplexLicense WHERE person_id = " + personId);
        OneToOneComplexPkTests.assertTrue((boolean)rs.next());
        OneToOneComplexPkTests.assertEquals((long)licenseId, (long)rs.getInt("id"));
        OneToOneComplexPkTests.assertEquals((Object)("value" + licenseId), (Object)rs.getString("number"));
        OneToOneComplexPkTests.close(rs);
        OneToOneComplexPkTests.close(s);
        OneToOneComplexPkTests.close(c);
    }

    private void assertUnlinked(int personId) throws Exception {
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM ComplexLicense WHERE person_id = " + personId);
        OneToOneComplexPkTests.assertTrue((boolean)rs.next());
        OneToOneComplexPkTests.assertEquals((long)0L, (long)rs.getInt(1));
        OneToOneComplexPkTests.close(rs);
        OneToOneComplexPkTests.close(s);
        OneToOneComplexPkTests.close(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDB() throws Exception {
        Connection connection = this.ds.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            try {
                statement.execute("DELETE FROM ComplexPerson");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                statement.execute("DELETE FROM ComplexLicense");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            OneToOneComplexPkTests.close(statement);
            OneToOneComplexPkTests.close(connection);
        }
        PersonLocal person1 = this.createPerson(1);
        this.createPerson(2);
        LicenseLocal license = this.createLicense(11);
        license.setPerson(person1);
    }

    protected void dump() throws Exception {
        OneToOneComplexPkTests.dumpTable(this.ds, "ComplexPerson");
        OneToOneComplexPkTests.dumpTable(this.ds, "ComplexLicense");
    }
}

