/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmr;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import org.apache.openejb.test.entity.cmr.AbstractCMRTest;
import org.apache.openejb.test.entity.cmr.onetoone.LicenseLocal;
import org.apache.openejb.test.entity.cmr.onetoone.LicenseLocalHome;
import org.apache.openejb.test.entity.cmr.onetoone.PersonLocal;
import org.apache.openejb.test.entity.cmr.onetoone.PersonLocalHome;

public class OneToOneTests
extends AbstractCMRTest {
    private PersonLocalHome personLocalHome;
    private LicenseLocalHome licenseLocalHome;

    public OneToOneTests() {
        super("OneToOne.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.personLocalHome = (PersonLocalHome)this.initialContext.lookup("client/tests/entity/cmr/oneToOne/PersonLocal");
        this.licenseLocalHome = (LicenseLocalHome)this.initialContext.lookup("client/tests/entity/cmr/oneToOne/LicenseLocal");
    }

    public void test00_AGetBExistingAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(1);
            OneToOneTests.assertNotNull((String)"person is null", (Object)person);
            LicenseLocal license = person.getLicense();
            OneToOneTests.assertNotNull((String)"license is null", (Object)license);
            OneToOneTests.assertEquals((Object)new Integer(11), (Object)license.getId());
            OneToOneTests.assertEquals((Object)"value11", (Object)license.getNumber());
        }
        finally {
            this.completeTransaction();
        }
    }

    public void test01_BGetAExistingAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            LicenseLocal license = this.findLicense(11);
            PersonLocal person = license.getPerson();
            OneToOneTests.assertNotNull((Object)person);
            OneToOneTests.assertEquals((Object)new Integer(1), (Object)person.getId());
            OneToOneTests.assertEquals((Object)"value1", (Object)person.getName());
        }
        finally {
            this.completeTransaction();
        }
    }

    public void test02_ASetBDropExisting() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(1);
            person.setLicense(null);
        }
        finally {
            this.completeTransaction();
        }
        this.assertUnlinked(1);
    }

    public void test03_BSetADropExisting() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            LicenseLocal license = this.findLicense(11);
            license.setPerson(null);
        }
        finally {
            this.completeTransaction();
        }
        this.assertUnlinked(1);
    }

    public void test04_ASetBNewAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(2);
            LicenseLocal license = this.createLicense(22);
            person.setLicense(license);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 22);
    }

    public void test05_BSetANewAB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(2);
            LicenseLocal license = this.createLicense(22);
            license.setPerson(person);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 22);
    }

    public void test06_ASetBExistingBNewA() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(2);
            LicenseLocal license = this.findLicense(11);
            person.setLicense(license);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(2, 11);
    }

    public void test07_BSetAExistingBNewA() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.createPerson(3);
            LicenseLocal license = this.findLicense(11);
            license.setPerson(person);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(3, 11);
    }

    public void test09_BSetAExistingANewB() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(1);
            LicenseLocal license = this.createLicense(22);
            license.setPerson(person);
        }
        finally {
            this.completeTransaction();
        }
        this.assertLinked(1, 22);
    }

    public void test10_RemoveRelationships() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            PersonLocal person = this.findPerson(1);
            person.remove();
        }
        finally {
            this.completeTransaction();
        }
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM License");
        OneToOneTests.assertTrue((boolean)rs.next());
        OneToOneTests.assertEquals((long)1L, (long)rs.getInt(1));
        OneToOneTests.close(rs);
        rs = s.executeQuery("SELECT COUNT(*) FROM License WHERE person_id = 1");
        OneToOneTests.assertTrue((boolean)rs.next());
        OneToOneTests.assertEquals((long)0L, (long)rs.getInt(1));
        OneToOneTests.close(rs);
        OneToOneTests.close(s);
        OneToOneTests.close(c);
    }

    public void test11_CascadeDelete() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            LicenseLocal license = this.findLicense(11);
            license.remove();
        }
        finally {
            this.completeTransaction();
        }
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM Person WHERE id = 1");
        OneToOneTests.assertTrue((boolean)rs.next());
        OneToOneTests.assertEquals((long)0L, (long)rs.getInt(1));
        OneToOneTests.close(rs);
        OneToOneTests.close(s);
        OneToOneTests.close(c);
    }

    public void Xtest12_CMPMappedToForeignKeyColumn() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            LicenseLocal license = this.findLicense(11);
            Integer field3 = license.getPoints();
            OneToOneTests.assertEquals((Object)license.getPerson().getPrimaryKey(), (Object)field3);
        }
        finally {
            this.completeTransaction();
        }
    }

    public void Xtest13_SetCMPMappedToForeignKeyColumn() throws Exception {
        this.resetDB();
        this.beginTransaction();
        try {
            LicenseLocal license = this.findLicense(11);
            license.setPoints(new Integer(2));
            PersonLocal person = license.getPerson();
            OneToOneTests.assertEquals((Object)new Integer(2), (Object)person.getId());
            OneToOneTests.assertEquals((Object)"value2", (Object)person.getName());
        }
        finally {
            this.completeTransaction();
        }
    }

    private PersonLocal createPerson(int personId) throws CreateException {
        PersonLocal person = this.personLocalHome.create(Integer.valueOf(personId));
        person.setName("value" + personId);
        return person;
    }

    private PersonLocal findPerson(int personId) throws FinderException {
        return this.personLocalHome.findByPrimaryKey(Integer.valueOf(personId));
    }

    private LicenseLocal createLicense(int licenseId) throws CreateException {
        LicenseLocal license = this.licenseLocalHome.create(Integer.valueOf(licenseId));
        license.setNumber("value" + licenseId);
        return license;
    }

    private LicenseLocal findLicense(int licenseId) throws FinderException {
        return this.licenseLocalHome.findByPrimaryKey(Integer.valueOf(licenseId));
    }

    private void assertLinked(int personId, int licenseId) throws Exception {
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT name FROM Person WHERE id = " + personId);
        OneToOneTests.assertTrue((boolean)rs.next());
        OneToOneTests.assertEquals((Object)("value" + personId), (Object)rs.getString("name"));
        OneToOneTests.close(rs);
        rs = s.executeQuery("SELECT id, number FROM License WHERE person_id = " + personId);
        OneToOneTests.assertTrue((boolean)rs.next());
        OneToOneTests.assertEquals((long)licenseId, (long)rs.getInt("id"));
        OneToOneTests.assertEquals((Object)("value" + licenseId), (Object)rs.getString("number"));
        OneToOneTests.close(rs);
        OneToOneTests.close(s);
        OneToOneTests.close(c);
    }

    private void assertUnlinked(int personId) throws Exception {
        Connection c = this.ds.getConnection();
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM License WHERE person_id = " + personId);
        OneToOneTests.assertTrue((boolean)rs.next());
        OneToOneTests.assertEquals((long)0L, (long)rs.getInt(1));
        OneToOneTests.close(rs);
        OneToOneTests.close(s);
        OneToOneTests.close(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDB() throws Exception {
        Connection connection = this.ds.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            try {
                statement.execute("DELETE FROM Person");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                statement.execute("DELETE FROM License");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            OneToOneTests.close(statement);
            OneToOneTests.close(connection);
        }
        PersonLocal person1 = this.createPerson(1);
        this.createPerson(2);
        LicenseLocal license = this.createLicense(11);
        license.setPerson(person1);
    }

    protected void dump() throws Exception {
        OneToOneTests.dumpTable(this.ds, "Person");
        OneToOneTests.dumpTable(this.ds, "License");
    }
}

