/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.mdb;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.openejb.test.mdb.BasicMdbObject;
import org.apache.openejb.test.mdb.MdbProxy;
import org.apache.openejb.test.mdb.MdbTestClient;
import org.apache.openejb.test.mdb.MdbUtil;

public class MdbConnectionFactoryTests
extends MdbTestClient {
    public MdbConnectionFactoryTests() {
        super("ConnectionFactory.");
    }

    public void test01_createConnection() throws Exception {
        Connection connection = this.createConnection();
        try {
            MdbConnectionFactoryTests.assertNotNull((String)"Jms connection is null.", (Object)connection);
        }
        finally {
            MdbUtil.close((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test02_directRpc() throws Exception {
        Connection connection = this.createConnection();
        Session session = null;
        MessageProducer producer = null;
        MessageConsumer consumer = null;
        try {
            TreeMap<String, Object> request = new TreeMap<String, Object>();
            request.put("method", "businessMethod(java.lang.String)");
            request.put("args", new Object[]{"cheese"});
            session = connection.createSession(false, 1);
            Queue requestQueue = session.createQueue("BasicMdb");
            TemporaryQueue responseQueue = session.createTemporaryQueue();
            ObjectMessage requestMessage = session.createObjectMessage();
            requestMessage.setJMSReplyTo((Destination)responseQueue);
            requestMessage.setObject((Serializable)request);
            producer = session.createProducer((Destination)requestQueue);
            producer.send((Message)requestMessage);
            consumer = session.createConsumer((Destination)responseQueue);
            Message message = consumer.receive(1000L);
            MdbConnectionFactoryTests.assertNotNull((String)"Did not get a response message", (Object)message);
            MdbConnectionFactoryTests.assertTrue((String)"Response message is not an ObjectMessage", (boolean)(message instanceof ObjectMessage));
            ObjectMessage responseMessage = (ObjectMessage)message;
            Serializable object = responseMessage.getObject();
            MdbConnectionFactoryTests.assertNotNull((Object)"Response ObjectMessage contains a null object");
            MdbConnectionFactoryTests.assertTrue((String)"Response ObjectMessage does not contain an instance of Map", (boolean)(object instanceof Map));
            Map response = (Map)((Object)object);
            if (response.containsKey("exception")) {
                throw (Exception)response.get("return");
            }
            String returnValue = (String)response.get("return");
            MdbConnectionFactoryTests.assertEquals((Object)"eseehc", (Object)returnValue);
        }
        catch (Throwable throwable) {
            MdbUtil.close(producer);
            MdbUtil.close(session);
            MdbUtil.close((Connection)connection);
            throw throwable;
        }
        MdbUtil.close((MessageProducer)producer);
        MdbUtil.close((Session)session);
        MdbUtil.close((Connection)connection);
    }

    public void test03_proxy() throws Exception {
        BasicMdbObject basicMdbObject = (BasicMdbObject)MdbProxy.newProxyInstance(BasicMdbObject.class, (ConnectionFactory)this.connectionFactory, (String)"BasicMdb");
        try {
            String returnValue = basicMdbObject.businessMethod("blah");
            MdbConnectionFactoryTests.assertEquals((Object)"halb", (Object)returnValue);
        }
        finally {
            MdbProxy.destroyProxy((Object)basicMdbObject);
        }
    }
}

