/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import org.apache.openejb.test.singleton.BasicSingletonHome;
import org.apache.openejb.test.singleton.BasicSingletonTestClient;

public class SingletonEjbObjectTests
extends BasicSingletonTestClient {
    public SingletonEjbObjectTests() {
        super("EJBObject.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/singleton/BasicSingletonHome");
        this.ejbHome = (BasicSingletonHome)obj;
        this.ejbObject = this.ejbHome.createObject();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test01_getHandle() {
        try {
            this.ejbHandle = this.ejbObject.getHandle();
            SingletonEjbObjectTests.assertNotNull((String)"The Handle is null", (Object)this.ejbHandle);
        }
        catch (Exception e) {
            SingletonEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_isIdentical() {
        try {
            SingletonEjbObjectTests.assertTrue((String)"The EJBObjects are not identical", (boolean)this.ejbObject.isIdentical((EJBObject)this.ejbObject));
        }
        catch (Exception e) {
            SingletonEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_getEjbHome() {
        try {
            EJBHome home = this.ejbObject.getEJBHome();
            SingletonEjbObjectTests.assertNotNull((String)"The EJBHome is null", (Object)home);
        }
        catch (Exception e) {
            SingletonEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_getPrimaryKey() {
        try {
            Object object = this.ejbObject.getPrimaryKey();
        }
        catch (RemoteException e) {
            SingletonEjbObjectTests.assertTrue((boolean)true);
            return;
        }
        catch (Exception e) {
            SingletonEjbObjectTests.fail((String)("A RuntimeException should have been thrown.  Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        SingletonEjbObjectTests.fail((String)"A RuntimeException should have been thrown.");
    }

    public void test05_remove() {
        try {
            this.ejbObject.remove();
            this.ejbObject.businessMethod("Should not throw an exception");
        }
        catch (Exception e) {
            SingletonEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test06_remove() {
        String str = null;
        try {
            str = this.ejbObject.remove("Hello");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        SingletonEjbObjectTests.assertEquals((Object)"Hello", (Object)str);
    }
}

