/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.stateful;

import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import org.apache.openejb.test.stateful.BasicStatefulHome;
import org.apache.openejb.test.stateful.BasicStatefulObject;
import org.apache.openejb.test.stateful.BasicStatefulTestClient;

public class StatefulPojoEjbObjectTests
extends BasicStatefulTestClient {
    public StatefulPojoEjbObjectTests() {
        super("PojoEJBObject.");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object obj = this.initialContext.lookup("client/tests/stateful/BasicStatefulPojoHome");
        this.ejbHome = (BasicStatefulHome)obj;
        this.ejbObject = this.ejbHome.createObject("First Bean");
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test01_getEjbHome() {
        try {
            EJBHome home = this.ejbObject.getEJBHome();
            StatefulPojoEjbObjectTests.assertNotNull((String)"The EJBHome is null", (Object)home);
        }
        catch (Exception e) {
            StatefulPojoEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test02_getHandle() {
        try {
            this.ejbHandle = this.ejbObject.getHandle();
            StatefulPojoEjbObjectTests.assertNotNull((String)"The Handle is null", (Object)this.ejbHandle);
        }
        catch (Exception e) {
            StatefulPojoEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test03_isIdentical() {
        BasicStatefulObject otherEJBObject = null;
        BasicStatefulObject JustAnotherEJBObject = null;
        try {
            otherEJBObject = this.ejbHome.createObject("Second bean");
            JustAnotherEJBObject = this.ejbHome.createObject("First bean");
            StatefulPojoEjbObjectTests.assertTrue((String)"The EJBObjects are not equal", (boolean)this.ejbObject.isIdentical((EJBObject)this.ejbObject));
            StatefulPojoEjbObjectTests.assertFalse((String)"The EJBObjects are not equal", (boolean)this.ejbObject.isIdentical((EJBObject)otherEJBObject));
            StatefulPojoEjbObjectTests.assertFalse((String)"The EJBObjects are not equal", (boolean)this.ejbObject.isIdentical((EJBObject)JustAnotherEJBObject));
        }
        catch (Exception e) {
            StatefulPojoEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test04_remove() {
        try {
            this.ejbObject.remove();
            try {
                this.ejbObject.businessMethod("Should throw an exception");
                StatefulPojoEjbObjectTests.assertTrue((String)"Calling business method after removing the EJBObject does not throw an exception", (boolean)false);
            }
            catch (Exception e) {
                StatefulPojoEjbObjectTests.assertTrue((boolean)true);
                return;
            }
        }
        catch (Exception e) {
            StatefulPojoEjbObjectTests.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
    }

    public void test05_getPrimaryKey() {
        try {
            Object object = this.ejbObject.getPrimaryKey();
        }
        catch (RemoteException e) {
            StatefulPojoEjbObjectTests.assertTrue((boolean)true);
            return;
        }
        catch (Exception e) {
            StatefulPojoEjbObjectTests.fail((String)("A RuntimeException should have been thrown.  Received Exception " + e.getClass() + " : " + e.getMessage()));
        }
        StatefulPojoEjbObjectTests.fail((String)"A RuntimeException should have been thrown.");
    }
}

