/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.jee.jba;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.w3c.dom.Element;


@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "content"
})
@XmlRootElement(name = "interceptor")
public class Interceptor {

    @XmlAttribute
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String transaction;
    @XmlAttribute
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String metricsEnabled;
    @XmlAttribute(name = "call-by-value")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String callByValue;
    @XmlMixed
    @XmlAnyElement
    protected List<Object> content;

    /**
     * Gets the value of the transaction property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getTransaction() {
        if (transaction == null) {
            return "Both";
        } else {
            return transaction;
        }
    }

    /**
     * Sets the value of the transaction property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setTransaction(final String value) {
        this.transaction = value;
    }

    /**
     * Gets the value of the metricsEnabled property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getMetricsEnabled() {
        if (metricsEnabled == null) {
            return "false";
        } else {
            return metricsEnabled;
        }
    }

    /**
     * Sets the value of the metricsEnabled property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setMetricsEnabled(final String value) {
        this.metricsEnabled = value;
    }

    /**
     * Gets the value of the callByValue property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getCallByValue() {
        return callByValue;
    }

    /**
     * Sets the value of the callByValue property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setCallByValue(final String value) {
        this.callByValue = value;
    }

    /**
     * Gets the value of the content property.
     * <p/>
     * <p/>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the content property.
     * <p/>
     * <p/>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContent().add(newItem);
     * </pre>
     * <p/>
     * <p/>
     * <p/>
     * Objects of the following type(s) are allowed in the list
     * {@link Element }
     * {@link String }
     */
    public List<Object> getContent() {
        if (content == null) {
            content = new ArrayList<Object>();
        }
        return this.content;
    }

}
