/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.jee.oejb2;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for portType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="portType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="port-name" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;group ref="{http://geronimo.apache.org/xml/ns/naming-1.2}serverGroup" minOccurs="0"/&gt;
 *         &lt;element name="uri" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="credentials-name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "portType", namespace = "http://geronimo.apache.org/xml/ns/naming-1.2", propOrder = {
    "portName",
    "protocol",
    "host",
    "port",
    "uri",
    "credentialsName"
})
public class PortType {

    @XmlElement(name = "port-name", required = true)
    protected String portName;
    protected String protocol;
    protected String host;
    protected Integer port;
    @XmlElement(required = true)
    protected String uri;
    @XmlElement(name = "credentials-name")
    protected String credentialsName;

    /**
     * Gets the value of the portName property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getPortName() {
        return portName;
    }

    /**
     * Sets the value of the portName property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setPortName(final String value) {
        this.portName = value;
    }

    /**
     * Gets the value of the protocol property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getProtocol() {
        return protocol;
    }

    /**
     * Sets the value of the protocol property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setProtocol(final String value) {
        this.protocol = value;
    }

    /**
     * Gets the value of the host property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getHost() {
        return host;
    }

    /**
     * Sets the value of the host property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setHost(final String value) {
        this.host = value;
    }

    /**
     * Gets the value of the port property.
     *
     * @return possible object is
     * {@link Integer }
     */
    public Integer getPort() {
        return port;
    }

    /**
     * Sets the value of the port property.
     *
     * @param value allowed object is
     *              {@link Integer }
     */
    public void setPort(final Integer value) {
        this.port = value;
    }

    /**
     * Gets the value of the uri property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getUri() {
        return uri;
    }

    /**
     * Sets the value of the uri property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setUri(final String value) {
        this.uri = value;
    }

    /**
     * Gets the value of the credentialsName property.
     *
     * @return possible object is
     * {@link String }
     */
    public String getCredentialsName() {
        return credentialsName;
    }

    /**
     * Sets the value of the credentialsName property.
     *
     * @param value allowed object is
     *              {@link String }
     */
    public void setCredentialsName(final String value) {
        this.credentialsName = value;
    }

}
