/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.openejb.jee.HandlerChainsStringQNameAdapter;
import org.apache.openejb.jee.JAXBContextFactory;
import org.apache.openejb.jee.JavaeeSchema;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class JaxbJavaee {
    public static final ThreadLocal<Set<String>> currentPublicId = new ThreadLocal();
    private static final Map<Class<?>, JAXBContext> jaxbContexts = new HashMap();

    public static <T> String marshal(Class<T> type, Object object) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JaxbJavaee.marshal(type, object, baos);
        return new String(baos.toByteArray());
    }

    public static <T> void marshal(Class<T> type, Object object, OutputStream out) throws JAXBException {
        JAXBContext ctx2 = JaxbJavaee.getContext(type);
        Marshaller marshaller = ctx2.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(object, out);
    }

    public static <T> JAXBContext getContext(Class<T> type) throws JAXBException {
        JAXBContext jaxbContext = jaxbContexts.get(type);
        if (jaxbContext == null) {
            jaxbContext = JAXBContextFactory.newInstance(type);
            jaxbContexts.put(type, jaxbContext);
        }
        return jaxbContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Object unmarshalJavaee(Class<T> type, InputStream in, boolean filter) throws ParserConfigurationException, SAXException, JAXBException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        JAXBContext ctx = JaxbJavaee.getContext(type);
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                String verbose = System.getProperty("openejb.validation.output.level");
                if (verbose != null && "VERBOSE".equals(verbose.toUpperCase(Locale.ENGLISH))) {
                    System.err.println(validationEvent);
                }
                return false;
            }
        });
        SAXSource source = null;
        if (filter) {
            JavaeeNamespaceFilter xmlFilter = new JavaeeNamespaceFilter(parser.getXMLReader());
            xmlFilter.setContentHandler((ContentHandler)unmarshaller.getUnmarshallerHandler());
            source = new SAXSource(xmlFilter, new InputSource(in));
        } else {
            source = new SAXSource(new InputSource(in));
        }
        currentPublicId.set(new TreeSet());
        try {
            JAXBElement element = unmarshaller.unmarshal((Source)source, type);
            Object object = element.getValue();
            return object;
        }
        finally {
            currentPublicId.set(null);
        }
    }

    public static <T> Object unmarshal(Class<T> type, InputStream in) throws ParserConfigurationException, SAXException, JAXBException {
        return JaxbJavaee.unmarshalJavaee(type, in, false);
    }

    public static <T> Object unmarshalJavaee(Class<T> type, InputStream in) throws ParserConfigurationException, SAXException, JAXBException {
        return JaxbJavaee.unmarshalJavaee(type, in, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Object unmarshal(Class<T> type, InputStream in, boolean validate) throws ParserConfigurationException, SAXException, JAXBException {
        InputSource inputSource = new InputSource(in);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(validate);
        SAXParser parser = factory.newSAXParser();
        JAXBContext ctx = JaxbJavaee.getContext(type);
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                System.out.println(validationEvent);
                return false;
            }
        });
        NoSourceFilter xmlFilter = new NoSourceFilter(parser.getXMLReader());
        xmlFilter.setContentHandler((ContentHandler)unmarshaller.getUnmarshallerHandler());
        SAXSource source = new SAXSource(xmlFilter, inputSource);
        currentPublicId.set(new TreeSet());
        try {
            Object object = unmarshaller.unmarshal((Source)source);
            return object;
        }
        finally {
            currentPublicId.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Object unmarshalTaglib(Class<T> type, InputStream in) throws ParserConfigurationException, SAXException, JAXBException {
        InputSource inputSource = new InputSource(in);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        JAXBContext ctx = JaxbJavaee.getContext(type);
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                System.out.println(validationEvent);
                return false;
            }
        });
        TaglibNamespaceFilter xmlFilter = new TaglibNamespaceFilter(parser.getXMLReader());
        xmlFilter.setContentHandler((ContentHandler)unmarshaller.getUnmarshallerHandler());
        SAXSource source = new SAXSource(xmlFilter, inputSource);
        currentPublicId.set(new TreeSet());
        try {
            Object object = unmarshaller.unmarshal((Source)source);
            return object;
        }
        finally {
            currentPublicId.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Object unmarshalHandlerChains(Class<T> type, InputStream in) throws ParserConfigurationException, SAXException, JAXBException {
        InputSource inputSource = new InputSource(in);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        JAXBContext ctx = JaxbJavaee.getContext(type);
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                System.out.println(validationEvent);
                return false;
            }
        });
        HandlerChainsNamespaceFilter xmlFilter = new HandlerChainsNamespaceFilter(parser.getXMLReader());
        xmlFilter.setContentHandler((ContentHandler)unmarshaller.getUnmarshallerHandler());
        HandlerChainsStringQNameAdapter adapter = new HandlerChainsStringQNameAdapter();
        adapter.setHandlerChainsNamespaceFilter(xmlFilter);
        unmarshaller.setAdapter(HandlerChainsStringQNameAdapter.class, (XmlAdapter)adapter);
        SAXSource source = new SAXSource(xmlFilter, inputSource);
        currentPublicId.set(new TreeSet());
        try {
            Object object = unmarshaller.unmarshal((Source)source);
            return object;
        }
        finally {
            currentPublicId.set(null);
        }
    }

    public static void validateJavaee(JavaeeSchema type, InputStream in) throws ParserConfigurationException, SAXException, IOException {
        URL javaeeSchemaURL = JaxbJavaee.resolveJavaeeSchemaURL(type);
        if (javaeeSchemaURL == null) {
            throw new IllegalArgumentException("Can not find the xsd file against type:" + (Object)((Object)type));
        }
        URL xmlSchemaURL = JaxbJavaee.getSchemaURL("xml.xsd");
        if (xmlSchemaURL == null) {
            throw new IllegalArgumentException("Can not find the xml.xsd file");
        }
        SAXParserFactory parserfactory = SAXParserFactory.newInstance();
        parserfactory.setNamespaceAware(true);
        parserfactory.setValidating(false);
        SAXParser parser = parserfactory.newSAXParser();
        Javaee6SchemaFilter xmlFilter = new Javaee6SchemaFilter(parser.getXMLReader());
        SAXSource sourceForValidate = new SAXSource(xmlFilter, new InputSource(in));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        JaxbJavaeeSchemaResourceResolver resourceResolver = new JaxbJavaeeSchemaResourceResolver();
        schemaFactory.setResourceResolver(resourceResolver);
        Schema schema = schemaFactory.newSchema(new Source[]{new StreamSource(xmlSchemaURL.openStream()), new StreamSource(javaeeSchemaURL.openStream())});
        schema.newValidator().validate(sourceForValidate);
    }

    private static URL getSchemaURL(String xsdFileName) {
        return JaxbJavaee.class.getClassLoader().getResource("/META-INF/schema/" + xsdFileName);
    }

    private static URL resolveJavaeeSchemaURL(JavaeeSchema type) {
        URL schemaURL = null;
        if (type.equals((Object)JavaeeSchema.WEB_APP_3_0)) {
            schemaURL = JaxbJavaee.getSchemaURL(JavaeeSchema.WEB_APP_3_0.getSchemaFileName());
        } else if (type.equals((Object)JavaeeSchema.EJB_JAR_3_1)) {
            schemaURL = JaxbJavaee.getSchemaURL(JavaeeSchema.EJB_JAR_3_1.getSchemaFileName());
        } else if (type.equals((Object)JavaeeSchema.APPLICATION_6)) {
            schemaURL = JaxbJavaee.getSchemaURL(JavaeeSchema.APPLICATION_6.getSchemaFileName());
        } else if (type.equals((Object)JavaeeSchema.APPLICATION_CLIENT_6)) {
            schemaURL = JaxbJavaee.getSchemaURL(JavaeeSchema.APPLICATION_CLIENT_6.getSchemaFileName());
        } else if (type.equals((Object)JavaeeSchema.CONNECTOR_1_6)) {
            schemaURL = JaxbJavaee.getSchemaURL(JavaeeSchema.CONNECTOR_1_6.getSchemaFileName());
        }
        return schemaURL;
    }

    public static class JavaeeNamespaceFilter
    extends XMLFilterImpl {
        private static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));
        private boolean ignore = false;

        public JavaeeNamespaceFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            Set<String> publicIds = currentPublicId.get();
            if (publicIds != null) {
                publicIds.add(publicId);
            }
            return EMPTY_INPUT_SOURCE;
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            if (this.ignore) {
                return;
            }
            if (uri != null && (uri.startsWith("http://jboss.org") || uri.startsWith("urn:java:"))) {
                this.ignore = true;
            } else {
                super.startElement("http://java.sun.com/xml/ns/javaee", localName, qname, atts);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.ignore) {
                super.characters(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (!this.ignore) {
                super.ignorableWhitespace(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (uri != null && (uri.startsWith("http://jboss.org") || uri.startsWith("urn:java:"))) {
                this.ignore = false;
            } else if (!this.ignore) {
                super.endElement("http://java.sun.com/xml/ns/javaee", localName, qName);
            }
        }
    }

    public static class NoSourceFilter
    extends XMLFilterImpl {
        protected static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));

        public NoSourceFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        protected String eeUri(String uri) {
            return "http://xmlns.jcp.org/xml/ns/javaee".equals(uri) ? "http://java.sun.com/xml/ns/javaee" : uri;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(this.eeUri(uri), localName, qName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(this.eeUri(uri), localName, qName);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            Set<String> publicIds = currentPublicId.get();
            if (publicIds != null) {
                publicIds.add(publicId);
            }
            return EMPTY_INPUT_SOURCE;
        }
    }

    public static class TaglibNamespaceFilter
    extends XMLFilterImpl {
        private static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));

        public TaglibNamespaceFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            Set<String> publicIds = currentPublicId.get();
            if (publicIds != null) {
                publicIds.add(publicId);
            }
            return EMPTY_INPUT_SOURCE;
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            localName = this.fixLocalName(localName);
            super.startElement("http://java.sun.com/xml/ns/javaee", localName, qname, atts);
        }

        private String fixLocalName(String localName) {
            switch (localName) {
                case "tlibversion": {
                    localName = "tlib-version";
                    break;
                }
                case "jspversion": {
                    localName = "jsp-version";
                    break;
                }
                case "shortname": {
                    localName = "short-name";
                    break;
                }
                case "tagclass": {
                    localName = "tag-class";
                    break;
                }
                case "teiclass": {
                    localName = "tei-class";
                    break;
                }
                case "bodycontent": {
                    localName = "body-content";
                    break;
                }
                case "info": {
                    localName = "description";
                }
            }
            return localName;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            localName = this.fixLocalName(localName);
            super.endElement("http://java.sun.com/xml/ns/javaee", localName, qName);
        }
    }

    public static class HandlerChainsNamespaceFilter
    extends XMLFilterImpl {
        private static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));
        private final Stack<Map.Entry<String, String>> effectiveNamespaces = new Stack();

        public HandlerChainsNamespaceFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            Set<String> publicIds = currentPublicId.get();
            if (publicIds != null) {
                publicIds.add(publicId);
            }
            return EMPTY_INPUT_SOURCE;
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            super.startElement("http://java.sun.com/xml/ns/javaee", localName, qname, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement("http://java.sun.com/xml/ns/javaee", localName, qName);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.effectiveNamespaces.pop();
            super.endPrefixMapping(prefix);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.effectiveNamespaces.push(new AbstractMap.SimpleEntry<String, String>(prefix, uri));
            super.startPrefixMapping(prefix, uri);
        }

        public String lookupNamespaceURI(String prefix) {
            for (int index = this.effectiveNamespaces.size() - 1; index >= 0; --index) {
                Map.Entry entry = (Map.Entry)this.effectiveNamespaces.get(index);
                if (!((String)entry.getKey()).equals(prefix)) continue;
                return (String)entry.getValue();
            }
            return null;
        }
    }

    public static class Javaee6SchemaFilter
    extends XMLFilterImpl {
        private static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));

        public Javaee6SchemaFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            Set<String> publicIds = currentPublicId.get();
            if (publicIds != null) {
                publicIds.add(publicId);
            }
            return EMPTY_INPUT_SOURCE;
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            super.startElement("http://java.sun.com/xml/ns/javaee", localName, qname, this.fixVersion(localName, atts));
        }

        private Attributes fixVersion(String localName, Attributes atts) {
            if (localName.equals("web-app") && atts.getIndex("version") != -1 && !atts.getValue(atts.getIndex("version")).equals("3.0")) {
                AttributesImpl newAtts = new AttributesImpl(atts);
                newAtts.setValue(newAtts.getIndex("version"), "3.0");
                return newAtts;
            }
            if (localName.equals("ejb-jar") && atts.getIndex("version") != -1 && !atts.getValue(atts.getIndex("version")).equals("3.1")) {
                AttributesImpl newAtts = new AttributesImpl(atts);
                newAtts.setValue(newAtts.getIndex("version"), "3.1");
                return newAtts;
            }
            if (localName.equals("application") && atts.getIndex("version") != -1 && !atts.getValue(atts.getIndex("version")).equals("6")) {
                AttributesImpl newAtts = new AttributesImpl(atts);
                newAtts.setValue(newAtts.getIndex("version"), "6");
                return newAtts;
            }
            if (localName.equals("application-client") && atts.getIndex("version") != -1 && !atts.getValue(atts.getIndex("version")).equals("6")) {
                AttributesImpl newAtts = new AttributesImpl(atts);
                newAtts.setValue(newAtts.getIndex("version"), "6");
                return newAtts;
            }
            if (localName.equals("connector") && atts.getIndex("version") != -1 && !atts.getValue(atts.getIndex("version")).equals("1.6")) {
                AttributesImpl newAtts = new AttributesImpl(atts);
                newAtts.setValue(newAtts.getIndex("version"), "1.6");
                return newAtts;
            }
            return atts;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement("http://java.sun.com/xml/ns/javaee", localName, qName);
        }
    }

    static class JaxbJavaeeSchemaResourceResolver
    implements LSResourceResolver {
        JaxbJavaeeSchemaResourceResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            LSInputImpl lsInput = new LSInputImpl();
            URL schemaURL = JaxbJavaee.getSchemaURL(systemId);
            InputStream is = null;
            if (schemaURL != null) {
                try {
                    is = schemaURL.openStream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            lsInput.setSystemId(systemId);
            lsInput.setByteStream(is);
            return lsInput;
        }

        class LSInputImpl
        implements LSInput {
            private String publicId;
            private String systemId;
            private String baseURI;
            private InputStream byteStream;
            private Reader charStream;
            private String stringData;
            private String encoding;
            private boolean certifiedText;

            public LSInputImpl() {
            }

            public LSInputImpl(String publicId, String systemId, InputStream byteStream) {
                this.publicId = publicId;
                this.systemId = systemId;
                this.byteStream = byteStream;
            }

            @Override
            public String getBaseURI() {
                return this.baseURI;
            }

            @Override
            public InputStream getByteStream() {
                return this.byteStream;
            }

            @Override
            public boolean getCertifiedText() {
                return this.certifiedText;
            }

            @Override
            public Reader getCharacterStream() {
                return this.charStream;
            }

            @Override
            public String getEncoding() {
                return this.encoding;
            }

            @Override
            public String getPublicId() {
                return this.publicId;
            }

            @Override
            public String getStringData() {
                return this.stringData;
            }

            @Override
            public String getSystemId() {
                return this.systemId;
            }

            @Override
            public void setBaseURI(String baseURI) {
                this.baseURI = baseURI;
            }

            @Override
            public void setByteStream(InputStream byteStream) {
                this.byteStream = byteStream;
            }

            @Override
            public void setCertifiedText(boolean certifiedText) {
                this.certifiedText = certifiedText;
            }

            @Override
            public void setCharacterStream(Reader characterStream) {
                this.charStream = characterStream;
            }

            @Override
            public void setEncoding(String encoding) {
                this.encoding = encoding;
            }

            @Override
            public void setPublicId(String publicId) {
                this.publicId = publicId;
            }

            @Override
            public void setStringData(String stringData) {
                this.stringData = stringData;
            }

            @Override
            public void setSystemId(String systemId) {
                this.systemId = systemId;
            }
        }
    }
}

